/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.executor.ThreadPoolEnum;
import kd.taxc.bdtaxr.business.executor.ThreadPoolJdkBusiness;
import kd.taxc.bdtaxr.business.executor.ThreadPoolV6Business;
import kd.taxc.bdtaxr.common.executor.Task;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class TaxcThreadPoolHelper {
    private static Log logger = LogFactory.getLog(TaxcThreadPoolHelper.class);

    public static Future<Object> submit(Callable call, ThreadPoolEnum poolEnum, RequestContext context, OperationContext oc) {
        try {
            Class.forName("kd.bos.unifiedthreadpool.api.ThreadExecutorService");
            return ThreadPoolV6Business.submit(call, poolEnum.getName(), context, oc);
        }
        catch (ClassNotFoundException e) {
            logger.info("v6.0 notsupport,use jdk threadpool,poolname is" + poolEnum.getName());
            return ThreadPoolJdkBusiness.submit(call, poolEnum.getName());
        }
    }

    public static List<Future<Object>> submitBlock(Task task, ThreadPoolEnum poolEnum) {
        return TaxcThreadPoolHelper.submit(task, poolEnum, null, true);
    }

    public static List<Future<Object>> submitNoBlock(Task task, ThreadPoolEnum poolEnum) {
        return TaxcThreadPoolHelper.submit(task, poolEnum, null, false);
    }

    public static List<Future<Object>> submit(Task task, ThreadPoolEnum poolEnum, boolean block) {
        return TaxcThreadPoolHelper.submit(task, poolEnum, null, block);
    }

    public static List<Future<Object>> submit(Task task, ThreadPoolEnum poolEnum, OperationContext oc, boolean block) {
        RequestContext rc = RequestContext.copyAndSet((RequestContext)RequestContext.get());
        List values = task.getValue();
        ArrayList<Future<Object>> list = new ArrayList<Future<Object>>(values.size());
        for (Object t : values) {
            list.add(TaxcThreadPoolHelper.submit(task.call(rc, t), poolEnum, rc, oc));
        }
        if (block) {
            for (Future future : list) {
                String info;
                try {
                    future.get(600L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    info = "thread has been interrupted:";
                    logger.info(info + e.getMessage());
                    return list;
                }
                catch (ExecutionException e) {
                    String msg = null;
                    msg = e.getCause() != null ? ExceptionUtils.getStackTrace((Throwable)e.getCause()) : ExceptionUtils.getStackTrace((Throwable)e);
                    throw new KDBizException("get future erro:" + msg);
                }
                catch (TimeoutException e) {
                    info = "time out and thread recover";
                    logger.info(info + e.getMessage());
                }
            }
        }
        return list;
    }
}

