/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper.bastax.taxcorg;

import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.business.TaxcDataLoadBusiness;
import kd.taxc.bdtaxr.business.TaxcOrgBusiness;
import kd.taxc.bdtaxr.common.constant.bastax.TaxcOrgConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.utils.DyoToDtoUtils;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;

public class TaxcOrgDataServiceHelper {
    public static TaxResult<Boolean> isTaxcOrgExistByOrgId(Long orgId) {
        return ServiceInvokeUtils.invokeBampService(Boolean.class, "TaxcOrgMService", "isTaxcOrgExistByOrgId", orgId, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<Boolean> isTaxcOrgExistByOrgId(Long orgId, Long taxationsysId) {
        return ServiceInvokeUtils.invokeBampService(Boolean.class, "TaxcOrgMService", "isTaxcOrgExistByOrgId", orgId, taxationsysId);
    }

    public static TaxResult<Boolean> isTaxcOrgExistByOrgIdAndIsTaxpayer(Long orgId) {
        return ServiceInvokeUtils.invokeBampService(Boolean.class, "TaxcOrgMService", "isTaxcOrgExistByOrgIdAndIsTaxpayer", orgId, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<Long> queryTaxcOrgIdByOrgNum(String orgNum) {
        return ServiceInvokeUtils.invokeBampService(Long.class, "TaxcOrgMService", "queryTaxcOrgIdByOrgNum", orgNum, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<DynamicObject> queryTaxcOrgByOrgIdIsTaxpayer(Long orgId) {
        TaxResult<DynamicObject> taxResult = ServiceInvokeUtils.invokeBampServiceWithObj(TaxcOrgConstant.ENTITYNAME, "TaxcOrgMService", "queryTaxcOrgByOrgIdIsTaxpayer", orgId, TaxationsysMappingEnum.CHN.getId());
        if (taxResult != null && taxResult.getData() != null) {
            TaxcOrgBusiness.filterDataBytaxationsysId(taxResult.getData(), TaxationsysMappingEnum.CHN.getId(), Boolean.TRUE);
        }
        return taxResult;
    }

    public static TaxResult<DynamicObject> queryTaxcOrgByOrgId(Long orgId) {
        TaxResult<DynamicObject> taxResult = ServiceInvokeUtils.invokeBampServiceWithObj(TaxcOrgConstant.ENTITYNAME, "TaxcOrgMService", "queryTaxcOrgByOrgId", orgId, TaxationsysMappingEnum.CHN.getId());
        if (taxResult != null) {
            TaxcOrgBusiness.filterDataBytaxationsysId((DynamicObject)taxResult.getData(), TaxationsysMappingEnum.CHN.getId(), Boolean.TRUE);
        }
        return taxResult;
    }

    public static TaxResult<List<String>> queryAllTaxcUnifiedsocialcode() {
        return ServiceInvokeUtils.invokeBampService(String.class, "TaxcOrgMService", "queryAllTaxcUnifiedsocialcode", TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<String>> queryTaxcUnifiedsocialcodeByOrgId(List<Long> orgIds) {
        return ServiceInvokeUtils.invokeBampService(String.class, "TaxcOrgMService", "queryTaxcUnifiedsocialcodeByOrgId", orgIds, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<DynamicObject>> queryTaxcOrgByOrgIdAndIsTaxpayer(List<Long> orgIds) {
        TaxResult<List<DynamicObject>> listTaxResult = ServiceInvokeUtils.invokeBampServiceWithObj(TaxcOrgConstant.ENTITYNAME, "TaxcOrgMService", "queryTaxcOrgByOrgIdAndIsTaxpayer", orgIds, TaxationsysMappingEnum.CHN.getId());
        if (listTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData()))) {
            listTaxResult.setData(TaxcOrgBusiness.queryTaxcOrgByTaxationsysId(listTaxResult.getData(), TaxationsysMappingEnum.CHN.getId(), Boolean.TRUE));
        }
        return listTaxResult;
    }

    public static TaxResult<List<Long>> queryTaxcOrgIdByOrgId(List<Long> orgIds) {
        return ServiceInvokeUtils.invokeBampService(Long.class, "TaxcOrgMService", "queryTaxcOrgIdByOrgIds", orgIds, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<DynamicObject>> queryTaxcOrgByOrgIds(List<Long> orgIds) {
        TaxResult<List<DynamicObject>> listTaxResult = ServiceInvokeUtils.invokeBampServiceWithObj(TaxcOrgConstant.ENTITYNAME, "TaxcOrgMService", "queryTaxcOrgByOrgIds", orgIds, TaxationsysMappingEnum.CHN.getId());
        if (listTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData()))) {
            listTaxResult.setData(TaxcOrgBusiness.queryTaxcOrgByTaxationsysId(listTaxResult.getData(), TaxationsysMappingEnum.CHN.getId(), Boolean.TRUE));
        }
        return listTaxResult;
    }

    public static TaxResult<List<DynamicObject>> queryTaxcOrgByOrgIds(List<Long> orgIds, Long taxationsysId) {
        TaxResult<List<DynamicObject>> listTaxResult = ServiceInvokeUtils.invokeBampServiceWithObj(TaxcOrgConstant.ENTITYNAME, "TaxcOrgMService", "queryTaxcOrgByOrgIds", orgIds, taxationsysId);
        if (listTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData()))) {
            listTaxResult.setData(TaxcOrgBusiness.queryTaxcOrgByTaxationsysId(listTaxResult.getData(), TaxationsysMappingEnum.CHN.getId(), Boolean.TRUE));
        }
        return listTaxResult;
    }

    public static TaxResult<List<Long>> queryTaxcOrgIdByIsTaxpayer() {
        return ServiceInvokeUtils.invokeBampService(Long.class, "TaxcOrgMService", "queryTaxcOrgIdByIsTaxpayer", TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<Long>> queryTaxcOrgIdByIsTaxpayer(Long taxationsysId) {
        return ServiceInvokeUtils.invokeBampService(Long.class, "TaxcOrgMService", "queryTaxcOrgIdByIsTaxpayer", taxationsysId);
    }

    public static TaxResult<List<Long>> queryTaxcOrgIdByUnifiedsocialcode(List<String> unifiedsocialcodes) {
        return ServiceInvokeUtils.invokeBampService(Long.class, "TaxcOrgMService", "queryTaxcOrgIdByUnifiedsocialcode", unifiedsocialcodes, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<DynamicObject>> queryTaxcOrgByUnifiedsocialcode(List<String> unifiedsocialcodes) {
        return ServiceInvokeUtils.invokeBampServiceWithObj(TaxcOrgConstant.ENTITYNAME, "TaxcOrgMService", "queryTaxcOrgByUnifiedsocialcode", unifiedsocialcodes, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<Long>> queryAllTaxcOrgId() {
        return ServiceInvokeUtils.invokeBampService(Long.class, "TaxcOrgMService", "queryAllTaxcOrgId", TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<Long>> queryAllTaxcOrgId(Long taxationsysId) {
        return ServiceInvokeUtils.invokeBampService(Long.class, "TaxcOrgMService", "queryAllTaxcOrgId", taxationsysId);
    }

    public static TaxResult<List<Long>> queryTaxOrgIdsByStatusAndIsvirtual(Boolean isEnable, Boolean isVirtual) {
        return ServiceInvokeUtils.invokeBampService(Long.class, "TaxcOrgMService", "queryTaxOrgIdsByStatusAndIsvirtual", isEnable, isVirtual, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<String>> queryAllTaxcOrgNumbers() {
        return ServiceInvokeUtils.invokeBampService(String.class, "TaxcOrgMService", "queryAllTaxcOrgNumbers", TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<DynamicObject>> queryTaxcOrgByOrgNum(List<String> orgNums) {
        TaxResult<List<DynamicObject>> listTaxResult = ServiceInvokeUtils.invokeBampServiceWithObj(TaxcOrgConstant.ENTITYNAME, "TaxcOrgMService", "queryTaxcOrgByOrgNum", orgNums, TaxationsysMappingEnum.CHN.getId());
        if (listTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData()))) {
            listTaxResult.setData(TaxcOrgBusiness.queryTaxcOrgByTaxationsysId(listTaxResult.getData(), TaxationsysMappingEnum.CHN.getId(), Boolean.TRUE));
        }
        return listTaxResult;
    }

    public static TaxResult<Boolean> isTaxcOrgExistByOrgNum(String orgNum) {
        return ServiceInvokeUtils.invokeBampService(Boolean.class, "TaxcOrgMService", "isTaxcOrgExistByOrgNum", orgNum, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<Long> queryTaxcOrgIdByTaxpayer(String taxpayer) {
        return ServiceInvokeUtils.invokeBampService(Long.class, "TaxcOrgMService", "queryTaxcOrgIdByTaxpayer", taxpayer, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<DynamicObject> queryTaxcOrgByTaxpayer(String taxpayer) {
        return ServiceInvokeUtils.invokeBampServiceWithObj(TaxcOrgConstant.ENTITYNAME, "TaxcOrgMService", "queryTaxcOrgByTaxpayer", taxpayer, TaxationsysMappingEnum.CHN.getId());
    }

    public static TaxResult<List<DynamicObject>> queryTaxcOrgByOrgIdsAndTaxationsysId(List<Long> orgIds, Long taxationsysId) {
        TaxResult<List<DynamicObject>> listTaxResult = ServiceInvokeUtils.invokeBampServiceWithObj(TaxcOrgConstant.ENTITYNAME, "TaxcOrgMService", "queryTaxcOrgByOrgIds", orgIds, taxationsysId);
        if (listTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData())) && taxationsysId != null) {
            listTaxResult.setData(TaxcOrgBusiness.queryTaxcOrgByTaxationsysId(listTaxResult.getData(), taxationsysId, Boolean.TRUE));
        }
        return listTaxResult;
    }

    public static TaxResult<List<DynamicObject>> queryTaxcOrgByOrgIdsAndTaxationsysId(List<Long> orgIds, Long taxationsysId, boolean isIncludeDisable) {
        TaxResult<List<DynamicObject>> listTaxResult = ServiceInvokeUtils.invokeBampServiceWithObj(TaxcOrgConstant.ENTITYNAME, "TaxcOrgMService", "queryTaxcOrgByOrgIds", orgIds, taxationsysId, isIncludeDisable);
        if (listTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData())) && taxationsysId != null) {
            listTaxResult.setData(TaxcOrgBusiness.queryTaxcOrgByTaxationsysId(listTaxResult.getData(), taxationsysId, Boolean.TRUE));
        }
        return listTaxResult;
    }

    public static TaxResult<List<Long>> queryTaxcOrgIdByOrgIdsAndTaxationsysId(List<Long> orgIds, Long taxationsysId) {
        return ServiceInvokeUtils.invokeBampService(Long.class, "TaxcOrgMService", "queryTaxcOrgIdByOrgIds", orgIds, taxationsysId);
    }

    public static TaxResult<List<DynamicObject>> queryTaxcOrgByIds(List<Long> ids, Long taxationsysId) {
        TaxResult<List<DynamicObject>> listTaxResult = ServiceInvokeUtils.invokeBampServiceWithObj(TaxcOrgConstant.ENTITYNAME, "TaxcOrgMService", "queryTaxcOrgByIds", ids, taxationsysId);
        if (listTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData())) && taxationsysId != null) {
            listTaxResult.setData(TaxcOrgBusiness.queryTaxcOrgByTaxationsysId(listTaxResult.getData(), taxationsysId, Boolean.TRUE));
        }
        return listTaxResult;
    }

    public static TaxResult<List<DynamicObject>> queryTaxcOrgByOrgIdsAndIsTaxpayer(List<Long> orgIds, Long taxationsysId) {
        TaxResult<List<DynamicObject>> listTaxResult = ServiceInvokeUtils.invokeBampServiceWithObj(TaxcOrgConstant.ENTITYNAME, "TaxcOrgMService", "queryTaxcOrgByOrgIdsAndIsTaxpayer", orgIds, taxationsysId);
        if (listTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData())) && taxationsysId != null) {
            listTaxResult.setData(TaxcOrgBusiness.queryTaxcOrgByTaxationsysId(listTaxResult.getData(), taxationsysId, Boolean.TRUE));
        }
        return listTaxResult;
    }

    public static TaxResult<List<Long>> queryTaxcOrgIdsByOrgIdsAndIsTaxpayer(List<Long> orgIds, Long taxationsysId) {
        return ServiceInvokeUtils.invokeBampService(Long.class, "TaxcOrgMService", "queryTaxcOrgIdsByOrgIdsAndIsTaxpayer", orgIds, taxationsysId);
    }

    public static TaxResult<List<Long>> queryTaxcOrgIdsNotChnTaxationsysId() {
        List<DynamicObject> loads = TaxcDataLoadBusiness.load(null, TaxcOrgConstant.ENTITYNAME, TaxcOrgConstant.QueryFiled);
        List<DynamicObject> objs = TaxcOrgBusiness.loadTaxcOrgByTaxationsysId(loads, TaxationsysMappingEnum.CHN.getId(), false);
        return ServiceInvokeUtils.buildTaxResult(Long.class, DyoToDtoUtils.dyoToLong(objs.toArray(new DynamicObject[0]), "org.id"));
    }

    public static TaxResult<List<DynamicObject>> queryTaxcOrgByOrgIdsAndIsTaxpayerForHws(List<Long> orgIds) {
        TaxResult<List<DynamicObject>> listTaxResult = ServiceInvokeUtils.invokeBampServiceWithObj(TaxcOrgConstant.ENTITYNAME, "TaxcOrgMService", "queryTaxcOrgByOrgIdsAndIsTaxpayer", orgIds, null);
        if (listTaxResult != null && !CollectionUtils.isEmpty((Collection)((Collection)listTaxResult.getData()))) {
            listTaxResult.setData(TaxcOrgBusiness.queryTaxcOrgByTaxationsysId(listTaxResult.getData(), TaxationsysMappingEnum.CHN.getId(), Boolean.FALSE));
        }
        return listTaxResult;
    }

    public static TaxResult<DynamicObject[]> queryTaxcOrgByOrgName(List<String> orgNames) {
        QFilter filter = new QFilter("org.name", "in", orgNames);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)TaxcOrgConstant.ENTITYNAME, (String)TaxcOrgConstant.QueryFiled, (QFilter[])new QFilter[]{filter});
        return new TaxResult<DynamicObject[]>(dyns);
    }

    public static TaxResult<DynamicObject[]> queryTaxcOrgByFirmName(List<String> orgNames) {
        QFilter filter = new QFilter("org.ffirmname", "in", orgNames);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)TaxcOrgConstant.ENTITYNAME, (String)TaxcOrgConstant.QueryFiled, (QFilter[])new QFilter[]{filter});
        return new TaxResult<DynamicObject[]>(dyns);
    }

    public static TaxResult<DynamicObject[]> queryTaxcOrgByNumber(List<String> orgNumbers) {
        QFilter filter = new QFilter("org.number", "in", orgNumbers);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)TaxcOrgConstant.ENTITYNAME, (String)TaxcOrgConstant.QueryFiled, (QFilter[])new QFilter[]{filter});
        return new TaxResult<DynamicObject[]>(dyns);
    }

    public static TaxResult<DynamicObject[]> queryAllTaxcOrgByOrgIds(List<Long> orgIds) {
        QFilter filter = new QFilter("org.id", "in", orgIds);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)TaxcOrgConstant.ENTITYNAME, (String)TaxcOrgConstant.QueryFiled, (QFilter[])new QFilter[]{filter});
        return new TaxResult<DynamicObject[]>(dyns);
    }
}

