/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper.tctb.orgtakerelation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.OrgFuncEnum;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import kd.taxc.bdtaxr.common.utils.metadata.MetadataUtil;

public class TaxOrgTakeRelationServiceHelper {
    public static List<Long> getOrgTakeRelation(List<Long> taxOrgId, Date startdate, Date enddate) {
        return (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxOrgTakeRelationService", (String)"getOrgTakeRelation", (Object[])new Object[]{taxOrgId, startdate, enddate});
    }

    public static TaxResult<List<DynamicObject>> getOrgTakeRelationObj(List<Long> taxOrgId, Date startdate, Date enddate) {
        return ServiceInvokeUtils.invokeTaxcTctbServiceWithObj("bos_org", "id,number,name", "TaxOrgTakeRelationService", "getOrgTakeRelation", taxOrgId, startdate, enddate);
    }

    public static Map<String, List<Long>> getOrgRelationMapByTaxOrgs(List<Long> taxOrgs, Date start, Date end) {
        HashMap<String, List<Long>> resultMap = new HashMap<String, List<Long>>(16);
        for (Long org : taxOrgs) {
            for (OrgFuncEnum orgFuncEnum : OrgFuncEnum.values()) {
                HashSet<Long> set = new HashSet<Long>(8);
                ArrayList<Long> list = new ArrayList<Long>(8);
                switch (orgFuncEnum) {
                    case TAX: {
                        break;
                    }
                    case ACCOUNT: {
                        List<Long> orgTakeRelation = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(org), start, end);
                        set.addAll(orgTakeRelation);
                        break;
                    }
                }
                list.addAll(set);
                resultMap.put(TaxOrgTakeRelationServiceHelper.getRelationMapKey(org, orgFuncEnum.getNumber()), list);
            }
        }
        return resultMap;
    }

    public static String getRelationMapKey(Long org, String orgFuncEnumNumber) {
        return org.toString() + "_" + orgFuncEnumNumber;
    }

    public static List<Long> getOrgListByRelation(Map<String, List<Long>> orgRelationMap, List<Long> cOrgs, String entityId, String entitykey, String orgFieldName) {
        String orgFun = MetadataUtil.getOrgFun(entityId, entitykey, orgFieldName);
        if (orgFun != null && orgRelationMap != null) {
            HashSet<Long> fitOrgs = new HashSet<Long>(cOrgs.size() * 2);
            for (Long cOrg : cOrgs) {
                List<Long> orgRelation = orgRelationMap.get(TaxOrgTakeRelationServiceHelper.getRelationMapKey(cOrg, orgFun));
                if (!EmptyCheckUtils.isNotEmpty(orgRelation)) continue;
                fitOrgs.addAll(orgRelation);
            }
            if (!EmptyCheckUtils.isEmpty(fitOrgs)) {
                return fitOrgs.stream().collect(Collectors.toList());
            }
        }
        return cOrgs;
    }
}

