/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper.tctb.taxclicense;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.license.api.LicenseCheckResult;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;

public class TaxcLicenseCheckDataServiceHelper {
    public static TaxResult<Boolean> check(Long orgId, String appId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Boolean.class, "TaxcLicenseCheckMService", "check", orgId, appId);
    }

    public static TaxResult<Map<Long, Boolean>> checkBatch(List<Long> orgIds, String appId) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Map.class, "TaxcLicenseCheckMService", "checkBatch", orgIds, appId);
    }

    public static TaxResult<List<Long>> getOrgByAppId(String appId, String licensestatus) {
        return ServiceInvokeUtils.invokeTaxcTctbService(Long.class, "TaxcLicenseCheckMService", "getOrgByAppId", appId, licensestatus);
    }

    public static TaxResult<LicenseCheckResult> checkTxftPerformGroup(String appId) {
        TaxResult temp = ServiceInvokeUtils.invokeTaxcTctbService(Map.class, "TaxcLicenseCheckMService", "checkTxftPerformGroup", appId);
        LicenseCheckResult checkResult = new LicenseCheckResult();
        checkResult.setHasLicense((Boolean)((Map)temp.getData()).get("hasLicense"));
        checkResult.setMsg((String)((Map)temp.getData()).get("msg"));
        TaxResult<LicenseCheckResult> result = new TaxResult<LicenseCheckResult>(temp.isSuccess(), temp.getCode(), temp.getMessage(), checkResult);
        return result;
    }

    public static boolean setPopWindowIfSupport(LicenseCheckResult checkResult, PreOpenFormEventArgs evt) {
        try {
            Method mGet = LicenseCheckResult.class.getMethod("getCancelFormShowParameter", new Class[0]);
            Method mSet = PreOpenFormEventArgs.class.getMethod("setCancelFormShowParameter", String.class);
            String msg = (String)mGet.invoke((Object)checkResult, new Object[0]);
            if (StringUtil.isEmpty((CharSequence)msg)) {
                msg = TaxcLicenseCheckDataServiceHelper.buildCancelFormShowParameter(false, checkResult);
            }
            mSet.invoke((Object)evt, msg);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String buildCancelFormShowParameter(Boolean isMobil, LicenseCheckResult checkResult) {
        MobileFormShowParameter licCheckLogShowParam;
        if (isMobil == null) {
            isMobil = false;
        }
        if (isMobil.booleanValue()) {
            licCheckLogShowParam = new MobileFormShowParameter();
            HashMap<String, String> param = new HashMap<String, String>(2);
            param.put("position", "center");
            licCheckLogShowParam.getOpenStyle().setCustParam(param);
            licCheckLogShowParam.setFormId("lic_licchecknotice_m");
        } else {
            licCheckLogShowParam = new FormShowParameter();
            licCheckLogShowParam.setFormId("lic_licchecknotice");
        }
        licCheckLogShowParam.getOpenStyle().setShowType(ShowType.Modal);
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(checkResult.getMsg());
        licCheckLogShowParam.setCustomParam("messages", messages);
        licCheckLogShowParam.setCustomParam("cancelmessage", (Object)checkResult.getMsg());
        return licCheckLogShowParam.toString();
    }
}

