/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper.tpo.declare;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.taxc.bdtaxr.business.tpo.DeclareMainTableBusiness;
import kd.taxc.bdtaxr.common.dto.DeclareMainTableQueryDto;
import kd.taxc.bdtaxr.common.dto.DeclareTable;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.MultiTableEnumBase;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.enums.tpo.ModelVersionEnum;
import kd.taxc.bdtaxr.common.enums.tpo.MultiTableEnum;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;

public class DeclareMainServiceHelper {
    public static TaxResult getDeclareMainData(Long modelId, Map<String, String> params) {
        String entryName = DeclareMainServiceHelper.getEntryName(modelId);
        if (StringUtils.isBlank((CharSequence)entryName)) {
            return new TaxResult();
        }
        return ServiceInvokeUtils.invokeTaxcTpoServiceWithObj(entryName, "DeclareMainService", "queryDeclareMainId", modelId, params);
    }

    public static TaxResult<List<DynamicObject>> queryDeclareMainByIds(Long modelId, List<Long> ids) {
        String entryName = DeclareMainServiceHelper.getEntryName(modelId);
        if (StringUtils.isBlank((CharSequence)entryName)) {
            return new TaxResult<List<DynamicObject>>();
        }
        return ServiceInvokeUtils.invokeTaxcTpoServiceWithObj(entryName, "DeclareMainService", "queryDeclareMainByIds", modelId, ids);
    }

    public static TaxResult<Map<Long, String>> queryModelVersionByIds(List<Long> ids) {
        return ServiceInvokeUtils.invokeTaxcTpoCalculateService(Map.class, "DeclareMainService", "queryModelVersionByIds", ids);
    }

    public static TaxResult<Map<String, String>> queryModelVersionByTypes(List<String> types) {
        return ServiceInvokeUtils.invokeTaxcTpoCalculateService(Map.class, "DeclareMainService", "queryModelVersionByTypes", types);
    }

    private static String getEntryName(Long modelId) {
        String entityName;
        if (modelId == null) {
            entityName = "tcvat_nsrxx";
        } else {
            DeclareTable declareTable = MultiTableEnumBase.getDeclareTable(modelId);
            if (declareTable == null) {
                return null;
            }
            entityName = declareTable.getMainTable();
        }
        return entityName;
    }

    public static TaxResult<List<DynamicObject>> queryDeclareMainTable(Long modelId, DeclareMainTableQueryDto queryDto) {
        String entityName = modelId != null ? MultiTableEnum.TSCOO1.getDeclareMainTable() : "tcvat_nsrxx";
        return ServiceInvokeUtils.invokeTaxcTpoServiceWithObj(entityName, "DeclareMainService", "queryDeclareMainTable", modelId, queryDto);
    }

    public static TaxResult<Map<String, String>> getModel2ToModel3FieldMap() {
        return ServiceInvokeUtils.invokeTaxcTpoCalculateService(Map.class, "DeclareMainService", "getModel2ToModel3FieldMap", new Object[0]);
    }

    public static TaxResult<Boolean> syncModel2DataToModel3(List<Long> ids, DeclareOperationEnum operate) {
        String operateCode = operate != null ? operate.getOperation() : null;
        return ServiceInvokeUtils.invokeTaxcTpoCalculateService(Boolean.class, "DeclareMainService", "syncModel2DataToModel3", ids, operateCode);
    }

    public static void fireModel2DeclareMainChangeEvent(DynamicObject[] declares, DeclareOperationEnum operate) {
        if (EmptyCheckUtils.isEmpty(declares)) {
            return;
        }
        List<Long> ids = Arrays.stream(declares).map(v -> v.getLong("id")).collect(Collectors.toList());
        List<DynamicObject> declareList = Arrays.stream(declares).collect(Collectors.toList());
        DeclareMainTableBusiness.triggerDeclareMainEvent(ids, declareList, ModelVersionEnum.MODEL2, operate, "bdtaxr", null);
    }

    public static void fireModel3DeclareMainChangeEvent(DynamicObject[] declares, DeclareOperationEnum operate) {
        if (EmptyCheckUtils.isEmpty(declares)) {
            return;
        }
        List<Long> ids = Arrays.stream(declares).map(v -> v.getLong("id")).collect(Collectors.toList());
        List<DynamicObject> declareList = Arrays.stream(declares).collect(Collectors.toList());
        DeclareMainTableBusiness.triggerDeclareMainEvent(ids, declareList, ModelVersionEnum.MODEL3, operate, "bdtaxr", null);
    }

    public static void fireDeclareMainChangeEvent(List<Long> ids, List<DynamicObject> declares, ModelVersionEnum version, DeclareOperationEnum operate, String source, Map<String, Object> extParam) {
        DeclareMainTableBusiness.triggerDeclareMainEvent(ids, declares, version, operate, source, extParam);
    }
}

