/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper.ttc;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.taxc.bdtaxr.business.TaxcCombineBusinessDataBusiness;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.dto.taxCodeCaculate.TaxcodeDetailDto;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TtcCalculateServiceHelper {
    public static TaxResult<List<String>> getTaxCodeAndRateByCondition(long orgid, long country, long taxationsys, String ttctag, Date validDate, List<Long> taxTypeList, List<Map<Long, Long>> taxProductList, List<Map<Long, Long>> addressTypeList, List<Map<Long, Long>> taxAptitudeList, List<Map<Long, Long>> processList) {
        return ServiceInvokeUtils.invokeTtcCalculateService(String.class, "taxc", "ttc", "BillTaxCalculateService", "service", orgid, country, taxationsys, ttctag, validDate, taxTypeList, taxProductList, addressTypeList, taxAptitudeList, processList);
    }

    public static TaxResult<Map<String, List<String>>> getTaxCodeAndRateByCondition(long orgid, long country, long taxationsys, String ttctag, Date validDate, List<Long> taxTypeList, List<Map<String, Map<Long, Long>>> taxFourPList) {
        return ServiceInvokeUtils.invokeTtcCalculateService(Map.class, "taxc", "ttc", "BillTaxCalculateService", "batchServiceByOrgAndTaxationsys", orgid, country, taxationsys, ttctag, validDate, taxTypeList, taxFourPList);
    }

    public static TaxResult<List<TaxcodeDetailDto>> callTaxCodeServiceByCondition(long orgid, long country, long taxationsys, String ttctag, Date validDate, List<Long> taxTypeList, List<Map<Long, Long>> taxProductList, List<Map<Long, Long>> addressTypeList, List<Map<Long, Long>> taxAptitudeList, List<Map<Long, Long>> processList) {
        TaxResult<List<String>> taxCodeNumberListResult = TtcCalculateServiceHelper.getTaxCodeAndRateByCondition(orgid, country, taxationsys, ttctag, validDate, taxTypeList, taxProductList, addressTypeList, taxAptitudeList, processList);
        if (ObjectUtils.isNotEmpty(taxCodeNumberListResult) && ObjectUtils.isNotEmpty(taxCodeNumberListResult.getData())) {
            TaxResult<List<TaxcodeDetailDto>> taxResult = TaxcCombineBusinessDataBusiness.loadMatchTaxCodeDetailByTaxcCodeNumber(taxCodeNumberListResult.getData().get(0));
            return taxResult;
        }
        return null;
    }
}

