/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;

public class BigDecimalUtil {
    public static BigDecimal setScale(Object dec) {
        return BigDecimalUtil.setScale(dec, 2);
    }

    public static BigDecimal setScale(Object dec, int scale) {
        BigDecimal bigDecimal = BigDecimalUtil.toBigDecimal(dec);
        if (bigDecimal == null) {
            return BigDecimal.ZERO;
        }
        return bigDecimal.setScale(scale, 4);
    }

    public static BigDecimal subtractObject(Object dec1, Object dec2) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        return BigDecimalUtil.toBigDecimal(dec1).subtract(BigDecimalUtil.toBigDecimal(dec2));
    }

    public static BigDecimal subtractObject(Object dec1, Object dec2, int scale) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        return BigDecimalUtil.toBigDecimal(dec1).subtract(BigDecimalUtil.toBigDecimal(dec2)).setScale(scale, 4);
    }

    public static BigDecimal divideObject(Object dec1, Object dec2, int scale) {
        return BigDecimalUtil.divideObject(dec1, dec2, scale, 4);
    }

    public static BigDecimal divideObject(Object dec1, Object dec2, int scale, int roundingMode) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        if (BigDecimalUtil.toBigDecimal(dec2).signum() == 0) {
            return null;
        }
        return BigDecimalUtil.toBigDecimal(dec1).divide(BigDecimalUtil.toBigDecimal(dec2), scale, roundingMode);
    }

    public static BigDecimal addObjects(Object ... objects) {
        BigDecimal total = BigDecimal.ZERO;
        for (Object object : objects) {
            total = BigDecimalUtil.toBigDecimal(object).add(total);
        }
        return total;
    }

    public static BigDecimal multiplyObject(Object dec1, Object dec2, int scale) {
        if (dec1 == null || dec2 == null) {
            return null;
        }
        BigDecimal obj = BigDecimalUtil.toBigDecimal(dec1).multiply(BigDecimalUtil.toBigDecimal(dec2));
        return obj.setScale(scale, 4);
    }

    public static BigDecimal multiplyObject(Object dec1, Object dec2, int scale, int RoundingMode2) {
        if (dec1 == null || dec2 == null) {
            return null;
        }
        BigDecimal obj = BigDecimalUtil.toBigDecimal(dec1).multiply(BigDecimalUtil.toBigDecimal(dec2));
        return obj.setScale(scale, RoundingMode2);
    }

    public static BigDecimal addObject(Object dec1, Object dec2) {
        if (dec1 == null && dec2 == null) {
            return null;
        }
        return BigDecimalUtil.toBigDecimal(dec1).add(BigDecimalUtil.toBigDecimal(dec2));
    }

    public static BigDecimal addWithHalfUp(BigDecimal ... var) {
        BigDecimal result = BigDecimal.ZERO;
        for (BigDecimal var1 : var) {
            if (var1 == null) continue;
            result = result.add(var1.setScale(2, 4));
        }
        return result;
    }

    public static BigDecimal toBigDecimal(Object obj) {
        String substring;
        String str;
        if (obj == null) {
            return BigDecimal.ZERO;
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        if (obj instanceof Integer) {
            return new BigDecimal(((Integer)obj).toString());
        }
        if (obj instanceof Long) {
            return new BigDecimal(((Long)obj).toString());
        }
        if (obj instanceof Double && !Double.isInfinite((Double)obj)) {
            return BigDecimal.valueOf((Double)obj);
        }
        if (obj.toString() == null) {
            return BigDecimal.ZERO;
        }
        if (obj instanceof String && StringUtil.isNotEmpty((CharSequence)(str = obj.toString().trim())) && str.endsWith("%") && (substring = str.substring(0, str.length() - 1)).matches("^[+-]?\\d+[\\.\\d]?\\d*+$")) {
            return new BigDecimal(substring).divide(new BigDecimal("100"));
        }
        str = StringUtil.trimContainsChineseSpace(obj.toString());
        if (str.toLowerCase().contains("e")) {
            try {
                return new BigDecimal(str);
            }
            catch (NumberFormatException e) {
                return BigDecimal.ZERO;
            }
        }
        if (str.matches("^[+-]?\\d+[\\.\\d]?\\d*+$")) {
            return new BigDecimal(str);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal max(Object object1, Object object2) {
        return BigDecimalUtil.toBigDecimal(object1).compareTo(BigDecimalUtil.toBigDecimal(object2)) > 0 ? BigDecimalUtil.toBigDecimal(object1) : BigDecimalUtil.toBigDecimal(object2);
    }

    public static BigDecimal min(Object object1, Object object2) {
        return BigDecimalUtil.toBigDecimal(object1).compareTo(BigDecimalUtil.toBigDecimal(object2)) > 0 ? BigDecimalUtil.toBigDecimal(object2) : BigDecimalUtil.toBigDecimal(object1);
    }

    public static final String thousandth(Object num) {
        return DecimalFormat.getNumberInstance().format(BigDecimalUtil.toBigDecimal(num));
    }

    public static String format(Object num, String pattern) {
        DecimalFormat format = new DecimalFormat(pattern, DecimalFormatSymbols.getInstance());
        return format.format(num);
    }

    public static BigDecimal sumDynamicObjectAmount(List<DynamicObject> objects, String amountKey) {
        BigDecimal amount = BigDecimal.ZERO;
        if (EmptyCheckUtils.isNotEmpty(objects)) {
            for (DynamicObject object : objects) {
                amount = BigDecimalUtil.addObject(amount, object.getBigDecimal(amountKey));
            }
        }
        return BigDecimalUtil.setScale(amount, 2);
    }
}

