/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;

public class DynamicObjectUtils {
    public static String serializerToString(DynamicObject obj) {
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeDataEntityState(false);
        option.setIncludeComplexProperty(true);
        option.setIncludeCollectionProperty(true);
        option.setIncludeType(false);
        String json = DataEntitySerializer.serializerToString((Object)obj, (DataEntitySerializerOption)option);
        return json;
    }

    public static DynamicObject deSerializerFromString(String json, String entityNumber) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DynamicObject dyn = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)json, (IDataEntityType)mainType);
        return dyn;
    }

    public static boolean matchMultiSelectFiled(DynamicObject dyn1, DynamicObject dyn2, String filedKey) {
        String s1 = dyn1.getString(filedKey);
        String s2 = dyn2.getString(filedKey);
        Set<String> a1 = DynamicObjectUtils.spiltStr(s1);
        Set<String> a2 = DynamicObjectUtils.spiltStr(s2);
        return a1.equals(a2);
    }

    public static boolean coverMultiSelectFiled(DynamicObject dyn1, DynamicObject dyn2, String filedKey) {
        String s1 = dyn1.getString(filedKey);
        String s2 = dyn2.getString(filedKey);
        Set<String> a1 = DynamicObjectUtils.spiltStr(s1);
        Set<String> a2 = DynamicObjectUtils.spiltStr(s2);
        for (String item1 : a1) {
            if (!a2.contains(item1)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> spiltStr(String str) {
        if (str == null) {
            return new HashSet<String>(2);
        }
        String[] array = str.split(",");
        Set<String> s = Arrays.stream(array).collect(Collectors.toSet());
        s.remove("");
        return s;
    }

    public static boolean matchFiled(DynamicObject dyn1, DynamicObject dyn2, String filedKey) {
        Object o1 = dyn1.get(filedKey);
        Object o2 = dyn2.get(filedKey);
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            if (o1 instanceof String || o2 instanceof String) {
                return StringUtil.isEmpty((CharSequence)((String)o1)) && StringUtil.isEmpty((CharSequence)((String)o2));
            }
            return false;
        }
        if (o1 instanceof String) {
            return o1.equals(o2);
        }
        if (o1 instanceof Long) {
            return Long.compare((Long)o1, (Long)o2) == 0;
        }
        if (o1 instanceof DynamicObject) {
            return ((DynamicObject)o1).getLong("id") == ((DynamicObject)o2).getLong("id");
        }
        if (o1 instanceof MulBasedataDynamicObjectCollection) {
            MulBasedataDynamicObjectCollection m1 = (MulBasedataDynamicObjectCollection)o1;
            MulBasedataDynamicObjectCollection m2 = (MulBasedataDynamicObjectCollection)o2;
            Set ids1 = m1.stream().map(item -> item.get("fbasedataid.id")).collect(Collectors.toSet());
            Set ids2 = m2.stream().map(item -> item.get("fbasedataid.id")).collect(Collectors.toSet());
            return ids1.equals(ids2);
        }
        return o1 == o2;
    }

    public static Map<String, Object> dynamicObjectToMap(DynamicObject obj) {
        return DynamicObjectUtils.dynamicObjectToMap(obj, false);
    }

    public static List<Map<String, Object>> dynamicObjectslist2ListMap(List<DynamicObject> objs) {
        ArrayList list = Lists.newArrayListWithCapacity((int)objs.size());
        for (DynamicObject obj : objs) {
            list.add(DynamicObjectUtils.dynamicObjectToMap(obj, true));
        }
        return list;
    }

    public static List<Map<String, Object>> dynamicObjectColletction2ListMap(DynamicObjectCollection collection) {
        return DynamicObjectUtils.dynamicObjectColletction2ListMap(collection, false);
    }

    public static List<Map<String, Object>> dynamicObjectColletction2ListMap(DynamicObjectCollection collection, boolean long2String) {
        ArrayList list = Lists.newArrayListWithCapacity((int)collection.size());
        for (DynamicObject obj : collection) {
            list.add(DynamicObjectUtils.dynamicObjectToMap(obj, long2String));
        }
        return list;
    }

    public static List<Map<String, Object>> dynamicObjects2ListMap(DynamicObject[] objs, boolean long2String) {
        ArrayList list = Lists.newArrayListWithCapacity((int)objs.length);
        for (DynamicObject obj : objs) {
            list.add(DynamicObjectUtils.dynamicObjectToMap(obj, long2String));
        }
        return list;
    }

    public static List<Map<String, Object>> dynamicObjects2ListMap(List<DynamicObject> objs) {
        return DynamicObjectUtils.dynamicObjects2ListMap(objs, false);
    }

    public static List<Map<String, Object>> dynamicObjects2ListMap(List<DynamicObject> objs, boolean long2String) {
        ArrayList list = Lists.newArrayListWithCapacity((int)objs.size());
        for (DynamicObject obj : objs) {
            list.add(DynamicObjectUtils.dynamicObjectToMap(obj, long2String));
        }
        return list;
    }

    public static Map<String, Object> dynamicObjectToMap(DynamicObject obj, boolean id2String) {
        if (obj == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(obj.getDynamicObjectType().getProperties().size());
        DataEntityPropertyCollection collect = obj.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : collect) {
            String field = property.getName();
            if (property instanceof EntryProp) {
                DynamicObjectCollection collection = obj.getDynamicObjectCollection(field);
                map.put(field, DynamicObjectUtils.dynamicObjectColletction2ListMap(collection, id2String));
                continue;
            }
            Object fieldObj = obj.get(field);
            if (id2String && (property.getPropertyType() == Long.class || property.getPropertyType() == Long.TYPE || fieldObj instanceof Long)) {
                if (fieldObj == null) continue;
                map.put(field, String.valueOf(fieldObj));
                continue;
            }
            if (fieldObj instanceof DynamicObject) {
                Object pkValue = ((DynamicObject)fieldObj).getPkValue();
                map.put(field, id2String ? pkValue.toString() : pkValue);
                continue;
            }
            map.put(field, obj.get(field));
        }
        return map;
    }

    public static Date getDateValue(DynamicObject entity, String key) {
        if (!entity.containsProperty(key)) {
            return null;
        }
        return entity.getDate(key);
    }

    public static String getDateStringValue(DynamicObject entity, String key) {
        if (!entity.containsProperty(key) || entity.getDate(key) == null) {
            return "";
        }
        return DateUtils.format(entity.getDate(key), "yyyy-MM-dd");
    }

    public static String getStringValue(DynamicObject entity, String key) {
        if (!entity.containsProperty(key)) {
            return "";
        }
        return entity.getString(key);
    }

    public static Long getDynamicObjectValue(DynamicObject entity, String key) {
        if (!entity.containsProperty(key)) {
            return null;
        }
        Object value = entity.get(key);
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).getLong("id");
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return null;
    }

    public static String getDynamicObjectStringValue(DynamicObject entity, String key) {
        if (!entity.containsProperty(key)) {
            return "";
        }
        Long value = DynamicObjectUtils.getDynamicObjectValue(entity, key);
        if (value == null) {
            return "";
        }
        return String.valueOf(value);
    }

    public static void setValue(DynamicObject entity, String field, Object value) {
        if (!entity.containsProperty(field)) {
            return;
        }
        entity.set(field, value);
    }
}

