/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;

public class DyoToDtoUtils {
    private static final String IDKEY = "id";
    private static final String SPLISTKEY = "\\.";

    public static List<Long> dyoToLong(DynamicObject[] docs) {
        return DyoToDtoUtils.dyoToLong(docs, IDKEY);
    }

    public static List<Long> dyoToLong(DynamicObjectCollection docs, String fieldKey) {
        ArrayList<Long> ids = new ArrayList<Long>(docs.size());
        for (DynamicObject dyo : docs) {
            ids.add(DyoToDtoUtils.dyoToLong(dyo, fieldKey));
        }
        return ids;
    }

    public static List<Long> dyoToLong(DynamicObject[] docs, String fieldKey) {
        ArrayList<Long> ids = new ArrayList<Long>(docs.length);
        for (DynamicObject dyo : docs) {
            ids.add(DyoToDtoUtils.dyoToLong(dyo, fieldKey));
        }
        return ids;
    }

    public static Map<String, List<Long>> dyoToIdMap(DynamicObjectCollection docs, String fieldKey, String entryKey) {
        HashMap<String, List<Long>> idMap = new HashMap<String, List<Long>>();
        String[] entryKeys = entryKey.split(",");
        for (DynamicObject dyo : docs) {
            Long id;
            if (!idMap.containsKey(fieldKey)) {
                idMap.put(fieldKey, new ArrayList());
            }
            if ((id = DyoToDtoUtils.dyoToLong(dyo, fieldKey)) != null && id != 0L) {
                ((List)idMap.get(fieldKey)).add(id);
            }
            for (String key : entryKeys) {
                if (!idMap.containsKey(key)) {
                    idMap.put(key, new ArrayList());
                }
                if (dyo.get(key) instanceof DynamicObjectCollection) {
                    DynamicObjectCollection collection = (DynamicObjectCollection)dyo.get(key);
                    List<Long> entryIdList = DyoToDtoUtils.dyoToLong(collection, IDKEY);
                    entryIdList.forEach(entryId -> ((List)idMap.get(key)).add(entryId));
                    continue;
                }
                Long entryId2 = DyoToDtoUtils.dyoToLong(dyo, key);
                if (entryId2 == null || entryId2 == 0L) continue;
                ((List)idMap.get(key)).add(entryId2);
            }
        }
        return idMap;
    }

    public static Long dyoToLong(DynamicObject dyo, String fieldKey) {
        if (null != dyo) {
            if (dyo.get(fieldKey) instanceof DynamicObject) {
                if (fieldKey.contains(SPLISTKEY)) {
                    String[] k = fieldKey.split(SPLISTKEY);
                    return dyo.getDynamicObject(k[0]).getLong(k[1]);
                }
                return dyo.getDynamicObject(fieldKey).getLong(IDKEY);
            }
            return dyo.getLong(fieldKey);
        }
        return 0L;
    }

    public static List<String> dyoToString(DynamicObjectCollection docs, String fieldKey) {
        ArrayList<String> ids = new ArrayList<String>(docs.size());
        for (DynamicObject dyo : docs) {
            ids.add(DyoToDtoUtils.dyoToString(dyo, fieldKey));
        }
        return ids;
    }

    public static List<Long> dyoToString(DynamicObject[] docs, String fieldKey) {
        ArrayList<Long> ids = new ArrayList<Long>(docs.length);
        for (DynamicObject dyo : docs) {
            ids.add(DyoToDtoUtils.dyoToLong(dyo, fieldKey));
        }
        return ids;
    }

    public static String dyoToString(DynamicObject dyo, String fieldKey) {
        if (null != dyo) {
            if (dyo.get(fieldKey) instanceof DynamicObject) {
                if (fieldKey.contains(SPLISTKEY)) {
                    String[] k = fieldKey.split(SPLISTKEY);
                    return dyo.getDynamicObject(k[0]).getString(k[1]);
                }
                return dyo.getDynamicObject(fieldKey).getString(IDKEY);
            }
            return dyo.getString(fieldKey);
        }
        return "";
    }
}

