/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.utils;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;

public class EmptyCheckUtils {
    public static final Predicate<String> isEmptyByString() {
        return s -> null == s || 0 == s.trim().length();
    }

    public static final Predicate<Collection> isEmptyByCollection() {
        return coll -> null == coll || 0 == coll.size();
    }

    public static final Predicate<Map> isEmptyByMap() {
        return map -> null == map || 0 == map.size();
    }

    public static final Predicate isEmptyByArray() {
        return arr -> null == arr || 0 == Array.getLength(arr);
    }

    public static final boolean isEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj.getClass().isArray()) {
            return EmptyCheckUtils.isEmptyByArray().test(obj);
        }
        if (obj instanceof Map) {
            return EmptyCheckUtils.isEmptyByMap().test((Map)obj);
        }
        if (obj instanceof Collection) {
            return EmptyCheckUtils.isEmptyByCollection().test((Collection)obj);
        }
        if (obj instanceof String) {
            return EmptyCheckUtils.isEmptyByString().test((String)obj);
        }
        if (obj instanceof CharSequence) {
            return 0 == ((CharSequence)obj).toString().trim().length();
        }
        return false;
    }

    public static final boolean isAnyEmpty(Object ... obj) {
        for (Object ob : obj) {
            if (!EmptyCheckUtils.isEmpty(ob)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isNotEmpty(Object obj) {
        return !EmptyCheckUtils.isEmpty(obj);
    }
}

