/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.taxc.bdtaxr.business.customsource.CustomSource;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;
import org.apache.commons.lang3.StringUtils;

public class FilterBuilderUtils {
    private static Log logger = LogFactory.getLog(FilterBuilderUtils.class);
    private static final String DYNAMIC = "dynamic";

    public static QFilter buildFilter(String conditionjson, String entryName) {
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)conditionjson, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entryName);
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.setTimeService((ITimeService)new TimeService());
        filterBuilder.buildFilter(false);
        return filterBuilder.getQFilter();
    }

    public static String buildFilterDesc(String conditionjson, String entryName) {
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)conditionjson, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entryName);
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.setTimeService((ITimeService)new TimeService());
        filterBuilder.buildFilter(false);
        return filterBuilder.getFilterObject().getQFilter().toString();
    }

    public static Map<Long, QFilter> buildMappingQfilter(Map<Long, Map<String, Object>> dataSourceMapping) {
        HashMap<Long, QFilter> collect = new HashMap<Long, QFilter>();
        if (dataSourceMapping != null && dataSourceMapping.size() > 0) {
            for (Map.Entry<Long, Map<String, Object>> entry : dataSourceMapping.entrySet()) {
                Map mappingList;
                Boolean isMapping;
                if (entry.getValue() == null || !entry.getValue().containsKey("mappingList") || !(isMapping = (Boolean)entry.getValue().getOrDefault("isMapping", Boolean.FALSE)).booleanValue()) continue;
                String fieldkey = (String)entry.getValue().get("fieldkey");
                if (entry.getValue().get("mappingList") == null || !EmptyCheckUtils.isNotEmpty(mappingList = (Map)entry.getValue().get("mappingList"))) continue;
                ArrayList objectList = new ArrayList(8);
                mappingList.values().forEach(a -> objectList.addAll(a.stream().map(s -> s.get("businessid")).collect(Collectors.toList())));
                if (objectList.isEmpty()) continue;
                collect.put(entry.getKey(), new QFilter(fieldkey, "in", objectList));
            }
        }
        return collect;
    }

    public static String buildQueryField(CustomSource customSource, String fieldEntity, String selectField) {
        String mainEntity = customSource.getEntityname();
        String subEntity = customSource.getSubname();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)mainEntity);
        if (null != mainEntityType.findProperty(selectField)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)fieldEntity, (CharSequence)mainEntity)) {
                return selectField;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)fieldEntity, (CharSequence)subEntity)) {
                if (mainEntityType.findProperty(fieldEntity) instanceof EntryProp) {
                    return subEntity + "." + selectField;
                }
                if (mainEntityType.findProperty(fieldEntity) instanceof SubEntryProp) {
                    return mainEntityType.findProperty(fieldEntity).getParent().getName() + "." + fieldEntity + "." + selectField;
                }
                return selectField;
            }
            if (mainEntityType.findProperty(fieldEntity) instanceof SubEntryProp && StringUtils.equalsIgnoreCase((CharSequence)mainEntityType.findProperty(fieldEntity).getParent().getName(), (CharSequence)subEntity)) {
                return subEntity + "." + fieldEntity + "." + selectField;
            }
            return null;
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)fieldEntity);
        if (null == entityType || null == entityType.findProperty(selectField)) {
            return null;
        }
        return selectField;
    }
}

