/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.business.TaxcDataDataSetBusiness;
import kd.taxc.bdtaxr.business.TaxcDataLoadBusiness;
import kd.taxc.bdtaxr.business.TaxcDataQueryBusiness;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;

public class ServiceInvokeUtils {
    private static Log logger = LogFactory.getLog(ServiceInvokeUtils.class);

    public static <T> TaxResult<T> invokeBampService(Class<?> cls, String serviceName, String methodName, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"bamp", (String)"bastax", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.createTaxResult(cls, result);
    }

    public static <T> TaxResult<T> invokeBampServiceWithObj(String entityName, String serviceName, String methodName, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"bamp", (String)"bastax", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.trasformData(result, entityName);
    }

    public static <T> TaxResult<T> invokeTaxcTctbService(Class<?> cls, String serviceName, String methodName, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.createTaxResult(cls, result);
    }

    public static <T> TaxResult<T> invokeTaxcTctbServiceWithObj(String entityName, String selectFields, String serviceName, String methodName, Object ... params) {
        Object obj = DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)serviceName, (String)methodName, (Object[])params);
        if (obj instanceof Map) {
            Map result = (Map)obj;
            return ServiceInvokeUtils.trasformData(result, entityName, selectFields);
        }
        if (obj instanceof List) {
            List result = (List)obj;
            return ServiceInvokeUtils.trasformData(result, entityName, selectFields);
        }
        if (obj == null) {
            return new TaxResult();
        }
        throw new KDBizException("trasformData erro:return type is not support");
    }

    public static <T> TaxResult<T> invokeTaxcTctbServiceWithData(Class<?> cls, String serviceName, String methodName, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.buildTaxResult(cls, result);
    }

    public static <T> TaxResult<T> invokeTaxcTpoService(Class<?> cls, String serviceName, String methodName, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tpo", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.createTaxResult(cls, result);
    }

    public static <T> TaxResult<T> invokeTaxcTpoServiceWithObj(String entityName, String serviceName, String methodName, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tpo", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.trasformData(result, entityName);
    }

    public static <T> TaxResult<T> invokeTaxcTpoCalculateService(Class<?> cls, String serviceName, String methodName, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tpo", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.createTaxResult(cls, result);
    }

    public static <T> TaxResult<T> invokeTaxcTcretService(String serviceName, String methodName, Object ... params) {
        return (TaxResult)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tcret", (String)serviceName, (String)methodName, (Object[])params);
    }

    public static <T> TaxResult<T> invokeTaxcTcretService(Class<?> cls, String serviceName, String methodName, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tcret", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.createTaxResult(cls, result);
    }

    public static <T> TaxResult<T> invokeTaxcTccitServiceWithObj(String entityName, String selectFields, String serviceName, String methodName, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tccit", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.trasformData(result, entityName, selectFields);
    }

    public static <T> TaxResult<T> invokeTtcCalculateService(Class<?> cls, String cloud, String appId, String serviceName, String methodName, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)cloud, (String)appId, (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.createTaxResult(cls, result);
    }

    public static <T> TaxResult<T> invokeTtcService(Class<?> cls, String serviceName, String methodName, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"ttc", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.createTaxResult(cls, result);
    }

    public static <T> TaxResult<T> invokeTaxcTpoServiceWithObj(String entityName, String selectFields, String serviceName, String methodName, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tpo", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.trasformData(result, entityName, selectFields);
    }

    public static <T> TaxResult<T> invokeTaxcTpoServiceWithObjQuery(String entityName, String selectFields, String serviceName, String methodName, String orderBy, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tpo", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.trasformDataQuery(result, entityName, selectFields, orderBy);
    }

    public static <T> TaxResult<T> invokeTaxcTctsaServiceWithObjQuery(String entityName, String selectFields, String serviceName, String methodName, String orderBy, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctsa", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.trasformDataQuery(result, entityName, selectFields, orderBy);
    }

    public static <T> TaxResult<T> invokeTaxcTctsaServiceWithObjDataset(String entityName, String selectFields, String serviceName, String methodName, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctsa", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.trasformDataDataset(result, entityName, selectFields);
    }

    public static <T> TaxResult<T> invokeTaxcTctbServiceWithObjDataset(String entityName, String selectFields, String serviceName, String methodName, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.trasformDataDataset(result, entityName, selectFields);
    }

    public static <T> TaxResult<T> invokeTaxcTdmServiceWithObj(String entityName, String selectFields, String serviceName, String methodName, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tdm", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.trasformData(result, entityName, selectFields);
    }

    public static <T> TaxResult<T> invokeTaxcTdmService(Class<?> cls, String serviceName, String methodName, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tdm", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.createTaxResult(cls, result);
    }

    public static <T> TaxResult<T> invokeTaxcTotfService(Class<?> cls, String serviceName, String methodName, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"totf", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.createTaxResult(cls, result);
    }

    public static <T> TaxResult<T> invokeTaxTctrcService(Class<?> cls, String serviceName, String methodName, Object ... params) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctrc", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.createTaxResult(cls, result);
    }

    private static <T> TaxResult<T> trasformDataQuery(Map<String, Object> data, String entityName, String selectFields, String orderBy) {
        TaxResult<List<Object>> result = new TaxResult<List<Object>>();
        if (data != null) {
            result.setCode(String.valueOf(data.get("code")));
            result.setMessage(String.valueOf(data.get("message")));
            result.setSuccess((Boolean)data.get("success"));
            if (data.get("data") instanceof List) {
                List<DynamicObject> objs = TaxcDataQueryBusiness.load((List)data.get("data"), entityName, selectFields, orderBy);
                result.setData(objs);
            } else {
                DynamicObject obj = TaxcDataQueryBusiness.loadSingle((Long)data.get("data"), entityName, selectFields);
                result.setData((List<Object>)obj);
            }
        }
        return result;
    }

    private static <T> TaxResult<T> trasformDataDataset(Map<String, Object> data, String entityName, String selectFields) {
        TaxResult<DataSet> result = new TaxResult<DataSet>();
        if (data != null) {
            result.setCode(String.valueOf(data.get("code")));
            result.setMessage(String.valueOf(data.get("message")));
            result.setSuccess((Boolean)data.get("success"));
            DataSet objs = TaxcDataDataSetBusiness.load((List)data.get("data"), entityName, selectFields);
            result.setData(objs);
        }
        return result;
    }

    private static <T> TaxResult<T> trasformData(Map<String, Object> data, String entityName) {
        TaxResult result = new TaxResult();
        if (data != null) {
            result.setCode(String.valueOf(data.get("code")));
            result.setMessage(String.valueOf(data.get("message")));
            result.setSuccess((Boolean)data.get("success"));
            if (data.get("data") instanceof List) {
                List ids = (List)data.get("data");
                if (!CollectionUtils.isEmpty((Collection)ids)) {
                    List<DynamicObject> objs = TaxcDataLoadBusiness.load(ids, entityName);
                    result.setData(objs);
                } else {
                    result.setData(Collections.EMPTY_LIST);
                }
            } else {
                DynamicObject obj = TaxcDataLoadBusiness.loadSingle((Long)data.get("data"), entityName);
                result.setData(obj);
            }
        }
        return result;
    }

    private static <T> TaxResult<T> trasformData(Map<String, Object> data, String entityName, String selectFields) {
        TaxResult result = new TaxResult();
        if (data != null) {
            result.setCode(String.valueOf(data.get("code")));
            result.setMessage(String.valueOf(data.get("message")));
            result.setSuccess((Boolean)data.get("success"));
            if (data.get("data") instanceof List) {
                List ids = (List)data.get("data");
                if (!CollectionUtils.isEmpty((Collection)ids)) {
                    List<DynamicObject> objs = TaxcDataLoadBusiness.load((List)data.get("data"), entityName, selectFields);
                    result.setData(objs);
                } else {
                    result.setData(Collections.EMPTY_LIST);
                }
            } else {
                DynamicObject obj = TaxcDataLoadBusiness.loadSingle((Long)data.get("data"), entityName, selectFields);
                result.setData(obj);
            }
        }
        return result;
    }

    private static <T> TaxResult<T> trasformData(List<Long> ids, String entityName, String selectFields) {
        TaxResult<List> result = new TaxResult<List>();
        if (!CollectionUtils.isEmpty(ids)) {
            List<DynamicObject> objs = TaxcDataLoadBusiness.load(ids, entityName, selectFields);
            result.setData(objs);
        } else {
            result.setData(Collections.EMPTY_LIST);
        }
        return result;
    }

    public static <T> TaxResult<T> createTaxResult(Class<?> cls, Map<String, Object> data) {
        TaxResult<Object> result = new TaxResult<Object>();
        if (data != null) {
            result.setCode(String.valueOf(data.get("code")));
            result.setMessage(String.valueOf(data.get("message")));
            result.setSuccess((Boolean)data.get("success"));
            if (data.get("data") instanceof List) {
                JSONArray jsonArray = JSONObject.parseArray((String)JSONObject.toJSONString((Object)data.get("data")));
                List list = jsonArray.toJavaList(cls);
                result.setData(list);
            } else {
                result.setData(data.get("data"));
            }
        }
        return result;
    }

    public static <T> TaxResult<T> buildTaxResult(Class<?> cls, Object data) {
        TaxResult<Object> result = new TaxResult<Object>();
        if (data != null) {
            result.setCode(TaxcErrorCode.TAXC_SUCCESS_CODE.getCode());
            result.setMessage(TaxcErrorCode.TAXC_SUCCESS_CODE.getMessage());
            result.setSuccess(Boolean.TRUE);
            result.setData(data);
        }
        return result;
    }

    public static <T> TaxResult<T> buildTaxResult(Class<?> cls, Boolean success, String code, String message, Object data) {
        TaxResult<Object> result = new TaxResult<Object>();
        result.setCode(code);
        result.setMessage(message);
        result.setSuccess(success);
        result.setData(data);
        return result;
    }

    public static <T> TaxResult<T> invokeTaxcTcvvtTrasStaffDeclareService(Class<?> cls, String cloud, String appId, String serviceName, String methodName, Object ... params) {
        Object data = DispatchServiceHelper.invokeBizService((String)cloud, (String)appId, (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.buildTaxResult(null, data);
    }

    public static <T> TaxResult<T> invokeTaxcTsateService(Class<?> cls, String serviceName, String methodName, Object ... params) {
        Object data = DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)serviceName, (String)methodName, (Object[])params);
        return ServiceInvokeUtils.buildTaxResult(null, data);
    }

    public static <T> T getResultData(TaxResult result) {
        if (result.isSuccess()) {
            return result.getData();
        }
        logger.error("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1acode:{},message:{}", (Object)result.getCode(), (Object)result.getMessage());
        return null;
    }
}

