/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.accessconfig;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.ruletemplate.RuleTemplateBusiness;
import kd.taxc.bdtaxr.common.constant.EntityV3Constant;
import kd.taxc.bdtaxr.common.dto.AdvanceConfDto;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;

public class AbstractAccessConfigPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    protected static final String ENTRY_ENTITY = "entryentity";
    protected static final String KEY_FILTERCONDITION = "filtercondition";
    protected static final String KEY_CONDITIONJSON = "conditionjson";
    protected static final String KEY_ABSOLUTE = "absolute";
    protected static final String KEY_FETCHFIELD = "amountfield";
    protected static final String KEY_BASEDATATYPE = "basedatatype";
    protected static final String KEY_TABLE = "table";
    public static final String KEY_ADVANCEDCONF = "advancedconf";
    private static final String PARAM_KEY_ACCESSCFG_PREFIX = "default_advance_";

    public void initialize() {
        BasedataEdit amountfield = (BasedataEdit)this.getControl(KEY_FETCHFIELD);
        amountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit tablefield = (BasedataEdit)this.getControl(KEY_TABLE);
        tablefield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Control ruletypeControl;
        Object orgid;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Control orgControl = this.getControl("org");
        if (orgControl != null && !ObjectUtils.isEmpty(orgid = customParams.get("orgid"))) {
            this.getModel().setValue("org", orgid);
        }
        if ((ruletypeControl = this.getControl("ruletype")) != null) {
            Object ruletype = customParams.get("ruletype");
            if (null == ruletype) {
                this.getModel().setValue("ruletype", (Object)"private");
            } else {
                this.getModel().setValue("ruletype", ruletype);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (KEY_TABLE.equals(propertyName)) {
            DynamicObject newValue;
            int rowIndex = changeData.getRowIndex();
            this.getModel().setValue(KEY_ABSOLUTE, null, rowIndex);
            this.getModel().setValue(KEY_FILTERCONDITION, null, rowIndex);
            this.getModel().setValue(KEY_CONDITIONJSON, null, rowIndex);
            this.getModel().setValue(KEY_ABSOLUTE, (Object)Boolean.FALSE, rowIndex);
            this.getModel().setValue(KEY_FETCHFIELD, null, rowIndex);
            IDataEntityProperty property = this.getModel().getProperty(KEY_ADVANCEDCONF);
            if (property != null) {
                this.getModel().setValue(KEY_ADVANCEDCONF, null, rowIndex);
            }
            if ((newValue = (DynamicObject)changeData.getNewValue()) != null) {
                String entityname = newValue.getString("entityname");
                if (EntityV3Constant.ENTITY_V3.containsKey(entityname)) {
                    this.getModel().setValue(KEY_BASEDATATYPE, (Object)"tpo_col_member", rowIndex);
                } else {
                    this.getModel().setValue(KEY_BASEDATATYPE, (Object)"tctb_datasource_entry", rowIndex);
                }
            }
        } else if (KEY_FETCHFIELD.equals(propertyName)) {
            DynamicObject changeField = (DynamicObject)e.getChangeSet()[0].getNewValue();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            if (changeField == null) {
                return;
            }
            DynamicObject tableValue = (DynamicObject)this.getModel().getValue(KEY_TABLE, rowIndex);
            if (tableValue != null) {
                Optional<DynamicObject> first;
                String entityname = tableValue.getString("entityname");
                if (EntityV3Constant.ENTITY_V3.containsKey(entityname)) {
                    this.getModel().setValue(KEY_ABSOLUTE, (Object)Boolean.FALSE, rowIndex);
                } else {
                    String value = changeField.getString("fieldname");
                    DynamicObject obj = this.queryDatasourceEntry(tableValue, value);
                    if (obj != null) {
                        String table = obj.getString("fieldsubname");
                        BiPredicate<String, String> tdmBalance = AbstractAccessConfigPlugin.predicate("tdm_balance_new", Lists.newArrayList((Object[])new String[]{"closinglocalcurrency", "openinglocalcurrency"}));
                        BiPredicate<String, String> glBalance = AbstractAccessConfigPlugin.predicate("gl_balance", Lists.newArrayList((Object[])new String[]{"beginlocal", "endlocal"}));
                        if (tdmBalance.test(table, value) || glBalance.test(table, value)) {
                            this.getModel().setValue(KEY_ABSOLUTE, (Object)Boolean.TRUE, rowIndex);
                        } else {
                            this.getModel().setValue(KEY_ABSOLUTE, (Object)Boolean.FALSE, rowIndex);
                        }
                    }
                }
                DynamicObject amountfield = (DynamicObject)this.getModel().getValue(KEY_FETCHFIELD, rowIndex);
                long entryId = amountfield.getLong("id");
                String defaultValue = null;
                if (EntityV3Constant.ENTITY_V3.containsKey(tableValue.getString("entityname"))) {
                    first = tableValue.getDynamicObjectCollection(ENTRY_ENTITY).stream().filter(o -> "column".equals(o.getString("fieldname"))).findFirst();
                    if (first.isPresent()) {
                        amountfield = first.get();
                    }
                    defaultValue = this.getDefaultAdvanceFromFormParams(tableValue.getLong("id"), null);
                } else {
                    first = tableValue.getDynamicObjectCollection(ENTRY_ENTITY).stream().filter(o -> entryId == o.getLong("id")).findFirst();
                    if (first.isPresent()) {
                        amountfield = first.get();
                    }
                }
                if (amountfield != null) {
                    RuleTemplateBusiness.setAdvanceConfDefaultValue(this.getModel(), rowIndex, tableValue, amountfield, KEY_ADVANCEDCONF, "advancedconfjson", defaultValue);
                }
            }
        }
    }

    private String getDefaultAdvanceFromFormParams(Long datasourceId, String filedKey) {
        String key1 = datasourceId + "_" + filedKey;
        String defaultValue = (String)this.getView().getFormShowParameter().getCustomParam(key1);
        if (StringUtil.isNotEmpty((CharSequence)defaultValue)) {
            return defaultValue;
        }
        String key2 = datasourceId + "_*";
        return (String)this.getView().getFormShowParameter().getCustomParam(key2);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        RuleTemplateBusiness.setRuleConfig(event, this.getModel(), this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        int currentRowIndex;
        Map filterData;
        super.closedCallBack(evt);
        if ("setting".equals(evt.getActionId()) && (filterData = (Map)evt.getReturnData()) != null) {
            currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            this.getModel().setValue(KEY_FILTERCONDITION, filterData.get("filterdescription"), currentRowIndex);
            this.getModel().setValue(KEY_CONDITIONJSON, filterData.get("filtervalue"), currentRowIndex);
        }
        if ("setadvancedconf".equals(evt.getActionId()) && (filterData = (Map)evt.getReturnData()) != null) {
            Object datatype;
            currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY);
            this.getModel().setValue(KEY_ADVANCEDCONF, filterData.get(KEY_ADVANCEDCONF), currentRowIndex);
            this.getModel().setValue("advancedconfjson", filterData.get("advancedconfjson"), currentRowIndex);
            if (("tcvvt_tax_accessconfig".equalsIgnoreCase(this.getView().getEntityId()) || "tcvvt_qh_accessconfig".equalsIgnoreCase(this.getView().getEntityId())) && filterData.get("jsbl") != null) {
                this.getModel().setValue("jsbl", filterData.get("jsbl"), currentRowIndex);
            }
            if (this.getModel().getDataEntityType().getAllFields().containsKey("exratejson")) {
                this.getModel().setValue("exratejson", filterData.get("convert_rate_json"), currentRowIndex);
            }
            if ((datatype = this.getModel().getValue("datatype", currentRowIndex)).equals("jsflqs") || datatype.equals("cysldsqs") || datatype.equals("sehshsj")) {
                this.getModel().setValue("vatrate", filterData.get("vatrate"), currentRowIndex);
            } else if (datatype.equals("gjqs")) {
                this.getModel().setValue("jsbl", filterData.get("jsbl"), currentRowIndex);
            } else if (datatype.equals("yjjsflqs")) {
                this.getModel().setValue("vatrate", filterData.get("vatrate"), currentRowIndex);
                this.getModel().setValue("yzvatrate", filterData.get("yzvatrate"), currentRowIndex);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("setting".equalsIgnoreCase(operateKey) || "setadvancedconf".equalsIgnoreCase(operateKey)) {
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue(KEY_TABLE, focusRow);
            if (tabletype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"AbstractAccessConfigPlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String ischild = tabletype.getString("ischild");
            String entityNumber = tabletype.getString("name");
            if ("setting".equals(((Donothing)args.getSource()).getOperateKey())) {
                if ("false".equals(ischild) && StringUtil.isNotBlank((CharSequence)tabletype.getString("subname"))) {
                    entityNumber = tabletype.getString("subname");
                }
                this.openSettingPage(focusRow, tabletype.getLong("id"), entityNumber, ENTRY_ENTITY, KEY_CONDITIONJSON, "setting");
            } else if ("setadvancedconf".equals(((Donothing)args.getSource()).getOperateKey())) {
                this.operateAdvanceConfig(args);
            }
        }
    }

    public void operateAdvanceConfig(BeforeDoOperationEventArgs args) {
        EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int focusRow = entryentity.getEntryState().getFocusRow();
        String advancedconfjson = (String)this.getModel().getValue("advancedconfjson", focusRow);
        String datatype = (String)this.getModel().getValue("datatype", focusRow);
        BigDecimal vatrate = BigDecimal.ZERO;
        if (datatype.equals("jsflqs") || datatype.equals("cysldsqs")) {
            vatrate = (BigDecimal)this.getModel().getValue("vatrate", focusRow);
        }
        AdvanceConfDto advanceConfDto = new AdvanceConfDto(advancedconfjson, datatype, vatrate);
        RuleTemplateBusiness.operationConfigClick(this.getModel(), this.getView(), advanceConfDto, args, entryentity, (IFormPlugin)this);
    }

    protected void openSettingPage(int rowIndex, long entityId, String entityNumber, String entityfield, String conditionjson, String actionId) {
        DynamicObject org;
        IDataEntityProperty orgProperty;
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(entityfield, rowIndex);
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_filterconditions");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, actionId);
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityId", (Object)entityId);
        formshowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        formshowParameter.setCustomParam("filterJson", selectedRow.get(conditionjson));
        formshowParameter.setCustomParam("description", selectedRow.get(KEY_FILTERCONDITION));
        Object ruleType = this.getView().getFormShowParameter().getCustomParams().get("ruletype");
        if (null != ruleType) {
            formshowParameter.setCustomParam("ruletype", ruleType);
        }
        if ((orgProperty = this.getModel().getProperty("org")) != null && (org = (DynamicObject)this.getModel().getValue("org")) != null) {
            formshowParameter.setCustomParam("orgid", (Object)org.getString("id"));
        }
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    private static BiPredicate<String, String> predicate(String table, List<String> columns) {
        BiPredicate<String, String> predicate = (table1, amountValue1) -> table.equals(table1) && columns.contains(amountValue1);
        return predicate;
    }

    private DynamicObject queryDatasourceEntry(DynamicObject tableValue, String value) {
        QFilter tableIdQfilter = new QFilter("tableid", "=", tableValue.get("id"));
        QFilter fieldnameQfilter = new QFilter("fieldname", "=", (Object)value);
        return QueryServiceHelper.queryOne((String)"tctb_datasource_entry", (String)"fieldsubname", (QFilter[])new QFilter[]{tableIdQfilter, fieldnameQfilter});
    }
}

