/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.changemodel;

import java.util.List;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.taxc.bdtaxr.business.changemodel.ChangeResumeBusiness;
import kd.taxc.bdtaxr.business.changemodel.XBillBusiness;
import kd.taxc.bdtaxr.formplugin.changemodel.helper.SrcBillChangeHelper;

public class SrcBillChangePlugin
extends AbstractFormPlugin {
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (operate.getOperateKey().equals("bizchange")) {
            RefObject afterConfirm = new RefObject();
            if (!operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("bizchange", (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u8981\u5bf9\u5f53\u524d\u5355\u636e\u8fdb\u884c\u53d8\u66f4?", (String)"SrcBillChangePlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getCallBackId().equals("bizchange") && evt.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
            this.getView().invokeOperation("bizchange", operateOption);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            if (operate.getOperateKey().equals("bizchange")) {
                DynamicObject xbill;
                OperationResult opRes = args.getOperationResult();
                List billPks = opRes.getSuccessPkIds();
                String srcBillEntity = this.getModel().getDataEntityType().getName();
                if (!billPks.isEmpty() && (xbill = XBillBusiness.getOnWayXBill((Long)billPks.get(0), srcBillEntity)) != null) {
                    BillShowParameter fsp = new BillShowParameter();
                    fsp.setFormId(xbill.getDataEntityType().getName());
                    fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    fsp.setPkId(xbill.get("id"));
                    this.getView().showForm((FormShowParameter)fsp);
                }
            } else if (operate.getOperateKey().equals("bizchangeresume")) {
                long srcbillid = (Long)this.getModel().getValue("id");
                DynamicObject changeRecord = ChangeResumeBusiness.getChangeResumeBySrcBillId(srcbillid);
                if (changeRecord != null) {
                    Optional<String> result = SrcBillChangeHelper.checkPermission4SrcChangeResume(srcbillid, operate.getEntityId());
                    if (result.isPresent()) {
                        this.getView().showErrorNotification(result.get());
                    } else {
                        FormShowParameter changeResume = new FormShowParameter();
                        changeResume.setFormId("bdtaxr_changeresumeform");
                        changeResume.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                        changeResume.setStatus(OperationStatus.VIEW);
                        changeResume.setCustomParam("srcbillid", (Object)srcbillid);
                        changeResume.setCustomParam("srcbillno", this.getModel().getValue("number"));
                        changeResume.setCustomParam("srcbillentity", changeRecord.get("srcbillentity"));
                        this.getView().showForm(changeResume);
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5b9e\u9645\u53d1\u751f\u7684\u53d8\u66f4\u6570\u636e\uff0c\u6682\u672a\u8bb0\u5f55\u53d8\u66f4\u8be6\u60c5\u4fe1\u606f\u3002", (String)"SrcBillChangePlugin_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                }
            }
        }
    }
}

