/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.changemodel;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.taxc.bdtaxr.business.changemodel.ChangeModelBusiness;
import kd.taxc.bdtaxr.business.changemodel.ChangeResumeBusiness;
import kd.taxc.bdtaxr.common.enums.changemodel.BizChangeTypeEnum;
import kd.taxc.bdtaxr.common.utils.ChangeModelUtil;
import kd.taxc.bdtaxr.formplugin.changemodel.helper.XBillChangeHelper;

public class XBillChangePlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
EntryGridBindDataListener {
    private static Log logger = LogFactory.getLog(XBillChangePlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        String billtype;
        DynamicObject changeModel;
        super.preOpenForm(e);
        FormShowParameter formShowPar = e.getFormShowParameter();
        OperationStatus operationStatus = formShowPar.getStatus();
        if (OperationStatus.ADDNEW.getValue() != operationStatus.getValue() && formShowPar.getFormConfig() != null && !ChangeModelUtil.isNull(formShowPar.getFormConfig().getEntityTypeId()) && (changeModel = ChangeModelBusiness.getChangeModel4XBill(billtype = formShowPar.getFormConfig().getEntityTypeId())) == null) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6ca1\u6709\u542f\u7528\u7684\u53d8\u66f4\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u670d\u52a1\u4eba\u5458\u7ef4\u62a4\u53d8\u66f4\u65b9\u6848\u6570\u636e\u3002", (String)"XBillChangePlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    protected Map<String, Map<String, String>> getXBillEntryAndOp() {
        return XBillChangeHelper.getXBillEntryAndOp(this.getModel().getDataEntityType().getName());
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        List rows = e.getRows();
        if (rows == null || rows.size() == 0) {
            return;
        }
        Map<String, Map<String, String>> xBillEntrys = this.getXBillEntryAndOp();
        if (xBillEntrys == null || xBillEntrys.isEmpty()) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)e.getSource();
        String entryEntity = entryGrid.getKey();
        if (!xBillEntrys.containsKey(entryEntity)) {
            return;
        }
        Map<String, String> xBillEntry = xBillEntrys.get(entryEntity);
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        String[] unEnableEntryPropertys = ChangeModelBusiness.getUnEnableProperty(dt, entryEntity);
        for (RowDataEntity row : rows) {
            int index = row.getRowIndex();
            String changeType = (String)this.getModel().getValue(xBillEntry.get("changetype"), index);
            if (BizChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                this.getView().setEnable(Boolean.FALSE, index, unEnableEntryPropertys);
                continue;
            }
            if (!BizChangeTypeEnum.DELETE.getValue().equals(changeType)) continue;
            entryGrid.setRowLock(true, new int[]{index});
        }
    }

    public void beforeBindData(EventObject e) {
        Map<String, Map<String, String>> entryAndOp = this.getXBillEntryAndOp();
        if (entryAndOp == null || entryAndOp.isEmpty()) {
            return;
        }
        String billno = entryAndOp.get("_bill").get("number");
        MainEntityType entityType = this.getModel().getDataEntityType();
        if (entityType instanceof BillEntityType) {
            ((BillEntityType)entityType).setBillNo(billno);
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel bill = this.getModel();
        for (IDataEntityProperty entityProperty : bill.getDataEntityType().getProperties()) {
            if (entityProperty instanceof SubEntryProp || !(entityProperty instanceof EntryProp)) continue;
            DynamicObjectCollection entrys = (DynamicObjectCollection)bill.getValue(entityProperty.getName());
            for (DynamicObject entry : entrys) {
                entry.getDataEntityState().setDirty(true);
                entry.getDataEntityState().setBizChanged(true);
                entry.getDataEntityState().setBizChangeFlags(entry.getDataEntityState().getDirtyFlags());
                for (IDataEntityProperty subEntityProperty : entry.getDataEntityType().getProperties()) {
                    if (!(subEntityProperty instanceof SubEntryProp)) continue;
                    DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection(subEntityProperty.getName());
                    for (DynamicObject subEntry : subEntrys) {
                        subEntry.getDataEntityState().setDirty(true);
                        subEntry.getDataEntityState().setBizChanged(true);
                        subEntry.getDataEntityState().setBizChangeFlags(subEntry.getDataEntityState().getDirtyFlags());
                    }
                }
            }
        }
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        String[] unEnablePropertys = ChangeModelBusiness.getUnEnableProperty(dt);
        if (!ChangeModelUtil.isNull(unEnablePropertys)) {
            this.getView().setEnable(Boolean.FALSE, unEnablePropertys);
        }
    }

    public void afterBindData(EventObject e) {
        XBillChangeHelper.initFieldsEdit(this.getView());
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        int row = evt.getRow();
        if (evt.getSource() instanceof EntryGrid && row > -1) {
            EntryGrid entrygrid = (EntryGrid)evt.getSource();
            String clickEntryKey = entrygrid.getKey();
            ArrayList<String> clickEntryAndSubList = new ArrayList<String>();
            clickEntryAndSubList.add(clickEntryKey);
            List subEntryGrids = entrygrid.getSubEntryGrids();
            if (subEntryGrids != null) {
                clickEntryAndSubList.addAll(subEntryGrids);
            }
            Map<String, Map<String, String>> xBillEntrys = this.getXBillEntryAndOp();
            for (String entryKey : clickEntryAndSubList) {
                DynamicObject[] dynamicObjects;
                if (!xBillEntrys.containsKey(entryKey)) continue;
                Map<String, String> xBillEntry = xBillEntrys.get(entryKey);
                String[] unEnableEntryPropertys = ChangeModelBusiness.getUnEnableProperty(dt, entryKey);
                if (entryKey.equals(clickEntryKey)) {
                    String changeType = (String)this.getModel().getValue(xBillEntry.get("changetype"), row);
                    if (BizChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                        this.getView().setEnable(Boolean.FALSE, row, unEnableEntryPropertys);
                        continue;
                    }
                    if (!BizChangeTypeEnum.DELETE.getValue().equals(changeType)) continue;
                    entrygrid.setRowLock(true, new int[]{row});
                    continue;
                }
                EntryGrid subEntrygrid = (EntryGrid)this.getControl(entryKey);
                if (subEntrygrid == null || subEntrygrid.getEntryData() == null) continue;
                EntryData subEntryData = subEntrygrid.getEntryData();
                boolean isSplitPage = subEntrygrid.isSplitPage();
                int pageCount = subEntryData.getPageCount();
                if (isSplitPage) {
                    if (pageCount <= 0) continue;
                    int startIdx = subEntryData.getStartIndex();
                    int endIdx = subEntryData.getEndIndex();
                    for (int i = startIdx; i < endIdx; ++i) {
                        String changeType = (String)this.getModel().getValue(xBillEntry.get("changetype"), i);
                        if (BizChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                            this.getView().setEnable(Boolean.FALSE, i, unEnableEntryPropertys);
                            continue;
                        }
                        if (!BizChangeTypeEnum.DELETE.getValue().equals(changeType)) continue;
                        entrygrid.setRowLock(true, new int[]{i});
                    }
                    continue;
                }
                if (subEntryData.getDataEntitys() == null || (dynamicObjects = subEntryData.getDataEntitys()).length <= 0) continue;
                for (int i = 0; i < dynamicObjects.length; ++i) {
                    String changeType = (String)this.getModel().getValue(xBillEntry.get("changetype"), i);
                    if (BizChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                        this.getView().setEnable(Boolean.FALSE, i, unEnableEntryPropertys);
                        continue;
                    }
                    if (!BizChangeTypeEnum.DELETE.getValue().equals(changeType)) continue;
                    entrygrid.setRowLock(true, new int[]{i});
                }
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs evt) {
        RowDataEntity[] rowDataEntitys;
        IDataModel xBill = this.getModel();
        String entryEntity = evt.getEntryProp().getName();
        Map<String, String> xBillEntry = this.getXBillEntryAndOp().get(entryEntity);
        if (xBillEntry == null) {
            return;
        }
        for (RowDataEntity rowDataEntity : rowDataEntitys = evt.getRowDataEntities()) {
            xBill.setValue(xBillEntry.get("changetype"), (Object)BizChangeTypeEnum.ADDNEW.getValue(), rowDataEntity.getRowIndex());
        }
        Map<String, Map<String, String>> result = this.getXBillEntryAndOp();
        String changeType = result.get(entryEntity).get("changetype");
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        String[] unEnableProperty = ChangeModelBusiness.getUnEnableProperty(dt, entryEntity);
        int rowCount = this.getModel().getEntryRowCount(entryEntity);
        for (int i = 0; i < rowCount; ++i) {
            if (!BizChangeTypeEnum.UPDATE.getValue().equals(xBill.getValue(changeType, i)) && !BizChangeTypeEnum.ADDNEW.getValue().equals(xBill.getValue(changeType, i)) || ChangeModelUtil.isNull(unEnableProperty)) continue;
            this.getView().setEnable(Boolean.FALSE, i, unEnableProperty);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs evt) {
        IDataModel xBill = this.getModel();
        String entryEntity = evt.getEntryProp().getName();
        IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
        Map<String, String> xBillEntry = this.getXBillEntryAndOp().get(entryEntity);
        if (xBillEntry == null) {
            return;
        }
        for (int curRow : evt.getRowIndexs()) {
            if (!BizChangeTypeEnum.UPDATE.getValue().equals(xBill.getValue(xBillEntry.get("changetype"), curRow)) && !BizChangeTypeEnum.DELETE.getValue().equals(xBill.getValue(xBillEntry.get("changetype"), curRow))) continue;
            xBill.setValue(xBillEntry.get("changetype"), (Object)BizChangeTypeEnum.DELETE.getValue(), curRow);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryEntity);
            entryGrid.setRowLock(true, new int[]{curRow});
            evt.setCancel(true);
        }
    }

    public void registerListener(EventObject e) {
        Map<String, Map<String, String>> xBillEntrys = this.getXBillEntryAndOp();
        for (Map.Entry<String, Map<String, String>> entry : xBillEntrys.entrySet()) {
            String entryEntity = entry.getKey();
            Control entryGrid = this.getView().getControl(entryEntity);
            if (entryGrid == null || !(entryGrid instanceof EntryGrid)) continue;
            ((EntryGrid)entryGrid).addDataBindListener((EntryGridBindDataListener)this);
            ((EntryGrid)entryGrid).addRowClickListener((RowClickEventListener)this);
            String entryToolBar = entry.getValue().get("entry_toolbar");
            if (ChangeModelUtil.isNull(entryToolBar)) continue;
            this.addItemClickListeners(new String[]{entryToolBar});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        String entryKeyName = e.getProperty().getParent().getName();
        Map<String, Map<String, String>> result = this.getXBillEntryAndOp();
        if (!result.containsKey(entryKeyName)) {
            return;
        }
        ChangeData[] changeSet = e.getChangeSet();
        block6: for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            int rowIndex = changeData.getRowIndex();
            switch (fieldKey) {
                case "entrychangetype": {
                    this.changeEntryChangeType(entryKeyName, newValue, rowIndex);
                    continue block6;
                }
            }
        }
    }

    private void changeEntryChangeType(String entryEntityName, Object newValue, int rowIndex) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(entryEntityName);
        if (newValue instanceof String) {
            String entryChangeType = (String)newValue;
            if (BizChangeTypeEnum.UPDATE.getValue().equalsIgnoreCase(entryChangeType)) {
                entryGrid.setRowBackcolor("#ecf6ff", new int[]{rowIndex});
            }
            if (BizChangeTypeEnum.DELETE.getValue().equals(entryChangeType)) {
                entryGrid.setRowBackcolor("#fef1d0", new int[]{rowIndex});
            } else if (BizChangeTypeEnum.ADDNEW.getValue().equals(entryChangeType)) {
                entryGrid.setRowBackcolor("#d5fbe2", new int[]{rowIndex});
            }
        }
    }

    public void initialize() {
        Map<String, Map<String, String>> xBillEntrys = this.getXBillEntryAndOp();
        for (Map.Entry<String, Map<String, String>> entry : xBillEntrys.entrySet()) {
            String entryEntity = entry.getKey();
            Control entryGrid = this.getView().getControl(entryEntity);
            if (entryGrid == null || !(entryGrid instanceof EntryGrid)) continue;
            ((EntryGrid)entryGrid).addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String evtItemKey = evt.getItemKey();
        Map<String, Map<String, String>> result = this.getXBillEntryAndOp();
        for (Map.Entry<String, Map<String, String>> entry : result.entrySet()) {
            int[] selectRows;
            if (!evtItemKey.equals(entry.getValue().get("btn_modify")) && !evt.getItemKey().equals(entry.getValue().get("btn_delete"))) continue;
            String entryEntity = entry.getKey();
            Control entryGrid = this.getView().getControl(entryEntity);
            if (entryGrid == null || !(entryGrid instanceof EntryGrid) || (selectRows = ((EntryGrid)entryGrid).getSelectRows()).length > 0) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5206\u5f55\u884c\u3002", (String)"XBillChangePlugin_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        Map<String, Map<String, String>> result = this.getXBillEntryAndOp();
        IDataModel xBill = this.getModel();
        for (Map.Entry<String, Map<String, String>> entry : result.entrySet()) {
            EntryGrid grid;
            int[] selectRows;
            if (!evt.getItemKey().equals(entry.getValue().get("btn_modify"))) continue;
            String entryEntity = entry.getKey();
            Control entryGrid = this.getView().getControl(entryEntity);
            if (entryGrid == null || !(entryGrid instanceof EntryGrid) || (selectRows = (grid = (EntryGrid)entryGrid).getSelectRows()).length <= 0) continue;
            boolean nocanmodidataflag = true;
            IDataEntityType dt = this.getModel().getDataEntity().getDataEntityType();
            String[] unEnableProperty = ChangeModelBusiness.getUnEnableProperty(dt, entryEntity);
            for (int selectRow : selectRows) {
                if (BizChangeTypeEnum.ADDNEW.getValue().equals(this.getModel().getValue(result.get(entryEntity).get("changetype"), selectRow)) || BizChangeTypeEnum.UPDATE.getValue().equals(this.getModel().getValue(result.get(entryEntity).get("changetype"), selectRow))) continue;
                grid.setRowLock(false, new int[]{selectRow});
                IClientViewProxy viewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                Object controlMetaState = viewProxy.getLockState("entryentity");
                EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)dt.getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
                xBill.setValue(result.get(entryEntity).get("changetype"), (Object)BizChangeTypeEnum.UPDATE.getValue(), selectRow);
                this.getView().setEnable(Boolean.FALSE, selectRow, unEnableProperty);
                nocanmodidataflag = false;
            }
            if (!nocanmodidataflag) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d8\u66f4\u65b9\u5f0f\u4e3a\u201c\u5220\u9664\u201d\u72b6\u6001\u7684\u5206\u5f55\u884c\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u3002", (String)"XBillChangePlugin_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String xBillEntity = this.getModel().getDataEntityType().getName();
        switch (operate.getOperateKey()) {
            case "save": 
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": 
            case "bizvalid": {
                DynamicObject changeModel = ChangeModelBusiness.getChangeModel4XBill(xBillEntity);
                if (changeModel != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6ca1\u6709\u542f\u7528\u7684\u53d8\u66f4\u65b9\u6848\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u670d\u52a1\u4eba\u5458\u7ef4\u62a4\u53d8\u66f4\u65b9\u6848\u6570\u636e\u3002", (String)"XBillChangePlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && operate.getOperateKey().equals("bizchangeresume")) {
            long xBillID = (Long)this.getModel().getValue("id");
            DynamicObject changerecord = ChangeResumeBusiness.getChangeResumeByXBillId(xBillID);
            if (changerecord != null) {
                FormShowParameter changeResume = new FormShowParameter();
                changeResume.setFormId("bdtaxr_changeresumeform");
                changeResume.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                changeResume.setStatus(OperationStatus.VIEW);
                changeResume.setCustomParam("srcbillid", changerecord.get("srcbillid"));
                changeResume.setCustomParam("srcbillno", changerecord.get("srcbillno"));
                changeResume.setCustomParam("srcbillentity", changerecord.get("srcbillentity"));
                changeResume.setCustomParam("xbillid", (Object)xBillID);
                this.getView().showForm(changeResume);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5b9e\u9645\u53d1\u751f\u7684\u53d8\u66f4\u6570\u636e\uff0c\u6682\u672a\u8bb0\u5f55\u53d8\u66f4\u8be6\u60c5\u4fe1\u606f\u3002", (String)"XBillChangePlugin_3", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            }
        }
    }
}

