/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.changemodel.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.TreeEntryType;
import kd.bos.entity.property.LargeTextProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.changemodel.ChangeModelBusiness;
import kd.taxc.bdtaxr.business.changemodel.CommonDataBusiness;
import kd.taxc.bdtaxr.common.enums.changemodel.BizChangeTypeEnum;
import kd.taxc.bdtaxr.common.utils.ChangeModelUtil;

public class XBillChangeHelper {
    private static final Log logger = LogFactory.getLog(XBillChangeHelper.class);

    public static void setEntryChangeType(IFormView view, String entryName, String field, List<String> fieldValues) {
        String sourcebillentity = view.getModel().getDataEntity().getString("sourcebillentity");
        DynamicObject srcBill = CommonDataBusiness.loadSingle(view.getModel().getDataEntity().getLong("sourcebillid"), sourcebillentity);
        DynamicObject changeModel = ChangeModelBusiness.getChangeModel4XBill(view.getEntityId());
        DynamicObjectCollection xBillEntrys = view.getModel().getDataEntity(true).getDynamicObjectCollection(entryName);
        DynamicObjectCollection srcBillEntries = srcBill.getDynamicObjectCollection(entryName);
        String xBillEntryName = xBillEntrys.getDynamicObjectType().getName();
        Map<String, Map<String, String>> entryAndOp = ChangeModelBusiness.getXBillEntryAndOp(changeModel);
        String entrychangetype = entryAndOp.get(xBillEntryName).get("changetype");
        String entrysrcid = entryAndOp.get(xBillEntryName).get("srcid");
        HashMap<Long, Long> srcMap = new HashMap<Long, Long>(10);
        for (DynamicObject entry : xBillEntrys) {
            if (entry.getLong(entrysrcid) == 0L) {
                entry.set(entrychangetype, (Object)BizChangeTypeEnum.ADDNEW.getValue());
            } else {
                entry.set(entrychangetype, (Object)BizChangeTypeEnum.UPDATE.getValue());
            }
            srcMap.put(entry.getLong(entrysrcid), entry.getLong("id"));
        }
        boolean isTreeEntry = false;
        if (xBillEntrys.getDynamicObjectType().getClass() == TreeEntryType.class) {
            isTreeEntry = true;
        }
        if (srcBillEntries.size() == 0) {
            return;
        }
        List deleleRows = srcBillEntries.stream().filter(v -> !fieldValues.contains(String.valueOf(v.get(field)))).collect(Collectors.toList());
        if (deleleRows.size() > 0) {
            long[] ids = DB.genLongIds((String)(view.getEntityId() + "." + xBillEntrys.getDynamicObjectType().getName()), (int)deleleRows.size());
            DynamicObject deleleRow = null;
            int size = deleleRows.size();
            for (int i = 0; i < size; ++i) {
                deleleRow = (DynamicObject)deleleRows.get(i);
                DynamicObjectCollection mapplingEntitys = changeModel.getDynamicObjectCollection("mappingentity");
                DynamicObject xBillEntry = xBillEntrys.addNew();
                xBillEntry.set("id", (Object)ids[i]);
                xBillEntry.set(entrysrcid, deleleRow.get("id"));
                xBillEntry.set(entrychangetype, (Object)BizChangeTypeEnum.DELETE.getValue());
                if (isTreeEntry) {
                    xBillEntry.set("pid", (Object)deleleRow.getLong("pid"));
                }
                srcMap.put(deleleRow.getLong("id"), xBillEntry.getLong("id"));
                LocaleString headTitle = ResManager.getLocaleString((String)ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"XBillChangeHelper_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), (String)"BillTransferService_0", (String)"taxc-bdtaxr-base");
                for (DynamicObject mapplingEntity : mapplingEntitys) {
                    String targetFieldName = mapplingEntity.getString("targetfieldname");
                    String sourceFieldName = mapplingEntity.getString("sourcefieldname");
                    if (ChangeModelUtil.isNull(sourceFieldName)) continue;
                    String[] targetItems = targetFieldName.split("\\.");
                    String[] sourceItems = sourceFieldName.split("\\.");
                    if (targetItems.length != 2 || sourceItems.length != 2 || headTitle != null && headTitle.containsValue((Object)targetItems[0])) continue;
                    DataEntityPropertyCollection entryProps = xBillEntrys.getDynamicObjectType().getProperties();
                    if (mapplingEntity.getString("targetfield").equals(entrychangetype) || mapplingEntity.getString("targetfield").equals(entrysrcid) || !xBillEntry.containsProperty(mapplingEntity.getString("targetfield"))) continue;
                    xBillEntry.set(mapplingEntity.getString("targetfield"), deleleRow.get(mapplingEntity.getString("sourcefield")));
                    IDataEntityProperty prop = (IDataEntityProperty)entryProps.get((Object)mapplingEntity.getString("targetfield"));
                    if (!(prop instanceof LargeTextProp)) continue;
                    xBillEntry.set(mapplingEntity.getString("targetfield") + "_tag", deleleRow.get(mapplingEntity.getString("sourcefield") + "_tag"));
                }
            }
        }
        if (isTreeEntry) {
            for (DynamicObject entry : xBillEntrys) {
                if (!BizChangeTypeEnum.DELETE.getValue().equalsIgnoreCase(entry.getString(entrychangetype))) continue;
                entry.set("pid", srcMap.get(entry.getLong("pid")));
            }
        }
        view.updateView(entryName);
        XBillChangeHelper.initFieldsEdit(view);
    }

    public static void initFieldsEdit(IFormView view) {
        IDataEntityType dt = view.getModel().getDataEntity().getDataEntityType();
        String[] unEnablePropertys = ChangeModelBusiness.getUnEnableProperty(dt);
        if (!ChangeModelUtil.isNull(unEnablePropertys)) {
            view.setEnable(Boolean.FALSE, unEnablePropertys);
        }
        Map<String, Map<String, String>> result = XBillChangeHelper.getXBillEntryAndOp(dt.getName());
        for (Map.Entry<String, Map<String, String>> entry : result.entrySet()) {
            DynamicObject[] dynamicObjects;
            String entryEntity = entry.getKey();
            EntryGrid entrygrid = (EntryGrid)view.getControl(entryEntity);
            if (entrygrid == null || entrygrid.getEntryData() == null) continue;
            Map<String, String> xBillEntry = result.get(entryEntity);
            String[] unEnableEntryPropertys = ChangeModelBusiness.getUnEnableProperty(dt, entryEntity);
            String[] allEntryProperties = ChangeModelBusiness.getProperty4Entry(dt, entryEntity);
            EntryData entrydata = entrygrid.getEntryData();
            boolean isSplitPage = entrygrid.isSplitPage();
            int pageCount = entrydata.getPageCount();
            if (isSplitPage) {
                if (pageCount <= 0) continue;
                int startIdx = entrydata.getStartIndex();
                int endIdx = entrydata.getEndIndex();
                for (int i = startIdx; i < endIdx; ++i) {
                    String changeType = (String)view.getModel().getValue(xBillEntry.get("changetype"), i);
                    if (BizChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                        view.setEnable(Boolean.FALSE, i, unEnableEntryPropertys);
                        entrygrid.setRowBackcolor("#ecf6ff", new int[]{i});
                        continue;
                    }
                    if (BizChangeTypeEnum.DELETE.getValue().equals(changeType)) {
                        view.setEnable(Boolean.FALSE, i, allEntryProperties);
                        entrygrid.setRowBackcolor("#fef1d0", new int[]{i});
                        continue;
                    }
                    if (!BizChangeTypeEnum.ADDNEW.getValue().equals(changeType)) continue;
                    entrygrid.setRowBackcolor("#d5fbe2", new int[]{i});
                }
                continue;
            }
            if (entrydata.getDataEntitys() == null || (dynamicObjects = entrydata.getDataEntitys()).length <= 0) continue;
            for (int i = 0; i < dynamicObjects.length; ++i) {
                String changeType = (String)view.getModel().getValue(xBillEntry.get("changetype"), i);
                if (BizChangeTypeEnum.UPDATE.getValue().equals(changeType)) {
                    view.setEnable(Boolean.FALSE, i, unEnableEntryPropertys);
                    entrygrid.setRowBackcolor("#ecf6ff", new int[]{i});
                    continue;
                }
                if (BizChangeTypeEnum.DELETE.getValue().equals(changeType)) {
                    view.setEnable(Boolean.FALSE, i, unEnableEntryPropertys);
                    entrygrid.setRowBackcolor("#fef1d0", new int[]{i});
                    continue;
                }
                if (!BizChangeTypeEnum.ADDNEW.getValue().equals(changeType)) continue;
                entrygrid.setRowBackcolor("#d5fbe2", new int[]{i});
            }
        }
    }

    public static Map<String, Map<String, String>> getXBillEntryAndOp(String xBillEntity) {
        Map<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(2);
        DynamicObject changeModel = ChangeModelBusiness.getChangeModel4XBill(xBillEntity);
        if (changeModel != null && (result = ChangeModelBusiness.getXBillEntryAndOp(changeModel)).size() == 0) {
            result = ChangeModelBusiness.getDefaultXBillEntryAndOp();
        }
        return result;
    }
}

