/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.declare.tsate;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.helper.tsate.CancelDeclareServiceHelper;
import kd.taxc.bdtaxr.formplugin.declare.tsate.TsateBaseDeclarePlugin;

public class CancelDeclarePlugin
extends TsateBaseDeclarePlugin {
    private static final String BTN_CANCEL = "btn_undo";
    private static Log LOGGER = LogFactory.getLog(CancelDeclarePlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals(BTN_CANCEL)) {
            this.cancelOperation();
        }
    }

    private void cancelOperation() {
        if (!this.checkTsateLicense()) {
            return;
        }
        ArrayList<Long> declareIds = new ArrayList<Long>(8);
        if (!this.validSelected(declareIds)) {
            return;
        }
        List<DynamicObject> declareDyns = this.getSelectedDataCompatible(declareIds);
        if (!this.validateData(declareDyns)) {
            return;
        }
        this.undo(declareDyns);
    }

    private boolean validateData(List<DynamicObject> declares) {
        ArrayList<Long> declareIds = new ArrayList<Long>(8);
        for (DynamicObject declare : declares) {
            declareIds.add(declare.getLong("id"));
        }
        Map<Long, String> validateInfos = CancelDeclareServiceHelper.validateCancelData(declareIds).getData();
        if (validateInfos.size() > 0) {
            ArrayList<String> erros = new ArrayList<String>(8);
            erros.addAll(validateInfos.values());
            this.showTip(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"CancelDeclarePlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), erros);
            return false;
        }
        return true;
    }

    public void afterBindData(EventObject e) {
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (!BTN_CANCEL.equals(callBackId)) {
            return;
        }
        if (event.getResult() != MessageBoxResult.Yes) {
            return;
        }
        String customVaule = event.getCustomVaule();
        JSONObject jsonObject = JSONObject.parseObject((String)customVaule);
        List ids = (List)jsonObject.get((Object)"declarePkIds");
        List<DynamicObject> declares = this.getSelectedDataCompatible(ids);
        this.sendTask(declares);
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.refresh();
    }

    private void undo(List<DynamicObject> declares) {
        ArrayList<Long> declarePkIds = new ArrayList<Long>(8);
        StringBuilder detailMsg = new StringBuilder();
        for (DynamicObject declare : declares) {
            detailMsg.append((CharSequence)this.getDeclareDescr(declare)).append(ResManager.loadKDString((String)" \u5df2\u7533\u62a5\u6210\u529f", (String)"CancelDeclarePlugin_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0])).append(SEPARATOR);
            declarePkIds.add(declare.getLong("id"));
        }
        this.undoConfirmTips(detailMsg.toString(), declarePkIds);
    }

    private void undoConfirmTips(String details, List<Long> pkIds) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BTN_CANCEL, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"CancelDeclarePlugin_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"CancelDeclarePlugin_3", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = String.format(ResManager.loadKDString((String)"\u60a8\u5df2\u9009\u4e2d%s\u4efd\u7533\u62a5\u8868\u5df2\u7533\u62a5\u6210\u529f\uff0c\u786e\u5b9a\u8981\u4f5c\u5e9f\u8be5\u7533\u62a5\u8bb0\u5f55\u5417\uff1f", (String)"CancelDeclarePlugin_4", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), pkIds.size());
        HashMap<String, List<Long>> customValueMap = new HashMap<String, List<Long>>();
        customValueMap.put("declarePkIds", pkIds);
        this.getView().showConfirm(msg, details, options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, SerializationUtils.toJsonString(customValueMap));
    }

    private void btnSetting() {
        List<Long> orgIds = this.getOrgFromFilter();
        boolean support = CancelDeclareServiceHelper.support(orgIds).getData();
        this.getView().setVisible(Boolean.valueOf(support), new String[]{BTN_CANCEL});
    }

    private void sendTask(List<DynamicObject> declares) {
        List<Long> declareIds = declares.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        List<Map<String, Object>> executeInfos = CancelDeclareServiceHelper.sendTask(declareIds).getData();
        int totalSize = executeInfos.size();
        int failSize = 0;
        ArrayList<String> faildetail = new ArrayList<String>();
        for (Map<String, Object> info : executeInfos) {
            Boolean isfail = (Boolean)info.get("isfail");
            if (!isfail.booleanValue()) continue;
            ++failSize;
            String failmsg = (String)info.get("failmsg");
            faildetail.add(failmsg);
        }
        this.showTaskInfo(totalSize, totalSize - failSize, failSize, ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u7533\u62a5\u901a\u9053\u7684\u8bb0\u5f55\u65e0\u6cd5\u6267\u884c\u7533\u62a5\u4f5c\u5e9f", (String)"CancelDeclarePlugin_5", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), faildetail);
    }
}

