/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.declare.tsate;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.fileservice.utils.ExceptionUtil;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.helper.tsate.DirectPayServiceHelper;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.declare.tsate.TsateBaseDeclarePlugin;

public class DirectPayPlguin
extends TsateBaseDeclarePlugin {
    private static Log LOGGER = LogFactory.getLog(DirectPayPlguin.class);
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String BTN_DIRECTEPAY = "btn_directpay";
    private static final String CONFIRMKEY_PAY = "pay_confirm";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals(BTN_DIRECTEPAY)) {
            this.payOperation();
        }
    }

    private void payOperation() {
        if (!this.checkTsateLicense()) {
            return;
        }
        List<Long> declareIds = this.getDeclareIds();
        if (!this.validSelected(declareIds)) {
            return;
        }
        List<DynamicObject> declareDyns = this.getSelectedDataCompatible(declareIds);
        if (!this.needContinue(declareDyns).booleanValue()) {
            return;
        }
        this.validatePay(declareDyns);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callBackId = event.getCallBackId();
        if (event.getResult() != MessageBoxResult.Yes || !CONFIRMKEY_PAY.equals(callBackId)) {
            return;
        }
        String customVaule = event.getCustomVaule();
        JSONObject jsonObject = JSONObject.parseObject((String)customVaule);
        List ids = (List)jsonObject.get((Object)"declarePkIds");
        List<DynamicObject> declareDyns = this.getSelectedDataCompatible(ids);
        this.sendTask(declareDyns);
        String controlKey = this.getListControlKey();
        if (StringUtil.isNotBlank((CharSequence)controlKey)) {
            BillList billlist = (BillList)this.getControl(controlKey);
            billlist.refresh();
        }
    }

    void sendTask(List<DynamicObject> declares) {
        List<Map<String, Object>> executeInfos;
        List<Long> declareIds = declares.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        try {
            executeInfos = DirectPayServiceHelper.sendTask(declareIds).getData();
        }
        catch (Exception e) {
            LOGGER.error("DirectPayServiceHelper.sendTask={} ", (Object)ExceptionUtil.toString((Throwable)e));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"TsateBaseDeclarePlugin_6", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            return;
        }
        int totalSize = executeInfos.size();
        int failSize = 0;
        ArrayList<String> faildetail = new ArrayList<String>();
        for (Map<String, Object> info : executeInfos) {
            Boolean isfail = (Boolean)info.get("isfail");
            if (!isfail.booleanValue()) continue;
            ++failSize;
            String failmsg = (String)info.get("failmsg");
            faildetail.add(failmsg);
        }
        this.showTaskInfo(totalSize, totalSize - failSize, failSize, ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a\u672a\u914d\u7f6e\u901a\u9053\u7684\u8bb0\u5f55\u65e0\u6cd5\u76f4\u8fde\u7f34\u6b3e", (String)"DirectPayPlguin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), faildetail);
    }

    void validatePay(List<DynamicObject> declares) {
        Map<Long, String> validateInfos;
        BigDecimal totalBqybtse = BigDecimal.valueOf(0.0);
        ArrayList<Long> declareIds = new ArrayList<Long>(8);
        for (DynamicObject declare : declares) {
            totalBqybtse = totalBqybtse.add(declare.getBigDecimal("bqybtse"));
            declareIds.add(declare.getLong("id"));
        }
        try {
            validateInfos = DirectPayServiceHelper.validatePayData(declareIds).getData();
        }
        catch (Exception e) {
            LOGGER.error("validatePayData\uff1aerror={} ", (Object)ExceptionUtil.toString((Throwable)e));
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"TsateBaseDeclarePlugin_6", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            return;
        }
        if (validateInfos.size() > 0) {
            ArrayList<String> erros = new ArrayList<String>(8);
            erros.addAll(validateInfos.values());
            this.showTip(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"DirectPayPlguin_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), erros);
            return;
        }
        this.confirmMoney(declareIds, totalBqybtse);
    }

    private void confirmMoney(List<Long> pkIds, BigDecimal ybtse) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRMKEY_PAY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"DirectPayPlguin_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"DirectPayPlguin_3", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        HashMap<String, Object> customValueMap = new HashMap<String, Object>();
        customValueMap.put("declarePkIds", pkIds);
        customValueMap.put("ybtse", ybtse.toString());
        String moneryMsg = String.format(ResManager.loadKDString((String)"\u60a8\u5df2\u9009\u4e2d%1$s\u4efd\u7533\u62a5\u8868\uff0c\u7f34\u6b3e\u91d1\u989d\u5408\u8ba1%2$s\uff0c\u53d1\u9001\u7f34\u6b3e\u540e\u65e0\u6cd5\u64a4\u9500\uff0c\u786e\u5b9a\u7f34\u6b3e\u5417\uff1f", (String)"DirectPayPlguin_4", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), pkIds.size(), ybtse.setScale(2, 4));
        this.getView().showConfirm(moneryMsg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, SerializationUtils.toJsonString(customValueMap));
    }
}

