/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.declare.tsate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.constant.TaxcTemplateTypeConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.perm.PermDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tpo.MultiDeclareDataServiceHelper;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.utils.ObjectUtils;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;

public abstract class TsateBaseDeclarePlugin
extends AbstractListPlugin {
    protected static final String ORG_KEY = "org.id";
    protected static final String ORG_NAME = "org.name";
    protected static final String SEPARATOR = "\r" + System.lineSeparator();
    private static Log LOGGER = LogFactory.getLog(TsateBaseDeclarePlugin.class);

    protected boolean validSelected(List<Long> declareIds) {
        if (declareIds == null) {
            declareIds = new ArrayList<Long>(8);
        }
        if (declareIds.size() > 0) {
            return true;
        }
        BillList billlist = (BillList)this.getControl(this.getListControlKey());
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list == null || list.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55", (String)"TsateBaseDeclarePlugin_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            return false;
        }
        declareIds.addAll(ObjectUtils.toLongList(Arrays.asList(list.getPrimaryKeyValues())));
        List<Long> declareSelectIds = this.getDeclareSelectId(declareIds);
        declareIds.clear();
        if (EmptyCheckUtils.isNotEmpty(declareSelectIds)) {
            declareIds.addAll(declareSelectIds);
        }
        return true;
    }

    protected List<Long> getDeclareSelectId(List<Long> declareIds) {
        return new ArrayList<Long>(declareIds);
    }

    protected String getListControlKey() {
        return "billlistap";
    }

    protected List<Long> getDeclareIds() {
        return new ArrayList<Long>(8);
    }

    protected void showTaskInfo(int totalSize, int successSize, int failSize, String failTip, List<String> failMsgs) {
        StringBuilder title = new StringBuilder();
        title.append(ResManager.loadKDString((String)"\u60a8\u5df2\u9009\u4e2d%1$s\u6761\uff0c%2$s\u6761\u64cd\u4f5c\u6210\u529f\uff0c%3$s\u6761\u64cd\u4f5c\u5931\u8d25", (String)"TsateBaseDeclarePlugin_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
        if (failSize > 0 && StringUtil.isNotEmpty((CharSequence)failTip)) {
            title.append("\uff0c").append(failTip).append("\u3002");
        } else {
            title.append("\u3002");
        }
        String t = String.format(title.toString(), totalSize, successSize, failSize);
        this.showTip(t, failMsgs, false);
    }

    protected List<DynamicObject> getSelectedDataCompatible(List<Long> declareIds) {
        TaxResult<List<DynamicObject>> listTaxResult = MultiDeclareDataServiceHelper.queryDeclareMainByIds(declareIds);
        if (listTaxResult.isSuccess()) {
            return listTaxResult.getData();
        }
        return new ArrayList<DynamicObject>();
    }

    protected Boolean needContinue(List<DynamicObject> declareData) {
        if (CollectionUtils.isEmpty(declareData)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"TsateBaseDeclarePlugin_5", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected void showTip(String title, List<String> details) {
        this.showTip(title, details, true);
    }

    protected void showTip(String title, List<String> details, Boolean tipIsErro) {
        if (details == null) {
            details = Collections.EMPTY_LIST;
        }
        if (details.size() == 1) {
            if (tipIsErro != null && tipIsErro.booleanValue()) {
                this.getView().showErrorNotification((String)details.get(0));
            } else {
                this.getView().showTipNotification((String)details.get(0));
            }
        } else {
            FormShowParameter parameters = new FormShowParameter();
            parameters.getOpenStyle().setShowType(ShowType.Modal);
            parameters.setFormId("bos_operationresult");
            parameters.setShowTitle(true);
            parameters.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u63d0\u793a", (String)"TsateBaseDeclarePlugin_2", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            parameters.setCustomParam("operateName", (Object)"");
            parameters.setCustomParam("title", (Object)title);
            parameters.setCustomParam("errorMsg", (Object)details);
            this.getView().showForm(parameters);
        }
    }

    protected List<Long> getOrgFromFilter() {
        ArrayList<Long> orgIds = new ArrayList<Long>(8);
        ControlFilters controlFilters = this.getControlFilters();
        if (controlFilters == null) {
            return orgIds;
        }
        ControlFilter orgFilter = (ControlFilter)controlFilters.getFilters().get(ORG_KEY);
        if (orgFilter == null) {
            orgFilter = (ControlFilter)controlFilters.getFilters().get(ORG_NAME);
        }
        if (orgFilter == null) {
            return orgIds;
        }
        List valus = orgFilter.getValue();
        if (valus.size() == 1 && valus.get(0).equals("")) {
            Long userId = RequestContext.get().getCurrUserId();
            orgIds.addAll((Collection<Long>)PermDataServiceHelper.getUserHasPermOrgs(userId, "40").getData());
        } else {
            for (Object id : orgFilter.getValue()) {
                if (id instanceof String) {
                    orgIds.add(Long.parseLong(id.toString()));
                    continue;
                }
                if (!(id instanceof Long)) continue;
                orgIds.add((Long)id);
            }
        }
        return orgIds;
    }

    protected StringBuilder getDeclareDescr(DynamicObject declare) {
        String type = TsateBaseDeclarePlugin.getDeclareMethodByModel3(declare);
        String typeName = TaxcTemplateTypeConstant.getNsrtypemap().get(type);
        String skssqq = DateUtils.format(declare.getDate("skssqq"), DateUtils.YYYYMMDD_CHINESE);
        String skssqz = DateUtils.format(declare.getDate("skssqz"), DateUtils.YYYYMMDD_CHINESE);
        String orgName = declare.getString("nsrmc");
        String t = ResManager.loadKDString((String)"%1$s %2$s \u81f3 %3$s %4$s", (String)"TsateBaseDeclarePlugin_3", (String)"taxc-bdtaxr-base", (Object[])new Object[0]);
        StringBuilder descr = new StringBuilder(String.format(t, orgName, skssqq, skssqz, typeName));
        return descr;
    }

    protected boolean checkTsateLicense() {
        TaxResult<LicenseCheckResult> result = TaxcLicenseCheckDataServiceHelper.checkTxftPerformGroup("tsdcs");
        if (result.isSuccess()) {
            if (result.getData().getHasLicense().booleanValue()) {
                return true;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f3a\u5c11\u7a0e\u4f01\u76f4\u8fde\u7279\u6027\u8bb8\u53ef", (String)"TsateBaseDeclarePlugin_4", (String)"taxc-bdtaxr-base", (Object[])new Object[0]));
            return false;
        }
        return false;
    }

    public static String getDeclareMethodByModel3(DynamicObject mainObj) {
        return mainObj.getString("templatetype.id");
    }
}

