/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.changemodel;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.taxc.bdtaxr.business.changemodel.ChangeModelBusiness;
import kd.taxc.bdtaxr.business.changemodel.ChangeResumeBusiness;
import kd.taxc.bdtaxr.business.changemodel.CommonDataBusiness;
import kd.taxc.bdtaxr.business.changemodel.SrcBillBusiness;
import kd.taxc.bdtaxr.business.changemodel.XBillBusiness;
import kd.taxc.bdtaxr.business.changemodel.helper.FieldKeysHelper;
import kd.taxc.bdtaxr.common.enums.changemodel.BizChangeStatusEnum;
import kd.taxc.bdtaxr.common.utils.ChangeModelUtil;

public class XBillDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        if (this.billEntityType != null) {
            e.getFieldKeys().addAll(FieldKeysHelper.getFieldKeys4XbillDelete(this.billEntityType.getName()));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if (e.getDataEntities() != null && e.getDataEntities().length != 0) {
            DynamicObject[] bills = e.getDataEntities();
            if (ChangeModelUtil.isNull(bills)) {
                return;
            }
            String xBillEntity = bills[0].getDataEntityType().getName();
            DynamicObject changeModel = ChangeModelBusiness.getChangeModel4XBill(xBillEntity);
            if (changeModel == null) {
                return;
            }
            List<Long> xBillIds = Stream.of(bills).map(v -> v.getLong("id")).collect(Collectors.toList());
            DynamicObject[] srcBills = SrcBillBusiness.updateSrcBill4BizDelete(bills);
            List<Long> srcBillIds = Stream.of(srcBills).filter(v -> BizChangeStatusEnum.UNCHANGE.getValue().equalsIgnoreCase(v.getString("changestatus"))).map(v -> v.getLong("id")).collect(Collectors.toList());
            DynamicObject[] zeroXbills = XBillBusiness.getZeroXBillBySrcBillIds(srcBillIds, xBillEntity);
            List<Long> zeroXbillIds = Stream.of(zeroXbills).map(v -> v.getLong("id")).collect(Collectors.toList());
            if (zeroXbillIds.size() > 0) {
                CommonDataBusiness.delete(zeroXbillIds, xBillEntity);
                xBillIds.addAll(zeroXbillIds);
            }
            if (xBillIds.size() > 0) {
                ChangeResumeBusiness.deleteChangeResume(xBillIds);
            }
        }
    }
}

