/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.changemodel;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.metadata.entity.validation.ConditionValidation;
import kd.bos.service.operation.validate.ConditionValidator;
import kd.taxc.bdtaxr.business.changemodel.ChangeModelBusiness;
import kd.taxc.bdtaxr.business.changemodel.ChangeResumeBusiness;
import kd.taxc.bdtaxr.business.changemodel.SrcBillBusiness;
import kd.taxc.bdtaxr.business.changemodel.helper.FieldKeysHelper;
import kd.taxc.bdtaxr.common.utils.ChangeModelUtil;

public class XBillSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        if (this.billEntityType != null) {
            e.getFieldKeys().addAll(FieldKeysHelper.getFieldKeys4XbillSubmit(this.billEntityType.getName()));
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        if (this.billEntityType != null) {
            String opkey = (String)this.operateMeta.get("key");
            List<ConditionValidation> vallist = ChangeModelBusiness.getValidConditionList(this.billEntityType.getName(), opkey);
            if (vallist != null && vallist.size() > 0) {
                for (int i = 0; i < vallist.size(); ++i) {
                    ConditionValidator xBillCV = new ConditionValidator();
                    xBillCV.setValidation(vallist.get(i).createValidate());
                    e.addValidator((AbstractValidator)xBillCV);
                }
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        if (e.getDataEntities() != null && e.getDataEntities().length != 0) {
            DynamicObject[] bills = e.getDataEntities();
            DynamicObject changeModel = ChangeModelBusiness.getChangeModel4XBill(bills[0].getDataEntityType().getName());
            if (changeModel == null) {
                return;
            }
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject bill = bills[i];
                ChangeModelBusiness.excutePluginMethod(changeModel, "beforeXBillSubmit", bill);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if (e.getDataEntities() != null && e.getDataEntities().length != 0) {
            DynamicObject[] bills = e.getDataEntities();
            if (ChangeModelUtil.isNull(bills)) {
                return;
            }
            DynamicObject changeModel = ChangeModelBusiness.getChangeModel4XBill(bills[0].getDataEntityType().getName());
            if (changeModel == null) {
                return;
            }
            SrcBillBusiness.updateSrcBill4BizChange(bills);
            ChangeResumeBusiness.saveChangeResume(bills);
            for (DynamicObject bill : bills) {
                ChangeModelBusiness.excutePluginMethod(changeModel, "afterXBillSubmit", bill);
            }
        }
    }
}

