/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.prescripted;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.prescripted.PreScriptedBusiness;
import kd.taxc.bdtaxr.common.enums.prescripted.DeployStatusEnum;

public class PreScriptedDeployOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PreScriptedDeployOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("deploystatus");
        e.getFieldKeys().add("deploycount");
        e.getFieldKeys().add("ispreset");
        e.getFieldKeys().add("scriptedtype");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryentity.bizobj");
        e.getFieldKeys().add("bizapp");
        e.getFieldKeys().add("bizapp.bizcloud");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                DynamicObject obj = null;
                for (ExtendedDataEntity entity : this.getDataEntities()) {
                    obj = entity.getDataEntity();
                    if (DeployStatusEnum.DEPLOYED.getValue().equals(obj.getString("deploystatus"))) {
                        this.addFatalErrorMessage(entity, String.format(ResManager.loadKDString((String)"%s\uff1a\u811a\u672c\u5df2\u90e8\u7f72\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u90e8\u7f72\u3002", (String)"PreScriptedDeployOp_0", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), obj.getString("name")));
                        continue;
                    }
                    if (!DeployStatusEnum.DEPLOYING.getValue().equals(obj.getString("deploystatus"))) continue;
                    this.addFatalErrorMessage(entity, String.format(ResManager.loadKDString((String)"%s\uff1a\u811a\u672c\u6b63\u5728\u90e8\u7f72\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"PreScriptedDeployOp_1", (String)"taxc-bdtaxr-base", (Object[])new Object[0]), obj.getString("name")));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        PreScriptedBusiness.deployPreScriptedWithJob(e.getDataEntities());
    }

    private ValidationErrorInfo buildErrMessage(DynamicObject obj, String msg) {
        Object pkId = obj.getPkValue();
        int dataIndex = 0;
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "errorcode001", "", msg, errorLevel);
        return info;
    }
}

