/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.constant;

import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;

public enum StandBookRuleEnum {
    TAKING("2021-SWTZ-ZFJGSYS-0001", "entryentity2", "2", "advconap2", new MultiLangEnumBridge("\u8d44\u4ea7\u603b\u989d", "StandBookRuleEnum_0", "taxc-bdtaxr-common")),
    TOTALASSETS("2021-SWTZ-ZFJGSYS-0002", "entryentity", "", "advconap", new MultiLangEnumBridge("\u8425\u4e1a\u6536\u5165", "StandBookRuleEnum_1", "taxc-bdtaxr-common")),
    EMPLOYEE("2021-SWTZ-ZFJGSYS-0003", "entryentity1", "1", "advconap1", new MultiLangEnumBridge("\u804c\u5de5\u85aa\u916c", "StandBookRuleEnum_2", "taxc-bdtaxr-common"));

    private String standBookCode;
    private String advconap;
    private MultiLangEnumBridge advconapName;
    private String entryEntity;
    private String metaDataSuffix;

    private StandBookRuleEnum(String standBookCode, String entryEntity, String metaDataSuffix, String advconap, MultiLangEnumBridge advconapName) {
        this.standBookCode = standBookCode;
        this.advconap = advconap;
        this.advconapName = advconapName;
        this.entryEntity = entryEntity;
        this.metaDataSuffix = metaDataSuffix;
    }

    public String getStandBookCode() {
        return this.standBookCode;
    }

    public String getAdvconap() {
        return this.advconap;
    }

    public String getEntryEntity() {
        return this.entryEntity;
    }

    public String getMetaDataSuffix() {
        return this.metaDataSuffix;
    }

    public String getAdvconapName() {
        return this.advconapName.getDescription();
    }

    public static String getAdvconapNameByCode(String code) {
        for (StandBookRuleEnum value : StandBookRuleEnum.values()) {
            if (!value.standBookCode.equals(code)) continue;
            return value.advconapName.getDescription();
        }
        return "";
    }

    public static String getAdvconapByCode(String code) {
        for (StandBookRuleEnum value : StandBookRuleEnum.values()) {
            if (!value.standBookCode.equals(code)) continue;
            return value.advconap;
        }
        return "";
    }

    public static String getEntryEntityByCode(String code) {
        for (StandBookRuleEnum value : StandBookRuleEnum.values()) {
            if (!value.standBookCode.equals(code)) continue;
            return value.entryEntity;
        }
        return "";
    }

    public static String getSuffixByCode(String code) {
        for (StandBookRuleEnum value : StandBookRuleEnum.values()) {
            if (!value.standBookCode.equals(code)) continue;
            return value.metaDataSuffix;
        }
        return "";
    }
}

