/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.constant;

import java.util.Arrays;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;

public enum TaxElementCategoryEnum {
    BASTAX_TAXPRODUCT("bastax_taxproduct", new MultiLangEnumBridge("\u7a0e\u52a1\u4ea7\u54c1", "TaxElementCategoryEnum_0", "taxc-bdtaxr-common"), ""),
    BASTAX_ADDRESSTYPE("bastax_addresstype", new MultiLangEnumBridge("\u5730\u5740\u6761\u4ef6", "TaxElementCategoryEnum_1", "taxc-bdtaxr-common"), "bastax_addressterms"),
    BASTAX_PARTY_TYPE("bastax_party_type", new MultiLangEnumBridge("\u4ea4\u6613\u65b9\u8d44\u8d28", "TaxElementCategoryEnum_2", "taxc-bdtaxr-common"), "bastax_party"),
    BASTAX_PROCESS_TYPE("bastax_process_type", new MultiLangEnumBridge("\u81ea\u5b9a\u4e49\u7a0e\u8981\u7d20", "TaxElementCategoryEnum_3", "taxc-bdtaxr-common"), "bastax_process"),
    BASTAX_SPECIFIC_PRODUCT("bastax_specific_product", new MultiLangEnumBridge("\u7279\u5b9a\u4ea7\u54c1", "TaxElementCategoryEnum_4", "taxc-bdtaxr-common"), "");

    private String entryClass;
    private String entryType;
    private MultiLangEnumBridge bridge = null;

    private TaxElementCategoryEnum(String entryClass, MultiLangEnumBridge bridge, String entryType) {
        this.entryClass = entryClass;
        this.bridge = bridge;
        this.entryType = entryType;
    }

    public String getEntryClass() {
        return this.entryClass;
    }

    public static String getEntryClassName(String key) {
        if (key == null) {
            return null;
        }
        for (TaxElementCategoryEnum se : TaxElementCategoryEnum.values()) {
            if (!key.equals(se.getEntryClass())) continue;
            return se.getEntryClassName();
        }
        return null;
    }

    public String getEntryClassName() {
        return this.bridge.loadKDString();
    }

    public String getEntryType() {
        return this.entryType;
    }

    public static TaxElementCategoryEnum getEnumByEntryClass(String entryClass) {
        TaxElementCategoryEnum eleEnum = Arrays.stream(TaxElementCategoryEnum.values()).filter(v -> v.getEntryClass().equalsIgnoreCase(entryClass)).findFirst().get();
        return eleEnum;
    }
}

