/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.db;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.db.ComparableMapUtils;
import kd.taxc.bdtaxr.common.db.DBSaveUtils;
import kd.taxc.bdtaxr.common.db.MapToTableUtils;
import kd.taxc.bdtaxr.common.db.NewObjectUtils;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DataSaveService {
    public static Map<String, DynamicObjectCollection> mapToTable(long templateId, Map<String, String> newMaps) {
        return DataSaveService.mapToTable(TemplateUtils.getMainTableByTemplateId(templateId), newMaps, new HashMap<String, String>(), Collections.emptyMap());
    }

    public static Map<String, DynamicObjectCollection> mapToTableOld(long templateId, Map<String, String> newMaps) {
        return DataSaveService.mapToTable(TemplateUtilsOld.getMainTableByTemplateId(templateId), newMaps, new HashMap<String, String>(), Collections.emptyMap());
    }

    public static Map<String, DynamicObjectCollection> mapToTableFormat(long templateId, Map<String, String> newMaps, Map<String, String> metadata) {
        return DataSaveService.mapToTable(TemplateUtils.getMainTableByTemplateId(templateId), newMaps, new HashMap<String, String>(), metadata);
    }

    public static Map<String, DynamicObjectCollection> mapToTable(long templateId, Map<String, String> newMaps, Map<String, String> oldMaps) {
        return DataSaveService.mapToTable(TemplateUtils.getMainTableByTemplateId(templateId), newMaps, oldMaps, Collections.emptyMap());
    }

    public static Map<String, DynamicObjectCollection> mapToTable(String mainKey, Map<String, String> newMaps) {
        return DataSaveService.mapToTable(mainKey, newMaps, new HashMap<String, String>());
    }

    public static Map<String, DynamicObjectCollection> mapToTable(String mainKey, Map<String, String> newMaps, Map<String, String> oldMaps) {
        String mainId = newMaps.get(NewObjectUtils.getIdByKey(mainKey));
        String type = newMaps.get(NewObjectUtils.getType(mainKey));
        Map<String, DynamicObjectCollection> newDbMap = MapToTableUtils.mapToTable(mainKey, mainId, newMaps);
        Map<String, String> map = ComparableMapUtils.complateMap(newMaps, oldMaps);
        Map<String, Map<String, DynamicObject>> data = ComparableMapUtils.queryDB(ComparableMapUtils.getId(ComparableMapUtils.getRow(map), newMaps));
        Map<String, DynamicObjectCollection> diffDBMap = ComparableMapUtils.setValue(mainKey, type, mainId, data, map);
        if (diffDBMap.size() > 0) {
            DBSaveUtils.saveTable(diffDBMap);
        }
        HashMap<String, DynamicObject> temp = new HashMap<String, DynamicObject>();
        for (Map.Entry<String, DynamicObjectCollection> entry : diffDBMap.entrySet()) {
            for (DynamicObject d : entry.getValue()) {
                temp.put(entry.getKey() + "#" + d.getString("ewblxh"), d);
            }
        }
        HashMap<String, DynamicObjectCollection> returnMap = new HashMap<String, DynamicObjectCollection>(newDbMap.size());
        for (Map.Entry<String, DynamicObjectCollection> entry : newDbMap.entrySet()) {
            DynamicObjectCollection valeus = new DynamicObjectCollection();
            for (DynamicObject d : entry.getValue()) {
                DynamicObject dd = (DynamicObject)temp.get(entry.getKey() + "#" + d.getString("ewblxh"));
                if (null != dd) {
                    valeus.add((Object)dd);
                    continue;
                }
                valeus.add((Object)d);
            }
            returnMap.put(entry.getKey(), valeus);
        }
        return returnMap;
    }

    public static Map<String, DynamicObjectCollection> mapToTable(String mainKey, Map<String, String> newMaps, Map<String, String> oldMaps, Map<String, String> tableMap) {
        String mainId = newMaps.get(NewObjectUtils.getIdByKey(mainKey));
        Map<String, DynamicObjectCollection> newDbMap = MapToTableUtils.mapToTable(mainKey, mainId, newMaps, tableMap);
        Map<String, String> map = ComparableMapUtils.complateMap(newMaps, oldMaps);
        Map<String, Map<String, DynamicObject>> queryDB = ComparableMapUtils.queryDB(ComparableMapUtils.getId(ComparableMapUtils.getRow(map), newMaps));
        Map<String, DynamicObjectCollection> diffDBMap = ComparableMapUtils.setValue(mainKey, mainId, queryDB, map, tableMap);
        Map<String, String> deleteMap1 = ComparableMapUtils.deletecomplateMap(newMaps, oldMaps);
        Map<String, DynamicObjectCollection> deleteDBMapList = ComparableMapUtils.setValue(mainKey, mainId, queryDB, deleteMap1, tableMap);
        for (Map.Entry<String, DynamicObjectCollection> d : deleteDBMapList.entrySet()) {
            if (d.getKey().equals("tcvat_nsrxx") || d.getKey().equals("tcetr_declare_main") || ((String)d.getKey()).equals("bdtaxr_taxbureau_sbb")) continue;
            for (DynamicObject dynamicObject : (DynamicObjectCollection)d.getValue()) {
                QFilter sbbidFilter = new QFilter("sbbid", "=", dynamicObject.get("sbbid"));
                QFilter ewblxhFilter = new QFilter("ewblxh", "=", dynamicObject.get("ewblxh"));
                DeleteServiceHelper.delete((String)((String)d.getKey()), (QFilter[])new QFilter[]{sbbidFilter, ewblxhFilter});
            }
        }
        if (diffDBMap.size() > 0) {
            DBSaveUtils.saveTable(diffDBMap);
        }
        HashMap<String, DynamicObject> temp = new HashMap<String, DynamicObject>();
        for (Map.Entry entry : diffDBMap.entrySet()) {
            for (DynamicObject d : (DynamicObjectCollection)entry.getValue()) {
                temp.put((String)entry.getKey() + "#" + d.getString("ewblxh"), d);
            }
        }
        HashMap<String, DynamicObjectCollection> returnMap = new HashMap<String, DynamicObjectCollection>(newDbMap.size());
        for (Map.Entry<String, DynamicObjectCollection> entry : newDbMap.entrySet()) {
            DynamicObjectCollection valeus = new DynamicObjectCollection();
            for (DynamicObject d : entry.getValue()) {
                DynamicObject dd = (DynamicObject)temp.get(entry.getKey() + "#" + d.getString("ewblxh"));
                if (null != dd) {
                    valeus.add((Object)dd);
                    continue;
                }
                valeus.add((Object)d);
            }
            returnMap.put(entry.getKey(), valeus);
        }
        return returnMap;
    }

    public static void updatePrepayBill(DeclareRequestModel declareRequest) {
        String templateType;
        List<String> type = Arrays.asList("zzsybnsr", "zzsybnsr_ybhz", "zzsybnsr_hz_zjg");
        if (type.contains(templateType = declareRequest.getTemplateType())) {
            Long sbbid = declareRequest.getId();
            Long org = declareRequest.getOrgId();
            String startdate = declareRequest.getSkssqq();
            String preStartdate = DateUtils.format(DateUtils.addMonth(DateUtils.stringToDate(startdate), -1));
            String enddate = declareRequest.getSkssqz();
            QFilter q1 = null;
            if ("zzsybnsr".equals(templateType)) {
                q1 = new QFilter("org", "=", (Object)org);
            } else if ("zzsybnsr_ybhz".equals(templateType) || "zzsybnsr_hz_zjg".equals(templateType)) {
                DynamicObjectCollection collection = OrgUtils.queryOrgGroupDetailForCollectedOrg("zzs", String.valueOf(org), enddate);
                List orgid = collection.stream().map(e -> e.get("orgid")).collect(Collectors.toList());
                q1 = new QFilter("org", "in", orgid);
            }
            QFilter q2 = new QFilter("skssqq", ">=", (Object)DateUtils.getDayFirst(DateUtils.stringToDate(preStartdate)));
            QFilter q3 = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast(DateUtils.stringToDate(enddate)));
            QFilter q6 = new QFilter("deductionperiod", "=", (Object)"0");
            QFilter q7 = new QFilter("sssbbid", "=", (Object)"0");
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"tcvat_prepay_declare_bill", (String)"sbbid,deductionperiod,sssbbid", (QFilter[])new QFilter[]{q1, q2, q3, q6, q7});
            List sbbidList = Arrays.stream(load).map(e -> Long.valueOf(e.getString("sbbid"))).collect(Collectors.toList());
            QFilter idFilter = new QFilter("id", "in", sbbidList);
            QFilter declarestatusFilter = new QFilter("declarestatus", "=", (Object)"declared");
            QFilter paystatusFilter = new QFilter("paystatus", "=", (Object)"paid");
            DynamicObjectCollection nxxCollection = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{idFilter, declarestatusFilter, paystatusFilter});
            List nxxIdList = nxxCollection.stream().map(e -> e.getString("id")).collect(Collectors.toList());
            List<DynamicObject> updateList = Arrays.stream(load).filter(e -> nxxIdList.contains(e.getString("sbbid"))).collect(Collectors.toList());
            updateList.stream().forEach(e -> e.set("sssbbid", (Object)String.valueOf(sbbid)));
            SaveServiceHelper.update((DynamicObject[])updateList.toArray(new DynamicObject[0]));
        }
    }
}

