/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.db;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.db.NewObjectUtils;
import kd.taxc.bdtaxr.common.db.SetValueUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class MapToTableUtils {
    private static Log logger = LogFactory.getLog(MapToTableUtils.class);
    private static final Map<String, String> COLUMN_TYPE_MAP = new HashMap(){
        {
            this.put("Integer", ResManager.loadKDString((String)"\u6574\u6570", (String)"MapToTableUtils_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.put("Decimal", ResManager.loadKDString((String)"\u6570\u503c", (String)"MapToTableUtils_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.put("Long", ResManager.loadKDString((String)"\u6574\u6570", (String)"MapToTableUtils_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.put("Double", ResManager.loadKDString((String)"\u6570\u503c", (String)"MapToTableUtils_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    };

    public static Map<String, DynamicObjectCollection> mapToTable(String mainKey, String mainId, Map<String, String> maps) {
        HashMap<String, DynamicObjectCollection> table = new HashMap<String, DynamicObjectCollection>();
        HashMap<String, DynamicObject> row = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObjectCollection> saveData = new HashMap<String, DynamicObjectCollection>();
        String type = maps.get(NewObjectUtils.getType(mainKey));
        Map<String, EntityField> entityFieldMap = TemplateUtils.getAllEntityByType(type, "#");
        for (Map.Entry<String, String> map : maps.entrySet()) {
            String rowKey;
            DynamicObject dyo;
            String[] key;
            String k = map.getKey();
            if (StringUtils.isEmpty((String)k) || (key = k.split("\\#")).length < 3) continue;
            DynamicObjectCollection t = (DynamicObjectCollection)table.get(key[0]);
            if (null == t) {
                t = new DynamicObjectCollection();
                table.put(key[0], t);
                saveData.put(key[0], t);
            }
            if (null == (dyo = (DynamicObject)row.get(rowKey = key[0] + "#" + key[1]))) {
                dyo = NewObjectUtils.newObject(mainKey, mainId, key, maps);
                row.put(rowKey, dyo);
                t.add((Object)dyo);
            }
            if (key[2].equals("id")) continue;
            EntityField entityField = entityFieldMap.getOrDefault(k, new EntityField());
            MapToTableUtils.setValCatchException(map, dyo, entityField, key[2]);
        }
        return saveData;
    }

    public static Map<String, DynamicObjectCollection> mapToTable(String mainKey, String mainId, Map<String, String> maps, Map<String, String> tableMap) {
        HashMap<String, DynamicObjectCollection> table = new HashMap<String, DynamicObjectCollection>();
        HashMap<String, DynamicObject> row = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObjectCollection> saveData = new HashMap<String, DynamicObjectCollection>();
        Map<String, EntityField> entityFieldMap = TemplateUtils.getAllEntity(tableMap);
        for (Map.Entry<String, String> entry : maps.entrySet()) {
            EntityField entityField1;
            String rowKey;
            DynamicObject dyo;
            String[] key;
            String k = entry.getKey();
            if (StringUtils.isEmpty((String)k) || (key = k.split("\\#")).length < 3) continue;
            DynamicObjectCollection t = (DynamicObjectCollection)table.get(key[0]);
            if (null == t) {
                t = new DynamicObjectCollection();
                table.put(key[0], t);
                saveData.put(key[0], t);
            }
            if (null == (dyo = (DynamicObject)row.get(rowKey = key[0] + "#" + key[1]))) {
                dyo = NewObjectUtils.newObject(mainKey, mainId, key, maps);
                row.put(rowKey, dyo);
                t.add((Object)dyo);
            }
            if (key[2].equals("id")) continue;
            k = key[0] + "#" + "1" + "#" + key[2];
            EntityField entityField = entityFieldMap.getOrDefault(k, new EntityField());
            if (StringUtil.isEmpty((CharSequence)entityField.getEntityName()) && (entityField1 = TemplateUtils.getEntityFieldMap(key[0], "#", "#").get(k)) != null) {
                entityField = entityField1;
            }
            MapToTableUtils.setValCatchException(entry, dyo, entityField, key[2]);
        }
        return saveData;
    }

    private static void setValCatchException(Map.Entry<String, String> map, DynamicObject dyo, EntityField entityField, String key2) {
        try {
            SetValueUtils.setValue(key2, map.getValue(), dyo, entityField.getFormat());
        }
        catch (NumberFormatException e) {
            logger.error("entityField:{},value:{}", (Object)JsonUtil.toJson(entityField), (Object)map.getValue());
            logger.error("setValue error:" + JsonUtil.toJson(entityField), (Throwable)e);
            if (entityField != null && StringUtil.isNotEmpty((CharSequence)entityField.getEntityName())) {
                String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u5217\u5fc5\u987b\u4e3a\u201c%3$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MapToTableUtils_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), entityField.getEntityName(), entityField.getFieldName(), COLUMN_TYPE_MAP.getOrDefault(entityField.getFieldType(), entityField.getFieldType()));
                throw new KDBizException(msg);
            }
            if (map == null || entityField == null) {
                logger.error("params illegal, map: {}, dyo: {}, entityField: {}, key2: {}", new Object[]{map, dyo, entityField, key2});
            }
            logger.error("setValue error: {}", (Object)e.getMessage());
            throw e;
        }
    }

    public static Map<String, String> tableToMap(Map<String, DynamicObjectCollection> data, String type) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, EntityField> entityFieldMap = TemplateUtils.getAllEntityByType(type, "#");
        for (Map.Entry<String, DynamicObjectCollection> doc : data.entrySet()) {
            String key = doc.getKey();
            DynamicObjectCollection list = doc.getValue();
            for (DynamicObject d : list) {
                DataEntityPropertyCollection dd = d.getDataEntityType().getProperties();
                for (IDataEntityProperty property : dd) {
                    if (property.getName() == null) continue;
                    Class cls = property.getPropertyType();
                    Object object = d.get(property.getName());
                    String field = key + "#" + d.getString("ewblxh") + "#" + property.getName();
                    String valString = "";
                    if (object instanceof List) continue;
                    if (object instanceof BigDecimal) {
                        valString = DataFormatUtils.decimalFormat((BigDecimal)object, entityFieldMap.get(field));
                    } else if (object instanceof Date) {
                        EntityField entityField = entityFieldMap.get(field);
                        valString = entityField != null && entityField.getFormat() != null ? entityField.getFormat().format(object) : DateUtils.format((Date)object);
                    } else if (null != object) {
                        valString = object.toString();
                    } else if (cls.getSimpleName().equalsIgnoreCase("BigDecimal") || cls.getSimpleName().equalsIgnoreCase("Double") || cls.getSimpleName().equalsIgnoreCase("Long") || cls.getSimpleName().equalsIgnoreCase("DynamicObject")) {
                        valString = "0";
                    }
                    map.put(field, valString);
                }
            }
        }
        return map;
    }

    public static Map<String, String> tableToMap(Map<String, DynamicObjectCollection> data, Map<String, String> metadataNumberMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, EntityField> entityFieldMap = TemplateUtils.getAllEntity(metadataNumberMap);
        for (Map.Entry<String, DynamicObjectCollection> doc : data.entrySet()) {
            String key = doc.getKey();
            DynamicObjectCollection list = doc.getValue();
            for (DynamicObject d : list) {
                DataEntityPropertyCollection dd = d.getDataEntityType().getProperties();
                for (IDataEntityProperty property : dd) {
                    if (property.getName() == null) continue;
                    Class cls = property.getPropertyType();
                    Object object = d.get(property.getName());
                    String field = key + "#" + d.getString("ewblxh") + "#" + property.getName();
                    String valString = "";
                    if (object instanceof BigDecimal) {
                        valString = DataFormatUtils.decimalFormat((BigDecimal)object, entityFieldMap.get(field));
                    } else if (object instanceof Date) {
                        EntityField entityField = entityFieldMap.get(field);
                        valString = entityField != null && entityField.getFormat() != null ? entityField.getFormat().format(object) : DateUtils.format((Date)object);
                    } else if (null != object) {
                        valString = object.toString();
                    } else if (cls.getSimpleName().equalsIgnoreCase("BigDecimal") || cls.getSimpleName().equalsIgnoreCase("Double") || cls.getSimpleName().equalsIgnoreCase("Long") || cls.getSimpleName().equalsIgnoreCase("DynamicObject")) {
                        valString = "0";
                    }
                    map.put(field, valString);
                }
            }
        }
        return map;
    }

    public static Map<String, String> tableToMapNew(Map<String, DynamicObjectCollection> data, Map<String, String> metadataNumberMap) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, EntityField> entityFieldMap = TemplateUtils.getAllEntity(metadataNumberMap);
        for (Map.Entry<String, DynamicObjectCollection> doc : data.entrySet()) {
            String key = doc.getKey();
            DynamicObjectCollection list = doc.getValue();
            for (DynamicObject d : list) {
                DataEntityPropertyCollection dd = d.getDataEntityType().getProperties();
                for (IDataEntityProperty property : dd) {
                    if (property.getName() == null) continue;
                    Class cls = property.getPropertyType();
                    Object object = d.get(property.getName());
                    String field = key + "#" + d.getString("ewblxh") + "#" + property.getName();
                    String valString = "";
                    if (object instanceof Date) {
                        EntityField entityField = entityFieldMap.get(field);
                        valString = entityField != null && entityField.getFormat() != null ? entityField.getFormat().format(object) : DateUtils.format((Date)object);
                    } else if (null != object) {
                        valString = object.toString();
                    } else if (cls.getSimpleName().equalsIgnoreCase("BigDecimal") || cls.getSimpleName().equalsIgnoreCase("Double") || cls.getSimpleName().equalsIgnoreCase("Long") || cls.getSimpleName().equalsIgnoreCase("DynamicObject")) {
                        valString = "0";
                    }
                    map.put(field, valString);
                }
            }
        }
        return map;
    }
}

