/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.db;

import java.math.BigDecimal;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.constant.DateUtilsEnum;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;

public class SetValueUtils {
    private static Log logger = LogFactory.getLog(SetValueUtils.class);
    private static final String regex = "\\d{4}-\\d{1,2}-\\d{1,2}";
    private static final String regex_with_time = "\\d{4}-\\d{1,2}-\\d{1,2} \\d{1,2}:\\d{1,2}:\\d{1,2}";

    public static void setValue(String key, String value, DynamicObject dyo) {
        SetValueUtils.setValue(key, value, dyo, null);
    }

    public static void setValue(String key, String value, DynamicObject dyo, Format format) {
        block38: {
            Object obj = dyo.get(key);
            if (null != obj) {
                if (obj instanceof Date) {
                    SetValueUtils.setDate(key, value, dyo, format);
                } else if (obj instanceof Integer) {
                    if (value.matches("^-?\\d+(\\.\\d+)?$")) {
                        String[] split = value.split("\\.");
                        if (split.length == 2 && Integer.parseInt(split[1]) == 0) {
                            dyo.set(key, (Object)Integer.parseInt(split[0]));
                        } else {
                            dyo.set(key, (Object)Integer.parseInt(value));
                        }
                    } else {
                        dyo.set(key, (Object)0);
                    }
                } else if (obj instanceof BigDecimal) {
                    dyo.set(key, (Object)BigDecimalUtil.toBigDecimal(value));
                } else if (obj instanceof Double) {
                    dyo.set(key, (Object)Double.parseDouble(value));
                } else if (obj instanceof Long) {
                    dyo.set(key, (Object)Long.parseLong(value));
                } else if (obj instanceof Float) {
                    dyo.set(key, (Object)Float.valueOf(Float.parseFloat(value)));
                } else {
                    dyo.set(key, (Object)value);
                }
            } else {
                IDataEntityProperty data = (IDataEntityProperty)dyo.getDataEntityType().getProperties().get((Object)key);
                Class cls = data.getPropertyType();
                if (cls.isAssignableFrom(String.class)) {
                    dyo.set(key, (Object)value);
                } else if (cls.isAssignableFrom(BigDecimal.class) || cls.isAssignableFrom(Double.class) || cls.isAssignableFrom(Long.class)) {
                    dyo.set(key, (Object)value);
                } else if (cls.isAssignableFrom(Date.class)) {
                    if (StringUtils.isNotEmpty((CharSequence)value)) {
                        if (format != null) {
                            try {
                                dyo.set(key, format.parseObject(value));
                            }
                            catch (ParseException e) {
                                if (SetValueUtils.isMatch(value)) {
                                    dyo.set(key, (Object)DateUtils.stringToDate(value));
                                    break block38;
                                }
                                try {
                                    dyo.set(key, (Object)DateUtils.stringToDate(value, DateUtilsEnum.YYYYMMDD_CHINESE.getName()));
                                }
                                catch (Exception ee) {
                                    dyo.set(key, null);
                                }
                            }
                        } else if ((value = value.replace(ResManager.loadKDString((String)"\u5e74", (String)"SetValueUtils_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), "-").replace(ResManager.loadKDString((String)"\u6708", (String)"SetValueUtils_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), "-").replace(ResManager.loadKDString((String)"\u65e5", (String)"SetValueUtils_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), "")).matches(regex)) {
                            dyo.set(key, (Object)DateUtils.stringToDate(value));
                        } else if (value.matches(regex_with_time)) {
                            dyo.set(key, (Object)DateUtils.stringToDate(value, "yyyy-MM-dd HH:mm:ss"));
                        } else {
                            dyo.set(key, null);
                        }
                    }
                } else if (cls.isAssignableFrom(DynamicObject.class)) {
                    dyo.set(key, (Object)value);
                } else {
                    dyo.set(key, (Object)value);
                }
            }
        }
    }

    private static void setDate(String key, String value, DynamicObject dyo, Format format) {
        if (EmptyCheckUtils.isEmpty(value)) {
            dyo.set(key, null);
        } else if (format != null) {
            try {
                dyo.set(key, format.parseObject(value));
            }
            catch (ParseException e) {
                if (format instanceof SimpleDateFormat) {
                    logger.error("setValue()\u3002key:" + key + ",value:" + value);
                    throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a\uff1a%s", (String)"SetValueUtils_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ((SimpleDateFormat)format).toPattern()), e);
                }
                logger.error("setValue()\u3002key:" + key + ",value:" + value);
                throw new RuntimeException(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef", (String)"SetValueUtils_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), e);
            }
        } else {
            dyo.set(key, (Object)DateUtils.stringToDate(value));
        }
    }

    private static boolean isMatch(String value) {
        return value.matches(regex);
    }
}

