/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.formplugin.formula;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;

public class FormulaTempListPlugin
extends AbstractListPlugin {
    private static String PARAM_TAXTYPE = "taxtype";

    public void afterCreateNewData(EventObject e) {
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        showParameter.setCaption(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u516c\u5f0f\u5217\u8868", (String)"FormulaTempListPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
    }

    public void initialize() {
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addFilterContainerInitListener(event -> this.filterContainerInit(event));
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"add"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("add".equals(key)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("tpo_formula_edit");
            showParameter.setParentPageId(this.getView().getPageId());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    private void filterContainerInit(FilterContainerInitEvent args) {
        List filterColumnList = args.getCommonFilterColumns();
        List schemeColumnList = args.getSchemeFilterColumns();
        CommonFilterColumn typeColumn = null;
        ArrayList<Object> typeList = new ArrayList<Object>();
        for (FilterColumn filterColumn : filterColumnList) {
            if (!filterColumn.getFieldName().startsWith(PARAM_TAXTYPE) || !(filterColumn instanceof CommonFilterColumn)) continue;
            typeColumn = (CommonFilterColumn)filterColumn;
            break;
        }
        String type = this.getParam(PARAM_TAXTYPE);
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        String[] types = TemplateTypeConstant.getTypeMap().get(type);
        if (null != types) {
            for (String tt : types) {
                ComboItem item = new ComboItem();
                item.setValue(tt);
                item.setCaption(new LocaleString(TemplateTypeConstant.getMap().getOrDefault(tt, tt)));
                combos.add(item);
                typeList.add(tt);
            }
        } else {
            for (Map.Entry entry : TemplateTypeConstant.getMap().entrySet()) {
                ComboItem item = new ComboItem();
                item.setValue((String)entry.getKey());
                item.setCaption(new LocaleString((String)entry.getValue()));
                combos.add(item);
                typeList.add(item.getValue());
            }
        }
        if (typeColumn != null) {
            if (!combos.isEmpty()) {
                typeColumn.setDefaultValue(((ComboItem)combos.get(0)).getValue());
            }
            typeColumn.setType("enum");
            typeColumn.setMustInput(true);
            typeColumn.setComboItems(combos);
            typeColumn.setComboItems(combos);
        }
        for (FilterColumn filterColumn : schemeColumnList) {
            if (!PARAM_TAXTYPE.equals(filterColumn.getFieldName())) continue;
            SchemeFilterColumn column1 = (SchemeFilterColumn)filterColumn;
            column1.setComboItems(combos);
            if (combos.isEmpty()) break;
            column1.setDefaultValue(((ComboItem)combos.get(0)).getValue());
            break;
        }
        BillList billlist = (BillList)this.getControl("billlistap");
        QFilter qFilter = new QFilter(PARAM_TAXTYPE, "in", typeList);
        billlist.setFilter(qFilter);
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        String type = data.getString(PARAM_TAXTYPE);
        if (PARAM_TAXTYPE.equals(columnDesc.getKey())) {
            e.setFormatValue((Object)TemplateTypeConstant.getMap().getOrDefault(type, ""));
        }
    }

    private String getParam(String param) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return (String)customParams.get(param);
    }
}

