/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.formplugin.template;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.SpreadDataModel;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.crypto.MD5;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.exception.ThrowableHelper;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;

public class TemplatePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String FORMULA_CACHE = "formulaCache";
    private static final String FORMULA_CACHE_CAL = "formulaCacheCal";
    private static final String FORMULA_CACHE_VAL = "formulaCacheVal";
    private static final String FORMULA_CACHE_CELL = "formulaCacheCell";
    private static final String DYNAMIC_ROW_CACHE = "dynamicRowCache";
    private static final String BDTAXR_FORMULAPICKER = "bdtaxr_formulapicker";
    private static final String BDTAXR_FORMULA_CELLTYPE = "bdtaxr_formula_celltype";
    private static final String BDTAXR_FORMULA_EDIT = "tpo_formula_edit";
    private static final String BTN_CELLTYPE_FORMULA = "celltype_formula";
    private static final String CALLBACK_SELECT_FORMULA = "selectFormula";
    private static final String CALLBACK_DYN_ROW = "dynamicRow";
    private static Log LOGGER = LogFactory.getLog(TemplatePlugin.class);
    private static final String DYNROWSET_ENTITY_NAME = "bdtaxr_template_dynrow";
    private static final String SPREAD_NAME = "spreadap";
    private static final String TEMPLATE_ENTITY_NAME = "bdtaxr_template_main";
    private static final String BUTTON_SETTING = "btn_setting";
    private static final String BUTTON_SAVE = "btn_save";
    private static final String BUTTON_VIEW = "btn_view";
    private static final String ACTIONID_SETTIING = "ACTIONID_SETTIING";
    private static final String SETTIING_FORM_ID = "bdtaxr_entity_select";
    private static final String BUTTON_SETFORMULA = "btn_setformula";
    private static final String BUTTON_FORMULA = "btn_formula";
    private static final String BUTTON_TMP_RELATION = "btn_tmp_relation";
    private static final String BUTTON_DELETE_FORMULA = "btn_delete_formula";
    private static final String DELETE_CALCULATE_FORMULA = "del_calculate_formula";
    private static final String DELETE_VALIDATE_FORMULA = "del_validate_formula";
    private static final String DELETE_CELLTYPE_FORMULA = "del_celltype_formula";
    private static final String DELETE_TEXT_FORMULA = "del_text_formul";
    private static final String BUTTON_FLOAT_SETTING = "btn_floatsetting";
    private static final String BUTTON_DYNROW = "btn_dynrow";
    private static final String BTN_TYPE = "btn_type";
    private static final String BTN_DOWN = "btn_down";
    private static final String BTN_DEBUG = "btn_debug";
    private static final String DOWN_JSON = "down_json";
    private static final String ORIGINAL_NUMBER = "originalNumber";
    private static final String ORIGINAL_ID = "originalId";
    private static final String TAXTYPE = "taxtype";
    private static final String TEMPLATENUM = "templatenum";
    private static final String TEMPLATEID = "templateid";
    private static final String TEMPLATE_ID = "template_id";
    private static final String FORMULAKEY = "formulakey";
    private static final String TABLE = "table";
    private static final String ROW = "row";
    private static final String COLUMN = "column";
    private static final String FORMULA = "formula";
    private static final String TITLE = "title";
    private static final String CONTENT = "content";
    private static final String CELLTYPE = "celltype";
    private static final String FORMULANAME = "formulaname";
    private static final String FORMULATYPE = "formulatype";
    private static final String DESCRIBE = "describe";
    private static final String TPO_TEMPLATE_TYPE = "tpo_template_type";
    private static final String ACTION_VIEW = "actionView";
    private static final String TCTB_TEMPLATE_FORMULA = "tpo_template_formula";
    private static final String ACTION_DOWN_JSON = "actionDownJson";
    private static final String SELECT_CELL_KEY = "selectCellKey";
    private static final String ACTION_SAVE = "actionSave";
    private static final long DEFAULT_ID_VALUE = 0L;
    private static final boolean PERMIT_DEL_SHEET = true;

    public void initialize() {
        super.initialize();
        SpreadDataModel spreadDataModel = new SpreadDataModel(this, SPREAD_NAME, TEMPLATE_ENTITY_NAME);
        spreadDataModel.setPageCache(this.getPageCache());
        this.getView().addService(ISpreadAction.class, (Object)spreadDataModel);
        BasedataEdit comboEdit = (BasedataEdit)this.getControl("type");
        comboEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> this.beforeF7Select(beforeF7SelectEvent));
    }

    private SpreadDataModel getSpreadDataModel() {
        return (SpreadDataModel)((Object)this.getView().getService(ISpreadAction.class));
    }

    private void delSheet() {
        String currentIndex = this.getPageCache().get("currentIndex");
        if (StringUtils.isNotEmpty((CharSequence)currentIndex)) {
            try {
                LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>(8);
                args.put("method", "deleteSheet");
                args.put("index", Integer.valueOf(currentIndex));
                args.put("sheetName", "");
                this.getPageCache().remove("currentIndex");
                this.getSpreadDataModel().askExecute(args);
                this.spreadOption("actionDelSheet");
            }
            catch (Exception e) {
                LOGGER.error("TemplatePlugin", (Throwable)e);
            }
        }
    }

    public void actionDelSheet(String spreadJson) {
        String json = SpreadUtils.getJson(spreadJson);
        LinkedHashMap<String, LinkedHashMap> jsonMap = SpreadUtils.getTemplateSheetMapFromJsonString(json);
        if (jsonMap.size() > 0) {
            int lastSheetIndex = jsonMap.size() - 1;
            this.getPageCache().put("currentIndex", String.valueOf(lastSheetIndex));
        } else {
            this.getPageCache().remove("currentIndex");
        }
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"delsheet"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getSpreadDataModel().init();
    }

    public void afterBindData(EventObject e) {
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        HashMap<String, String> data = new HashMap<String, String>(4);
        data.put("useNewInsert", "false");
        params.put("data", data);
        this.getSpreadDataModel().setSpreadParams(params);
        String json = (String)this.getModel().getValue("content_tag");
        String id = this.getModel().getValue("id") == null ? null : this.getModel().getValue("id").toString();
        this.getPageCache().put(TEMPLATEID, id);
        json = TemplateShowUtils.replaceJson(this.getTemplateType(), json, this.getPageCache(), true);
        this.getSpreadDataModel().setSpreadJson(json);
    }

    public void afterCopyData(EventObject e) {
        String json = (String)this.getModel().getValue("content_tag");
        json = TemplateShowUtils.replaceJson(this.getTemplateType(), json, this.getPageCache(), true);
        this.getSpreadDataModel().setSpreadJson(json);
    }

    public void itemClick(ItemClickEvent evt) {
        this.invokeOperationByKey(evt.getItemKey());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void invokeOperationByKey(String key) {
        block59: {
            paramMap /* !! */  = new HashMap<K, V>(16);
            id = this.getModel().getValue("id");
            showParameter = new FormShowParameter();
            formId = "";
            if (!StringUtils.isNotBlank((CharSequence)key)) break block59;
            var6_6 = key;
            var7_7 = -1;
            switch (var6_6.hashCode()) {
                case 832284724: {
                    if (!var6_6.equals("delsheet")) break;
                    var7_7 = 0;
                    break;
                }
                case 2108396928: {
                    if (!var6_6.equals("btn_save")) break;
                    var7_7 = 1;
                    break;
                }
                case 1764366189: {
                    if (!var6_6.equals("btn_setting")) break;
                    var7_7 = 2;
                    break;
                }
                case 2108493480: {
                    if (!var6_6.equals("btn_view")) break;
                    var7_7 = 3;
                    break;
                }
                case -898999677: {
                    if (!var6_6.equals("btn_formula")) break;
                    var7_7 = 4;
                    break;
                }
                case 1058982023: {
                    if (!var6_6.equals("btn_setformula")) break;
                    var7_7 = 5;
                    break;
                }
                case 1200149799: {
                    if (!var6_6.equals("btn_tmp_relation")) break;
                    var7_7 = 6;
                    break;
                }
                case 934884291: {
                    if (!var6_6.equals("celltype_formula")) break;
                    var7_7 = 7;
                    break;
                }
                case 2108449597: {
                    if (!var6_6.equals("btn_type")) break;
                    var7_7 = 8;
                    break;
                }
                case 2107963557: {
                    if (!var6_6.equals("btn_down")) break;
                    var7_7 = 9;
                    break;
                }
                case 1300567653: {
                    if (!var6_6.equals("down_json")) break;
                    var7_7 = 10;
                    break;
                }
                case -136212715: {
                    if (!var6_6.equals("btn_delete_formula")) break;
                    var7_7 = 11;
                    break;
                }
                case 802870873: {
                    if (!var6_6.equals("del_calculate_formula")) break;
                    var7_7 = 12;
                    break;
                }
                case -1623871247: {
                    if (!var6_6.equals("del_validate_formula")) break;
                    var7_7 = 13;
                    break;
                }
                case -1279374985: {
                    if (!var6_6.equals("del_celltype_formula")) break;
                    var7_7 = 14;
                    break;
                }
                case 1894784889: {
                    if (!var6_6.equals("del_text_formul")) break;
                    var7_7 = 15;
                    break;
                }
                case 614460791: {
                    if (!var6_6.equals("btn_floatsetting")) break;
                    var7_7 = 16;
                    break;
                }
                case -1462610940: {
                    if (!var6_6.equals("btn_dynrow")) break;
                    var7_7 = 17;
                    break;
                }
                case 922043056: {
                    if (!var6_6.equals("btn_debug")) break;
                    var7_7 = 18;
                }
            }
            switch (var7_7) {
                case 0: {
                    this.delSheet();
                    break;
                }
                case 1: {
                    this.save();
                    break;
                }
                case 2: {
                    this.checkCellFormulaIsSelected();
                    this.settingClick();
                    break;
                }
                case 3: {
                    this.spreadOption("actionView");
                    break;
                }
                case 4: {
                    showParameter.setFormId("tpo_template_formula");
                    showParameter.setParentPageId(this.getView().getPageId());
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    this.getView().showForm(showParameter);
                    break;
                }
                case 5: {
                    formId = "tpo_formula_edit";
                    paramMap /* !! */  = (Map)SerializationUtils.fromJsonString((String)this.getSpreadSelectedCellKey(), Map.class);
                    param = new HashMap<String, String>();
                    param.putAll(paramMap /* !! */ );
                    if (this.checkParamMap(param, this.getView(), key)) {
                        return;
                    }
                    this.showFormulaList(param, formId);
                    break;
                }
                case 6: {
                    showParameter.setFormId("bdtaxr_tmp_relation");
                    showParameter.setParentPageId(this.getView().getPageId());
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    templateNum = (String)this.getModel().getValue("number");
                    templateId = String.valueOf(this.getModel().getValue("id"));
                    map = new HashMap<String, String>();
                    map.put("templateid", templateId);
                    map.put("templatenum", templateNum);
                    showParameter.setCustomParams(map);
                    this.getView().showForm(showParameter);
                    break;
                }
                case 7: {
                    formId = "bdtaxr_formula_celltype";
                    paramMap /* !! */  = (Map)SerializationUtils.fromJsonString((String)this.getSpreadSelectedCellKey(), Map.class);
                    para = new HashMap<String, String>();
                    para.putAll(paramMap /* !! */ );
                    if (this.checkParamMap(para, this.getView(), key)) {
                        return;
                    }
                    this.showFormulaList(para, formId);
                    break;
                }
                case 8: {
                    showParameter = new ListShowParameter();
                    ((ListShowParameter)showParameter).setBillFormId("tpo_template_type");
                    showParameter.setFormId("bos_list");
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    closeCallBack = new CloseCallBack((IFormPlugin)this, "tpo_template_type");
                    showParameter.setCloseCallBack(closeCallBack);
                    this.getView().showForm(showParameter);
                    break;
                }
                case 9: {
                    if (this.checkTemplateIsSave(id, this.getView())) {
                        return;
                    }
                    try {
                        in = TemplateShowUtils.getbuildExcel("origin", (Long)id);
                        var15_17 = null;
                        name = this.convertLocalName((OrmLocaleValue)this.getModel().getValue("name"));
                        urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(name + ".xlsx", in, 5000);
                        this.getView().openUrl(urls);
                        if (in == null) break;
                        if (var15_17 == null) ** GOTO lbl163
                        try {
                            in.close();
                        }
                        catch (Throwable var18_21) {
                            var15_17.addSuppressed(var18_21);
                        }
                        break;
lbl163:
                        // 1 sources

                        in.close();
                        ** break;
                        catch (Throwable var16_19) {
                            try {
                                var15_17 = var16_19;
                                throw var16_19;
                            }
                            catch (Throwable var19_22) {
                                if (in != null) {
                                    if (var15_17 != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable var20_23) {
                                            var15_17.addSuppressed(var20_23);
                                        }
                                    } else {
                                        in.close();
                                    }
                                }
                                throw var19_22;
lbl180:
                                // 1 sources

                                break;
                            }
                        }
                    }
                    catch (IOException e) {
                        throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
                    }
                }
                case 10: {
                    if (this.checkTemplateIsSave(id, this.getView())) {
                        return;
                    }
                    this.spreadOption("actionDownJson");
                    break;
                }
                case 11: {
                    this.deleteFormulaByKeyAndType(null, String.valueOf(id), key);
                    break;
                }
                case 12: {
                    this.deleteFormulaByKeyAndType("1", String.valueOf(id), key);
                    break;
                }
                case 13: {
                    this.deleteFormulaByKeyAndType("2", String.valueOf(id), key);
                    break;
                }
                case 14: {
                    this.deleteFormulaByKeyAndType("3", String.valueOf(id), key);
                    break;
                }
                case 15: {
                    this.deleteFormulaByKeyAndType("4", String.valueOf(id), key);
                    break;
                }
                case 16: {
                    customParams = new HashMap<String, Object>(16);
                    customParams.put("basetemplateid", id);
                    customParams.put("templateType", ((DynamicObject)this.getModel().getValue("type")).getString("id"));
                    PageShowCommon.showBillList(ShowType.Modal, "tpo_template_floatset", this.getView(), customParams);
                    break;
                }
                case 17: {
                    this.checkCellFormulaIsSelected();
                    this.dynamicRowSetting();
                    break;
                }
                case 18: {
                    break;
                }
            }
        }
    }

    private String convertLocalName(OrmLocaleValue ormLocaleValue) {
        if (null != ormLocaleValue) {
            return ormLocaleValue.getLocaleValue();
        }
        return "";
    }

    private boolean checkTemplateIsSave(Object id, IFormView view) {
        if (id == null || (Long)id == 0L) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6a21\u677f", (String)"TemplatePlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkParamMap(Map<String, String> paramMap, IFormView view, String operationKey) {
        if (StringUtils.isEmpty((CharSequence)paramMap.get(SELECT_CELL_KEY)) || paramMap.isEmpty()) {
            if (BUTTON_DELETE_FORMULA.equals(operationKey) || operationKey.startsWith("del")) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u5143\u683c\u6ca1\u6709\u8bfb\u53d6\u5230\u6b63\u786e\u7684\u516c\u5f0f\u6807\u8bc6\uff0c\u4e0d\u80fd\u5220\u9664,\u8bf7\u5230\u7533\u62a5\u516c\u5f0f\u5217\u8868\u754c\u9762\u8fdb\u884c\u5220\u9664", (String)"TemplatePlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (BUTTON_SETFORMULA.equals(operationKey)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5355\u5143\u683c\u6ca1\u6709\u8bfb\u53d6\u5230\u6b63\u786e\u7684\u516c\u5f0f\u6807\u8bc6\uff0c\u4e0d\u80fd\u64cd\u4f5c", (String)"TemplatePlugin_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            return true;
        }
        return false;
    }

    private void deleteFormulaByKeyAndType(String formulaType, String templateId, String key) {
        this.checkCellFormulaIsSelected();
        TreeUtils.putCache(this.getPageCache(), "formulaType", formulaType);
        TreeUtils.putCache(this.getPageCache(), "templateId", templateId);
        TreeUtils.putCache(this.getPageCache(), "operationKey", key);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("delete", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TemplatePlugin_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TemplatePlugin_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u76841\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"TemplatePlugin_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Delete, confirmCallBacks, btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if ("delete".equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            String key = TreeUtils.getCache(this.getPageCache(), "operationKey", String.class);
            try {
                Map paramMap = (Map)SerializationUtils.fromJsonString((String)this.getSpreadSelectedCellKey(), Map.class);
                if (this.checkParamMap(paramMap, this.getView(), key)) {
                    return;
                }
                long templateId = TreeUtils.getCache(this.getPageCache(), "templateId", Long.class);
                String formulaType = TreeUtils.getCache(this.getPageCache(), "formulaType", String.class);
                boolean apiResult = (Boolean)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"FormulaService", (String)"deleteFormulaByKeyAndType", (Object[])new Object[]{formulaType, paramMap.get(SELECT_CELL_KEY), templateId});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"TemplatePlugin_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            catch (Exception ex) {
                LOGGER.error("serialization error:" + ThrowableHelper.toString(ex));
            }
        }
    }

    private void save() {
        if (this.checkTemplate(this.getModel(), this.getView())) {
            return;
        }
        this.spreadOption(ACTION_SAVE);
    }

    private boolean checkTemplate(IDataModel dataModel, IFormView view) {
        DynamicObject typeObject = (DynamicObject)this.getModel().getValue("type");
        String name = (String)this.getModel().getValue("name");
        String number = (String)this.getModel().getValue("number");
        Date startdate = DateUtils.getFirstDateOfMonth((Date)this.getModel().getValue("startdate"));
        Date enddate = DateUtils.getLastDateOfMonth((Date)this.getModel().getValue("enddate"));
        if (StringUtils.isEmpty((CharSequence)number)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6a21\u677f\u7f16\u7801", (String)"TemplatePlugin_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return true;
        }
        if (StringUtils.isEmpty((CharSequence)name)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6a21\u677f\u540d\u79f0", (String)"TemplatePlugin_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return true;
        }
        if (typeObject == null || StringUtils.isEmpty((CharSequence)typeObject.getString("id"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u7c7b\u578b", (String)"TemplatePlugin_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return true;
        }
        if (startdate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6a21\u677f\u751f\u6548\u65e5\u671f", (String)"TemplatePlugin_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return true;
        }
        if (enddate != null && startdate.compareTo(enddate) > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6a21\u677f\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65e5\u671f", (String)"TemplatePlugin_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return true;
        }
        String type = typeObject.getString("id");
        DynamicObject tempTypeObj = BusinessDataServiceHelper.loadSingle((Object)typeObject.get("id"), (String)TPO_TEMPLATE_TYPE);
        String uniqueType = tempTypeObj.getString("uniquetype");
        if (!"multiple".equals(uniqueType)) {
            QFilter qfilter2;
            Object idObj = this.getModel().getValue("id");
            QFilter qfilter = new QFilter("type", "=", (Object)type);
            if (idObj != null) {
                qfilter = qfilter.and(new QFilter("id", "!=", idObj));
            }
            if ("number".equals(uniqueType)) {
                qfilter = qfilter.and(new QFilter("number", "=", (Object)number));
            }
            if (enddate == null) {
                qfilter2 = QFilter.isNull((String)"enddate");
                qfilter2 = qfilter2.or(new QFilter("startdate", ">=", (Object)startdate));
                qfilter = qfilter.and(qfilter2);
            } else {
                qfilter2 = new QFilter("startdate", ">=", (Object)enddate);
                qfilter2 = qfilter2.and(new QFilter("enddate", "<=", (Object)enddate));
                QFilter qfilter3 = new QFilter("startdate", ">=", (Object)startdate);
                qfilter3 = qfilter3.and(new QFilter("enddate", "<=", (Object)startdate));
                QFilter qfilter4 = new QFilter("startdate", ">=", (Object)startdate);
                qfilter4 = qfilter4.and(new QFilter("startdate", "<=", (Object)enddate));
                QFilter q = qfilter2.or(qfilter3).or(qfilter4);
                qfilter.and(q);
            }
            DynamicObjectCollection collection = QueryServiceHelper.query((String)TEMPLATE_ENTITY_NAME, (String)"id,name", (QFilter[])new QFilter[]{qfilter});
            if (collection != null && !collection.isEmpty()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u677f\u751f\u6548\u65f6\u95f4\u6bb5\u5df2\u7ecf\u6709\u6a21\u677f\uff0c\u8bf7\u4fee\u6539\u751f\u6548\u6216\u5931\u6548\u65e5\u671f", (String)"TemplatePlugin_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private void spreadOption(String method) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("callback", "invokeAction");
        params.put("invokemethod", method);
        this.getPageCache().put("starttime", System.currentTimeMillis() + "");
        this.getSpreadDataModel().getSpreadJson(params);
    }

    public void doubleClickLockedCell(int r, int c) {
    }

    private void settingClick() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(SETTIING_FORM_ID);
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        String entityid = TreeUtils.getCache(this.getPageCache(), "entityid", String.class);
        String entityName = TreeUtils.getCache(this.getPageCache(), "entityname", String.class);
        showParameter.setCustomParam("entityid", (Object)entityid);
        showParameter.setCustomParam("entityname", (Object)entityName);
        String type = this.getTemplateType();
        showParameter.setCustomParam("templateType", (Object)type);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, ACTIONID_SETTIING);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object data = event.getReturnData();
        if (data != null && ACTIONID_SETTIING.equals(event.getActionId())) {
            if (Map.class.isAssignableFrom(data.getClass())) {
                Map returnData = (Map)data;
                List<Integer> selCols = this.getSpreadDataModel().getSelCols();
                List<Integer> selRows = this.getSpreadDataModel().getSelRows();
                if (selCols == null || selRows == null || selRows.isEmpty() || selCols.isEmpty()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u5143\u683c", (String)"TemplatePlugin_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    return;
                }
                Boolean rowfill = (Boolean)returnData.get("rowfill");
                Boolean columnfill = (Boolean)returnData.get("columnfill");
                List column = (List)returnData.get(COLUMN);
                List row = (List)returnData.get(ROW);
                String entityid = (String)returnData.get("entityid");
                TreeUtils.putCache(this.getPageCache(), "entityid", entityid);
                String entityname = (String)returnData.get("entityname");
                TreeUtils.putCache(this.getPageCache(), "entityname", entityname);
                ArrayList<Map<String, Object>> updateCells = new ArrayList<Map<String, Object>>();
                int rowId = selRows.get(0);
                for (Map rowMap : row) {
                    int colId = selCols.get(0);
                    String rowValueId = (String)rowMap.get("id");
                    if ("ROOT".equals(rowValueId)) continue;
                    for (Map colMap : column) {
                        String colValueId = (String)rowMap.get("id");
                        if ("ROOT".equals(colValueId)) continue;
                        HashMap<String, Object> valMap = new HashMap<String, Object>(16);
                        valMap.put("r", rowId);
                        valMap.put("c", colId);
                        String valText = entityname + "#" + (String)colMap.get("text") + "#" + (String)rowMap.get("text");
                        if (rowValueId.startsWith(entityid)) {
                            valText = (String)rowMap.get("id") + "#" + (String)colMap.get("id");
                        }
                        valMap.put("v", "${" + valText + "}");
                        valMap.put("rc", 1);
                        valMap.put("cc", 1);
                        updateCells.add(valMap);
                        if (!columnfill.booleanValue()) break;
                        ++colId;
                    }
                    if (!rowfill.booleanValue()) break;
                    ++rowId;
                }
                HashMap<String, Cloneable> features = new HashMap<String, Cloneable>(4);
                HashMap<String, String> styleMap = new HashMap<String, String>(4);
                styleMap.put("bkc", "#d4ffaa");
                features.put("range", updateCells);
                features.put("style", styleMap);
                this.getSpreadDataModel().updataValue(updateCells);
                this.getSpreadDataModel().setCellStyle(Lists.newArrayList((Object[])new Map[]{features}));
            }
        } else if (TPO_TEMPLATE_TYPE.equals(event.getActionId())) {
            this.getView().updateView();
        } else if (CALLBACK_SELECT_FORMULA.equals(event.getActionId()) && data != null) {
            Map returnData = (Map)data;
            this.handleCallBackFormula(returnData);
        }
    }

    private void dynamicRowSetting() {
        String cellJson = this.getSpreadDataModel().getSelectedCellKey();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(DYNROWSET_ENTITY_NAME);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setStatus(OperationStatus.EDIT);
        Map param = JsonUtil.fromJson(cellJson, Map.class);
        parameter.setCustomParams(param);
        parameter.setCustomParam("modeltype", (Object)"2");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_DYN_ROW);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    public void actionView(String spreadJson) {
        String json = SpreadUtils.getJson(spreadJson);
        String pageId = MD5.md5crypt(this.getView().getPageId());
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("operation", "edit");
        String templateHtml = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"TemplateService", (String)"extractTemplateJson", (Object[])new Object[]{json, null, null, pageId, customParams});
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tpo_templat_view");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("json", (Object)templateHtml);
        this.getView().showForm(showParameter);
    }

    public void actionSave(String spreadJson) {
        boolean isSuccess = false;
        try (TXHandle h = TX.requiresNew();){
            try {
                isSuccess = this.doSave(spreadJson);
            }
            catch (Throwable t) {
                h.markRollback();
                LOGGER.error("Template save error!!!", t);
            }
        }
        if (isSuccess) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"TemplatePlugin_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"TemplatePlugin_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        this.getModel().setDataChanged(false);
        this.getView().sendFormAction(this.getView());
    }

    private boolean doSave(String spreadJson) {
        Object[] ids;
        String json = SpreadUtils.getJson(spreadJson);
        IDataModel model = this.getModel();
        Long idObj = (Long)model.getValue("id");
        DynamicObject dObj = null;
        boolean exists = QueryServiceHelper.exists((String)TEMPLATE_ENTITY_NAME, (Object)idObj);
        dObj = idObj != null && idObj > 0L && exists ? BusinessDataServiceHelper.loadSingle((Object)idObj, (String)TEMPLATE_ENTITY_NAME) : BusinessDataServiceHelper.newDynamicObject((String)TEMPLATE_ENTITY_NAME);
        String name = (String)model.getValue("name");
        String number = (String)model.getValue("number");
        Date startdate = DateUtils.getFirstDateOfMonth((Date)model.getValue("startdate"));
        LOGGER.info(DateUtils.format((Date)model.getValue("enddate"), "yyyy-MM-dd HH:mm:ss"));
        Date enddate = DateUtils.getLastDateOfMonth((Date)model.getValue("enddate"));
        if (enddate != null) {
            enddate = DateUtils.trunc(enddate);
        }
        LOGGER.info(DateUtils.format(enddate, "yyyy-MM-dd HH:mm:ss"));
        dObj.set("type", this.getModel().getValue("type"));
        dObj.set("number", (Object)number);
        dObj.set("name", (Object)name);
        dObj.set("startdate", (Object)startdate);
        dObj.set("enddate", (Object)enddate);
        dObj.set("updatetime", (Object)new Date());
        Map<String, String> colsMap = this.getColsMap();
        Set<Map.Entry<String, String>> entry = colsMap.entrySet();
        for (Map.Entry<String, String> ent : entry) {
            json = json.replace("${" + ent.getValue() + "}", "${" + ent.getKey() + "}");
        }
        String type = this.getTemplateType();
        Map<String, String> listTab = TemplateUtils.queryEntityByTypeId(type);
        HashMap<String, EntityField> fieldMap = new HashMap<String, EntityField>(16);
        for (Map.Entry<String, String> entity : listTab.entrySet()) {
            fieldMap.putAll(TemplateUtils.getEntityFieldMap(entity.getKey(), "#", null));
        }
        Map<String, EntityField> mapEntity = TemplateShowUtils.queryTemplateField(fieldMap, json);
        dObj.set("html_tag", (Object)SerializationUtils.toJsonString(mapEntity));
        dObj.set("content_tag", (Object)json);
        for (Object obj : ids = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObj})) {
            DynamicObject idObj1 = (DynamicObject)obj;
            model.setValue("id", idObj1.getPkValue());
            this.getPageCache().put(TEMPLATEID, idObj1.getPkValue().toString());
        }
        Map<String, Object> map = this.getCopyTemplateNumAndId();
        if (StringUtils.isNotBlank((Object)map.get(ORIGINAL_ID)) && (idObj == null || idObj == 0L)) {
            QFilter q2;
            String dynRowAllKeys;
            DynamicObject[] dynrows;
            QFilter qFilter = new QFilter(TEMPLATEID, "=", (Object)map.get(ORIGINAL_ID).toString());
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)BDTAXR_FORMULA_EDIT, (String)"id,taxtype,templatenum,formulatype,formulakey,name,table,row,column,celltype,title,content,describe,templateid,updatetime,formulaname,formula", (QFilter[])new QFilter[]{qFilter});
            if (dynamicObjects.length > 0) {
                SaveServiceHelper.save((DynamicObject[])this.copyFormula(dynamicObjects, model));
            }
            if ((dynrows = BusinessDataServiceHelper.load((String)DYNROWSET_ENTITY_NAME, (String)(dynRowAllKeys = "id,dynrow_no,rule_name,start_row,enable,rule_id,modifier,creator,template_id,modifytime,createtime,seq_no,group_no,type,pluginpath,disablefrontop,modeltype"), (QFilter[])new QFilter[]{q2 = new QFilter(TEMPLATE_ID, "=", map.get(ORIGINAL_ID))})).length > 0) {
                SaveServiceHelper.save((DynamicObject[])this.copyDynrowFormula(dynrows, model, dynRowAllKeys));
            }
        } else {
            QFilter qFilter = new QFilter(TEMPLATEID, "=", (Object)String.valueOf(model.getValue("id")));
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)BDTAXR_FORMULA_EDIT, (String)"id,taxtype,templatenum,updatetime", (QFilter[])new QFilter[]{qFilter});
            ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
            DynamicObject typeObject = (DynamicObject)this.getModel().getValue("type");
            if (dynamicObjects.length > 0) {
                for (DynamicObject obj : dynamicObjects) {
                    DynamicObject idObj1 = obj;
                    if (StringUtils.isNotBlank((Object)idObj1.get(TEMPLATENUM)) && StringUtils.equals((CharSequence)number, (CharSequence)((String)idObj1.get(TEMPLATENUM))) && StringUtils.isNotBlank((CharSequence)idObj1.getDynamicObject(TAXTYPE).getString("id")) && StringUtils.equals((CharSequence)typeObject.getString("id"), (CharSequence)idObj1.getDynamicObject(TAXTYPE).getString("id"))) continue;
                    idObj1.set(TEMPLATENUM, (Object)number);
                    idObj1.set(TAXTYPE, (Object)typeObject.getString("id"));
                    idObj1.set("updatetime", (Object)new Date());
                    list.add(idObj1);
                }
                if (!CollectionUtils.isEmpty(list)) {
                    SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
                }
            }
        }
        return true;
    }

    private Map<String, String> getColsMap() {
        String type = this.getTemplateType();
        Map<String, String> colsMap = TreeUtils.getCache(this.getPageCache(), type + "allField", Map.class);
        if (colsMap != null) {
            return colsMap;
        }
        if (type != null) {
            Map<String, String> listTab = TemplateUtils.queryEntityByTypeId(type);
            colsMap = TemplateUtils.getAllEntityFieldMap(listTab);
            TreeUtils.putCache(this.getPageCache(), type + "allField", colsMap);
            return colsMap;
        }
        return new HashMap<String, String>();
    }

    public void actionDownJson(String spreadJson) {
        String json = SpreadUtils.getJson(spreadJson);
        json = TemplateShowUtils.replaceJson(this.getTemplateType(), json, this.getPageCache(), false);
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        String name = this.getModel().getValue("number") + this.convertLocalName((OrmLocaleValue)this.getModel().getValue("name"));
        String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(name + ".json", (InputStream)in, 5000);
        this.getView().openUrl(urls);
    }

    public String getTemplateType() {
        DynamicObject typeObject = (DynamicObject)this.getModel().getValue("type");
        if (typeObject != null) {
            return typeObject.getString("id");
        }
        return null;
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        Control base = (Control)event.getSource();
        if ("type1".equals(base.getKey())) {
            ListShowParameter param = (ListShowParameter)event.getFormShowParameter();
            String type = null;
            if (null != this.getView().getParentView()) {
                Map customParams = this.getView().getParentView().getFormShowParameter().getCustomParams();
                type = (String)customParams.get(TAXTYPE);
            }
            ArrayList<String> combos = new ArrayList<String>();
            String[] types = TemplateTypeConstant.getTypeMap().get(type);
            if (null != types) {
                combos.addAll(Arrays.asList(types));
            } else {
                for (Map.Entry<String, String> entry : TemplateTypeConstant.getMap().entrySet()) {
                    combos.add(entry.getKey());
                }
            }
            ArrayList<QFilter> list = new ArrayList<QFilter>();
            list.add(new QFilter("id", "in", (Object)combos.toArray(new String[0])));
            param.setListFilterParameter(new ListFilterParameter(list, (String)null));
        }
    }

    private void checkCellFormulaIsSelected() {
        List<Integer> selCols = this.getSpreadDataModel().getSelCols();
        List<Integer> selRows = this.getSpreadDataModel().getSelRows();
        Object type = this.getModel().getValue("type");
        if (selCols == null || selRows == null || selRows.isEmpty() || selCols.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u5143\u683c", (String)"TemplatePlugin_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
    }

    private String getSpreadSelectedCellKey() {
        return this.getSpreadDataModel().getSelectedCellKey();
    }

    private Map<String, Object> getCopyTemplateNumAndId() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Object originalId = null;
        FormShowParameter object = this.getView().getFormShowParameter();
        if (object instanceof BillShowParameter) {
            BillShowParameter showParameter = (BillShowParameter)object;
            OperationStatus status = showParameter.getStatus();
            Object pkId = showParameter.getPkId();
            if (OperationStatus.ADDNEW == status && StringUtils.isNotBlank((Object)pkId)) {
                originalId = pkId;
            }
        }
        paramMap.put(ORIGINAL_ID, originalId);
        return paramMap;
    }

    private DynamicObject[] copyFormula(DynamicObject[] dynamicObjects, IDataModel model) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (dynamicObjects.length > 0) {
            for (DynamicObject dyo : dynamicObjects) {
                DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)BDTAXR_FORMULA_EDIT);
                object.set(TAXTYPE, (Object)((DynamicObject)model.getValue("type")).getString("id"));
                object.set(TEMPLATENUM, model.getValue("number"));
                object.set(TEMPLATEID, model.getValue("id"));
                object.set(FORMULAKEY, (Object)dyo.getString(FORMULAKEY));
                object.set(TABLE, (Object)dyo.getString(TABLE));
                object.set(ROW, (Object)dyo.getString(ROW));
                object.set(COLUMN, (Object)dyo.getString(COLUMN));
                object.set(FORMULA, (Object)dyo.getString(FORMULA));
                object.set(TITLE, (Object)dyo.getString(TITLE));
                object.set(CONTENT, (Object)dyo.getString(CONTENT));
                object.set(CELLTYPE, (Object)dyo.getString(CELLTYPE));
                object.set("name", (Object)dyo.getString("name"));
                object.set(FORMULANAME, (Object)dyo.getString(FORMULANAME));
                object.set(FORMULATYPE, (Object)dyo.getString(FORMULATYPE));
                object.set(DESCRIBE, (Object)dyo.getString(DESCRIBE));
                object.set("updatetime", (Object)new Date());
                list.add(object);
            }
        }
        return list.toArray(new DynamicObject[list.size()]);
    }

    private DynamicObject[] copyDynrowFormula(DynamicObject[] dynamicObjects, IDataModel model, String allFields) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (dynamicObjects.length > 0) {
            for (DynamicObject dyo : dynamicObjects) {
                DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)DYNROWSET_ENTITY_NAME);
                for (String key : allFields.split(",")) {
                    if (key.equals("id")) continue;
                    object.set(key, dyo.get(key));
                }
                object.set(TEMPLATE_ID, model.getValue("id"));
                object.set("createtime", (Object)new Date());
                object.set("modifytime", (Object)new Date());
                list.add(object);
            }
        }
        return list.toArray(new DynamicObject[list.size()]);
    }

    public void showFormulaPanel(int row, int col) {
    }

    private void showFormulaList(Map<String, String> param, String formId) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(formId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setParentPageId(this.getView().getPageId());
        parameter.setStatus(OperationStatus.EDIT);
        DynamicObject typeObject = (DynamicObject)this.getModel().getValue("type");
        String taxType = "";
        if (typeObject != null) {
            taxType = typeObject.getString("id");
        }
        String templateNumber = (String)this.getModel().getValue("number");
        String formulaKey = param.get(SELECT_CELL_KEY);
        String templateId = String.valueOf(this.getModel().getValue("id"));
        String apiResult = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"FormulaService", (String)"queryDBFormulaByFormulaKey", (Object[])new Object[]{"1", formulaKey, templateId});
        List formulaVoList = JSONArray.parseArray((String)apiResult, FormulaVo.class);
        HashMap<String, String> customParams = new HashMap<String, String>(16);
        if (null != formulaVoList && !formulaVoList.isEmpty()) {
            FormulaVo vo = (FormulaVo)formulaVoList.get(0);
            customParams.put(FORMULAKEY, formulaKey);
            customParams.put(FORMULATYPE, vo.getFormulaType());
            customParams.put(FORMULANAME, vo.getFormulaName());
            customParams.put(FORMULA, vo.getFormula());
            customParams.put(CONTENT, vo.getContent());
            customParams.put(CELLTYPE, vo.getCellType());
            customParams.put(TITLE, vo.getTitle());
            customParams.put("name", vo.getName());
            customParams.put(DESCRIBE, vo.getDescribe());
        } else {
            customParams.put(FORMULAKEY, formulaKey);
            customParams.put(FORMULATYPE, "1");
            customParams.put("name", param.get("selectCellName"));
        }
        customParams.put(TAXTYPE, taxType);
        customParams.put(TEMPLATENUM, templateNumber);
        customParams.put(TEMPLATEID, templateId);
        customParams.put("from", "templateForm");
        parameter.setCustomParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_SELECT_FORMULA);
        parameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(parameter);
    }

    private void handleCallBackFormula(Map<String, Object> returndata) {
        List<Integer> selCols = this.getSpreadDataModel().getSelCols();
        List<Integer> selRows = this.getSpreadDataModel().getSelRows();
        if (selCols == null || selRows == null || selRows.isEmpty() || selCols.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5355\u5143\u683c", (String)"TemplatePlugin_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> data = returndata;
        if (EmptyCheckUtils.isNotEmpty(data)) {
            data.entrySet().forEach(v -> {
                FormulaVo vo;
                Object value = v.getValue();
                String key = (String)v.getKey();
                if (null != value && StringUtils.isNotBlank((CharSequence)(vo = (FormulaVo)value).getFormulaKey())) {
                    if (!vo.getFormulaKey().contains("#")) {
                        int rowId = (Integer)selRows.get(0);
                        int colId = (Integer)selCols.get(0);
                        HashMap<String, Object> valMap = new HashMap<String, Object>(16);
                        valMap.put("r", rowId);
                        valMap.put("c", colId);
                        valMap.put("f", vo.getFormula());
                        ArrayList<HashMap<String, Object>> updateCells = new ArrayList<HashMap<String, Object>>();
                        updateCells.add(valMap);
                        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                        paramMap.put("cell", updateCells);
                        paramMap.put("si", "");
                        this.getSpreadDataModel().setFormula(paramMap);
                    } else {
                        if ("calculate".equals(key)) {
                            TreeUtils.putCache(this.getPageCache(), FORMULA_CACHE_CAL + vo.getFormulaKey(), vo);
                        }
                        if ("validate".equals(key)) {
                            TreeUtils.putCache(this.getPageCache(), FORMULA_CACHE_VAL + vo.getFormulaKey(), vo);
                        }
                        if ("cellType".equals(key)) {
                            TreeUtils.putCache(this.getPageCache(), FORMULA_CACHE_CELL + vo.getFormulaKey(), vo);
                        }
                    }
                }
            });
        }
    }
}

