/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.login.utils.LoginUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.db.DBSaveUtils;
import kd.taxc.bdtaxr.common.db.MapToTableUtils;
import kd.taxc.bdtaxr.common.db.NewObjectUtils;
import kd.taxc.bdtaxr.common.declare.handler.TaxBureauDataHandler;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.TrasEntityMapEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class TrasStaffTaxBureauDataService
implements TaxBureauDataHandler {
    private static final String EWBLXH = "ewblxh";
    private static final String EWBLNAME = "ewblname";
    private static final String ORG = "org";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";

    @Override
    public void saveTaxBureauData(String entryName, DeclareRequestModel requestModel, String data) {
        LoginUtils.logger.info("=====================data===================" + data);
        LoginUtils.logger.info("=====================\u7a0e\u5c40\u4e0b\u8f7d\u7533\u62a5\u8868\u5f00\u59cb===================");
        if ("bdtaxr_taxbureau_sbb".equals(entryName) && StringUtil.isNotBlank((CharSequence)data)) {
            LoginUtils.logger.info("=====================\u66ff\u6362\u6210\u7a0e\u5c40\u7248\u4e2d\u95f4\u8868\u7684\u62a5\u6587\u683c\u5f0f\u6570\u636e===================");
            String tempJsonData = data.replace(TrasEntityMapEnum.TCVVT_TAX.getSourceTableName(), TrasEntityMapEnum.TCVVT_TAX.getTargetTableName()).replace(TrasEntityMapEnum.TCVVT_TRAS_QUESTIONARE.getSourceTableName(), TrasEntityMapEnum.TCVVT_TRAS_QUESTIONARE.getTargetTableName());
            Map newMaps = JsonUtil.fromJson(tempJsonData, Map.class);
            if (ObjectUtils.isEmpty((Object)newMaps)) {
                LoginUtils.logger.info("=====================newMaps\u6570\u636e\u4e3a\u7a7a===================" + newMaps);
                return;
            }
            HashMap<String, String> tableMap = new HashMap<String, String>(){
                {
                    this.put(TrasEntityMapEnum.TCVVT_TAX.getTargetTableName(), TrasEntityMapEnum.TCVVT_TAX.getTargetTableName());
                    this.put(TrasEntityMapEnum.TCVVT_TRAS_QUESTIONARE.getTargetTableName(), TrasEntityMapEnum.TCVVT_TRAS_QUESTIONARE.getTargetTableName());
                }
            };
            LoginUtils.logger.info("=====================\u65b0\u589e\u6216\u8986\u76d6\u5df2\u6709\u7684\u6570\u636e===================");
            String mainId = (String)newMaps.get(NewObjectUtils.getIdByKey("tcvat_nsrxx"));
            Iterator delIter = newMaps.entrySet().iterator();
            while (delIter.hasNext()) {
                Map.Entry entry2 = delIter.next();
                if (!((String)entry2.getKey()).contains("tcvat_nsrxx") && !((String)entry2.getKey()).contains("bdtaxr_taxbureau_sbb") && !((String)entry2.getKey()).contains("tcetr_declare_main") && !((String)entry2.getKey()).contains("tcvvt_boom_survey") && !((String)entry2.getKey()).contains("tcvvt_debty") && !((String)entry2.getKey()).contains("tcvvt_tras_attached")) continue;
                delIter.remove();
            }
            LoginUtils.logger.info("=====================\u5c06newMaps\u8f6c\u6210\u5b9e\u4f53\u4fdd\u5b58\u5bf9\u8c61===================");
            Map<String, DynamicObjectCollection> newDbMap = MapToTableUtils.mapToTable("tcvat_nsrxx", mainId, newMaps, (Map<String, String>)tableMap);
            List rangeList = Arrays.stream(TrasEntityMapEnum.values()).map(o -> o.getTargetTableName()).collect(Collectors.toList());
            newDbMap.keySet().removeIf(entry -> !rangeList.contains(entry));
            for (Map.Entry<String, DynamicObjectCollection> d : newDbMap.entrySet()) {
                String entityName = d.getKey();
                MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
                ComboProp comboProp = (ComboProp)mainEntityType.getAllFields().get(EWBLXH);
                if (null == comboProp) continue;
                ArrayList amountFieldList = new ArrayList();
                for (Map.Entry entry3 : mainEntityType.getAllFields().entrySet()) {
                    if (!(entry3.getValue() instanceof DecimalProp)) continue;
                    amountFieldList.add(entry3.getKey());
                }
                HashMap ewblxhNameMap = new HashMap();
                comboProp.getComboItems().stream().forEach(row -> ewblxhNameMap.put(row.getValue(), row.getName().getLocaleValue()));
                Date skssqq = StringUtil.isEmpty((CharSequence)requestModel.getSkssqq()) ? null : DateUtils.stringToDate(requestModel.getSkssqq());
                Date skssqz = StringUtil.isEmpty((CharSequence)requestModel.getSkssqz()) ? null : DateUtils.stringToDate(requestModel.getSkssqz());
                LoginUtils.logger.info("=====================\u5148\u6839\u636e\u7ec4\u7ec7+\u6240\u5c5e\u671f\u5220\u9664\u5386\u53f2\u4e0b\u8f7d\u6570\u636e\uff0c\u518d\u63d2\u5165\u65b0\u6570\u636e===================");
                QFilter sbbidFilter = new QFilter(ORG, "=", (Object)requestModel.getOrgId());
                QFilter skssqqFilter = new QFilter(SKSSQQ, "=", (Object)skssqq);
                QFilter skssqzFilter = new QFilter(SKSSQZ, "=", (Object)skssqz);
                DeleteServiceHelper.delete((String)d.getKey(), (QFilter[])new QFilter[]{sbbidFilter, skssqqFilter, skssqzFilter});
                LoginUtils.logger.info("=====================\u5220\u9664\u5386\u53f2\u4e0b\u8f7d\u6570\u636e\u5b8c\u6bd5===================");
                LoginUtils.logger.info("=====================\u4e8c\u7ef4\u8868\u884c\u540d\u79f0\u8d4b\u503c\uff0c\u91d1\u989d\u8f6c\u6362\u5f00\u59cb===================");
                for (DynamicObject obj : d.getValue()) {
                    obj.set(EWBLNAME, ewblxhNameMap.get(obj.getString(EWBLXH)));
                    amountFieldList.stream().forEach(amountField -> obj.set(amountField, (Object)(null == obj.getBigDecimal(amountField) ? BigDecimal.ZERO : obj.getBigDecimal(amountField).multiply(BigDecimal.valueOf(10000L)))));
                    obj.set(ORG, (Object)requestModel.getOrgId());
                    obj.set(SKSSQQ, null == requestModel.getSkssqq() ? null : DateUtils.stringToDate(requestModel.getSkssqq()));
                    obj.set(SKSSQZ, null == requestModel.getSkssqz() ? null : DateUtils.stringToDate(requestModel.getSkssqz()));
                }
                LoginUtils.logger.info("=====================\u4e8c\u7ef4\u8868\u884c\u540d\u79f0\u8d4b\u503c\uff0c\u91d1\u989d\u8f6c\u6362\u7ed3\u675f===================");
            }
            LoginUtils.logger.info("=====================\u5148\u5220\u540e\u63d2\uff0c\u53ea\u7559\u7ec4\u7ec7+\u6240\u5c5e\u671f\u6700\u65b0\u7684\u4e00\u4efd===================");
            if (newDbMap.size() > 0) {
                DBSaveUtils.saveTable(newDbMap);
            }
            LoginUtils.logger.info("=====================\u4fdd\u5b58\u5b8c\u6bd5===================");
        }
    }
}

