/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.helper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.ObjectUtils;

public class DeclareCustomParamsHelper {
    public static Map<String, Object> buildCustomParams(DynamicObject nsrxx) {
        String entityName = nsrxx.getDynamicObjectType().getName();
        HashMap<String, Object> customParams = new HashMap<String, Object>(30);
        if (nsrxx != null) {
            DynamicObject object2;
            customParams.put("sbbid", nsrxx.getString("id"));
            customParams.put("billno", nsrxx.getString("billno"));
            DynamicObject org = nsrxx.getDynamicObject("org");
            customParams.put("orgid", org.getString("id"));
            customParams.put("taxorg", org.getString("id"));
            customParams.put("orgname", org.getString("name"));
            Date skssqq = nsrxx.getDate("skssqq");
            Date skssqz = nsrxx.getDate("skssqz");
            String type = DeclareCustomParamsHelper.isMultiTable(entityName) ? nsrxx.getDynamicObject("templatetype").getString("number") : nsrxx.getString("type");
            customParams.put("type", type);
            customParams.put("templatetype", type);
            customParams.put("taxPayerType", type);
            customParams.put("deadLine", "month".equals(nsrxx.getString("taxlimit")) ? "aysb" : "ajsb");
            String start = DateUtils.format(skssqq, "yyyy-MM-dd");
            String end = DateUtils.format(skssqz, "yyyy-MM-dd");
            customParams.put("skssqq", start);
            customParams.put("skssqz", end);
            customParams.put("taxlimit", DateUtils.getTaxLimit(skssqq, skssqz));
            customParams.put("taxperiod", start.substring(0, 7));
            customParams.put("readonly", Boolean.TRUE);
            customParams.put("from", "history");
            customParams.put("draftpurpose", "nssb");
            customParams.put("modifytime", nsrxx.getDate("modifytime"));
            String dataType = nsrxx.getString("datatype");
            customParams.put("datatype", dataType);
            DataEntityPropertyCollection properties = nsrxx.getDataEntityType().getProperties();
            if (properties.get((Object)"declaredate") != null) {
                customParams.put("declaredate", nsrxx.getDate("declaredate"));
            }
            if (properties.get((Object)"taxauthority") != null) {
                customParams.put("taxauthority", nsrxx.getLong("taxauthority.id"));
            }
            String taxLimit = nsrxx.getString("taxlimit");
            String reportType = DeclareCustomParamsHelper.getReportType(taxLimit);
            customParams.put("reporttype", reportType);
            customParams.put("isHyperLinkClick", "Y");
            if ("ccxws".equals(type) && (object2 = QueryServiceHelper.queryOne((String)"tcret_declare_main", (String)"id,declaredate,billno,taxauthority", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)nsrxx.getLong("id"))})) != null) {
                customParams.put("maindataid", object2.getLong("id"));
            }
            if ("zzsyjskb".equals(type)) {
                DeclareCustomParamsHelper.doSetZzsYjCustomParams(nsrxx.get("id"), customParams);
            }
            if ("dkdj".equals(type) || "kjqysds".equals(type)) {
                DeclareCustomParamsHelper.setDeclareRequestData(nsrxx, customParams, type);
            } else {
                DeclareCustomParamsHelper.setDeclareRequestData(nsrxx, customParams);
            }
        }
        return customParams;
    }

    private static void doSetZzsYjCustomParams(Object id, Map<String, Object> customParams) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tcvat_prepay_declare_bill");
        customParams.put("datasource", "hyperlink");
        customParams.put("orgid", object.getDynamicObject("accountorg").getString("id"));
        customParams.put("taxorg", object.getDynamicObject("org").getString("id"));
        customParams.put("sblx", "2");
        customParams.put("orgname", object.getDynamicObject("accountorg").getString("name"));
        customParams.put("declareserialno", object.getString("declareserialno"));
        customParams.put("projectid", object.getDynamicObject("prepayproject").getString("id"));
        Date skssqq = object.getDate("skssqq");
        Date skssqz = object.getDate("skssqz");
        customParams.put("templatetype", "zzsyjskb");
        String startDate = DateUtils.format(skssqq, "yyyy-MM-dd");
        customParams.put("skssqq", startDate);
        customParams.put("skssqz", DateUtils.format(skssqz, "yyyy-MM-dd"));
        customParams.put("readonly", Boolean.TRUE);
        DynamicObject application = QueryServiceHelper.queryOne((String)"tcvat_prepay_application", (String)"id", (QFilter[])new QFilter[]{new QFilter("declarenumber", "=", (Object)object.getString("declareserialno"))});
        customParams.put("applyid", ObjectUtils.isNotEmpty((Object)application) ? application.getString("id") : application);
    }

    public static void setDeclareRequestData(DynamicObject nsrxx, Map<String, Object> customParams, String type) {
        DeclareRequestModel requestModel = DeclareCustomParamsHelper.setDeclareRequestData(nsrxx, customParams);
        if (nsrxx != null) {
            String entityName = nsrxx.getDynamicObjectType().getName();
            requestModel.setModelId(DeclareCustomParamsHelper.isMultiTable(entityName) ? DeclareCustomParamsHelper.getModelId() : 0L);
            if ("declared".equals(nsrxx.getString("declarestatus"))) {
                requestModel.setTemplateId(null);
            }
        }
        customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
    }

    public static DeclareRequestModel setDeclareRequestData(DynamicObject nsrxx, Map<String, Object> customParams) {
        if (nsrxx != null) {
            String entityName = nsrxx.getDynamicObjectType().getName();
            DeclareRequestModel requestModel = new DeclareRequestModel();
            requestModel.setId(nsrxx.getLong("id"));
            requestModel.setTemplateId(DeclareCustomParamsHelper.isMultiTable(entityName) ? nsrxx.getDynamicObject("templateid").getLong("id") : nsrxx.getLong("templateid"));
            DynamicObject org = nsrxx.getDynamicObject("org");
            requestModel.setOrgId(org.getLong("id"));
            requestModel.setBillNo(nsrxx.getString("billno"));
            requestModel.setTemplateType(DeclareCustomParamsHelper.isMultiTable(entityName) ? nsrxx.getDynamicObject("templatetype").getString("number") : nsrxx.getString("type"));
            requestModel.setSkssqq(DateUtils.format(nsrxx.getDate("skssqq")));
            requestModel.setSkssqz(DateUtils.format(nsrxx.getDate("skssqz")));
            requestModel.setOperation("read");
            DynamicObjectType dynamicObjectType = nsrxx.getDynamicObjectType();
            HashMap<String, Object> extendParams = new HashMap<String, Object>();
            if (Objects.nonNull(dynamicObjectType.getProperty("declaredate"))) {
                String declaredate = DateUtils.format(nsrxx.getDate("declaredate"));
                requestModel.addBusinessValue("declaremonth", declaredate);
                extendParams.put("declaredate", declaredate);
            }
            if (Objects.nonNull(dynamicObjectType.getProperty("taxauthority")) && nsrxx.getDynamicObject("taxauthority") != null) {
                extendParams.put("taxauthority", nsrxx.getDynamicObject("taxauthority").getLong("id"));
            }
            requestModel.setExtendParams(extendParams);
            customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
            return requestModel;
        }
        return new DeclareRequestModel();
    }

    private static boolean isMultiTable(String entityName) {
        return "tpo_declare_main_tsc".equals(entityName) || "tpo_declare_main_tsd".equals(entityName);
    }

    private static String getReportType(String taxlimit) {
        if ("season".equals(taxlimit)) {
            return "ajsb";
        }
        if ("year".equals(taxlimit)) {
            return "ansb";
        }
        if ("month".equals(taxlimit)) {
            return "aysb";
        }
        return " ";
    }

    private static Long getModelId() {
        String modelNumber = "TSC001";
        QFilter qFilter = new QFilter("number", "=", (Object)modelNumber);
        DynamicObject d = BusinessDataServiceHelper.loadSingleFromCache((String)"tpo_model", (String)"id", (QFilter[])qFilter.toArray());
        if (d == null) {
            return 0L;
        }
        return d.getLong("id");
    }
}

