/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.helper;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.declare.helper.DeclareCustomParamsHelper;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;

public class DeclarePageOpenHelper {
    private static final Log logger = LogFactory.getLog(DeclarePageOpenHelper.class);

    public static void linkDeclarePageByPkId(IFormView view, Object pkId) {
        boolean exists = QueryServiceHelper.exists((String)"tcvat_nsrxx", (Object)pkId);
        if (!exists) {
            view.showTipNotification(ResManager.loadKDString((String)"\u7533\u62a5\u6570\u636e\u5df2\u5220\u9664\uff01", (String)"DeclarePageOpenHelper_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        DeclarePageOpenHelper.invoke(view, pkId);
    }

    public static void linkDeclarePageByBillNo(IFormView view, String billno) {
        QFilter q1 = new QFilter("billno", "=", (Object)billno);
        DynamicObject nsrxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{q1});
        if (nsrxx == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u7533\u62a5\u6570\u636e\u5df2\u5220\u9664\uff01", (String)"DeclarePageOpenHelper_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return;
        }
        DeclarePageOpenHelper.invoke(view, nsrxx.getLong("id"));
    }

    private static void invoke(IFormView view, Object pkId) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"tcvat_nsrxx");
        Map<String, Object> customParams = DeclareCustomParamsHelper.buildCustomParams(object);
        String declarestatus = object.getString("declarestatus");
        String type = object.getString("type");
        FormShowParameter param = new FormShowParameter();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType(type);
        String datatype = object.getString("datatype");
        String billstatus = object.getString("billstatus");
        if ("ccxws".equals(type)) {
            if ("declared".equals(declarestatus) || "2".equals(datatype)) {
                if ("2".equals(datatype) && "A".equals(billstatus)) {
                    param.setFormId("tcret_declare_import_edit");
                } else {
                    param.setFormId(templateEnum.getDeclareShowPage());
                    param.setCaption(TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
                }
            } else {
                param.setFormId(templateEnum.getDeclarePage());
            }
        } else if ("declared".equals(declarestatus)) {
            param.setFormId(templateEnum.getDeclareShowPage());
            param.setCaption(TemplateTypeConstant.getNsrtypemap().get(type) + DeclareConstant.getDeclaredDatdCn());
            DeclareCustomParamsHelper.setDeclareRequestData(object, customParams);
        } else {
            param.setFormId(templateEnum.getDeclarePage());
        }
        logger.info("open declare page custom params: " + customParams);
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm(param);
    }
}

