/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.initparam;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.taxc.bdtaxr.common.declare.initparam.InitParams;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DefaultInitParams
implements InitParams {
    public static final String ORGID = "orgid";
    public static final String STARTDATE = "startDate";
    public static final String ENDDATE = "endDate";
    public static final String PRESTART_DATE = "prestartDate";
    public static final String PREEND_DATE = "preendDate";
    private static final String TAXLIMIT = "taxlimit";
    private static final String TAXPERIOD = "taxperiod";
    public static final String YEAR = "year";
    public static final String MOTH = "moth";
    public static final String MONTH = "month";

    @Override
    public Map<String, String> buildBizParam(DeclareRequestModel requestModel) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(ORGID, String.valueOf(requestModel.getOrgId()));
        param.put("orgId", String.valueOf(requestModel.getOrgId()));
        param.put(STARTDATE, requestModel.getSkssqq());
        param.put("startdate", requestModel.getSkssqq());
        param.put(ENDDATE, requestModel.getSkssqz());
        param.put("enddate", requestModel.getSkssqz());
        param.put("skssqq", requestModel.getSkssqq());
        param.put("skssqz", requestModel.getSkssqz());
        param.put(YEAR, requestModel.getSkssqq().substring(0, 4));
        param.put("startmonth", requestModel.getSkssqq().substring(5, 7));
        param.put("endmonth", requestModel.getSkssqz().substring(5, 7));
        String taxLimit = DateUtils.getTaxLimit(DateUtils.stringToDate(requestModel.getSkssqq()), DateUtils.stringToDate(requestModel.getSkssqz()));
        param.put(TAXLIMIT, taxLimit);
        String taxperiod = DateUtils.format(DateUtils.stringToDate(requestModel.getSkssqq()), "yyyy-MM");
        param.put(TAXPERIOD, taxperiod);
        param.put(MOTH, taxperiod.split("-")[1]);
        param.put(MONTH, taxperiod.split("-")[1]);
        List<Date> dates = DateUtils.getPreDate(DateUtils.stringToDate(requestModel.getSkssqq()), DateUtils.stringToDate(requestModel.getSkssqz()));
        param.put(PRESTART_DATE, DateUtils.format(dates.get(0)));
        param.put(PREEND_DATE, DateUtils.format(dates.get(1)));
        return param;
    }
}

