/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.initparam;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.initparam.DefaultInitParams;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineBusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TcvatNcpInitParams
extends DefaultInitParams {
    private static final String PRESBBID = "presbbid";

    @Override
    public Map<String, String> buildBizParam(DeclareRequestModel requestModel) {
        Map<String, String> param = super.buildBizParam(requestModel);
        Map<String, String> bizParam = this.setBizParam(requestModel);
        param.putAll(bizParam);
        return param;
    }

    public Map<String, String> setBizParam(DeclareRequestModel requestModel) {
        TaxResult taxResult;
        Long supertaxoffice;
        HashMap<String, String> param = new HashMap<String, String>(16);
        param.put("hyncpmcid", null == requestModel.getBusinessValue("hyncpmcid") ? "0" : requestModel.getBusinessValue("hyncpmcid"));
        param.put("draftpurpose", requestModel.getBusinessValue("draftpurpose"));
        param.put(PRESBBID, "0");
        param.put("supertaxoffice", "0");
        DynamicObject preDraftObject = this.queryPreDraft(requestModel);
        if (null != preDraftObject) {
            param.put(PRESBBID, preDraftObject.getString("id"));
        }
        if (null != (supertaxoffice = (Long)(taxResult = TaxcCombineBusinessDataServiceHelper.queryTopTaxauthorityByOrgId((Long)requestModel.getOrgId())).getData())) {
            param.put("supertaxoffice", supertaxoffice.toString());
        }
        return param;
    }

    private DynamicObject queryPreDraft(DeclareRequestModel requestModel) {
        Date skssqq = DateUtils.getFirstDateOfMonth(DateUtils.addMonth(DateUtils.stringToDate(requestModel.getSkssqq()), -1));
        Date skssqz = DateUtils.getLastDateOfMonth(DateUtils.addMonth(DateUtils.stringToDate(requestModel.getSkssqz()), -1));
        Long orgid = requestModel.getOrgId();
        String templatetype = requestModel.getTemplateType();
        String hyncpmcid = null == requestModel.getBusinessValue("hyncpmcid") ? "0" : requestModel.getBusinessValue("hyncpmcid");
        String draftpurpose = requestModel.getBusinessValue("draftpurpose");
        QFilter filter = new QFilter("org", "=", (Object)orgid).and(new QFilter("skssqq", ">=", (Object)skssqq)).and(new QFilter("skssqz", "<=", (Object)skssqz)).and(new QFilter("templatetype", "=", (Object)templatetype)).and(new QFilter("hyncpmcid", "=", (Object)Long.valueOf(hyncpmcid))).and(new QFilter("draftpurpose", "=", (Object)draftpurpose));
        return QueryServiceHelper.queryOne((String)"tcvat_ncp_draft_main", (String)"id", (QFilter[])new QFilter[]{filter});
    }
}

