/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.initparam;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.initparam.DefaultInitParams;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import org.apache.commons.lang3.StringUtils;

public class TcvatTzInitParams
extends DefaultInitParams {
    private static final String SBBID = "sbbid";
    private static final String YEARSBBID = "lastyearsbbid";

    @Override
    public Map<String, String> buildBizParam(DeclareRequestModel requestModel) {
        Map<String, String> param = super.buildBizParam(requestModel);
        Map<String, String> bizParam = this.setBizParam(requestModel.getBusinessMap(), String.valueOf(requestModel.getId()), requestModel.getTemplateType(), String.valueOf(requestModel.getOrgId()), requestModel.getSkssqq(), requestModel.getSkssqz());
        param.putAll(bizParam);
        return param;
    }

    public Map<String, String> setBizParam(Map<String, String> bizParams, String id, String type, String orgId, String startDate, String endDate) {
        String yearsbbid;
        HashMap<String, String> bizParam = new HashMap<String, String>(32);
        String sbbid = bizParams.get(SBBID);
        if (StringUtils.isBlank((CharSequence)sbbid)) {
            sbbid = YbnsrService.queryYbnsrPre(orgId, type, startDate, endDate);
        }
        if (StringUtils.isBlank((CharSequence)(yearsbbid = bizParams.get(YEARSBBID)))) {
            yearsbbid = YbnsrService.queryYbnsrPreYear(orgId, type, startDate, endDate);
        }
        bizParam.put("taxpayertype", bizParams.get("taxPayerType"));
        bizParam.put(SBBID, sbbid);
        bizParam.put("currentSbbid", id);
        bizParam.put(YEARSBBID, yearsbbid);
        bizParam.put("prestartDate", DateUtils.format(DateUtils.addMonth(DateUtils.stringToDate(startDate), -1)));
        bizParam.put("preendDate", DateUtils.format(DateUtils.getLastDateOfMonth(DateUtils.getLastDateOfMonth(DateUtils.addMonth(DateUtils.stringToDate(endDate), -1)))));
        bizParam.put("month", String.valueOf(DateUtils.getMonthOfDate(DateUtils.stringToDate(startDate))));
        bizParam.put("endMonth", String.valueOf(DateUtils.getMonthOfDate(DateUtils.stringToDate(endDate))));
        Boolean wkpsrNegative = (Boolean)SystemParamUtil.getAppParameter("tcvat", "negativedeclare", Long.parseLong(orgId));
        bizParam.put("wkpsrNegative", Boolean.TRUE.equals(wkpsrNegative) ? "1" : "0");
        this.getOrgParams(orgId, startDate, endDate, bizParam);
        bizParam.put("startDate", startDate);
        bizParam.put("endDate", endDate);
        this.setNsrsbh(orgId, bizParam);
        return bizParam;
    }

    private void getOrgParams(String orgId, String startData, String endData, Map<String, String> param) {
        int i;
        QFilter declarationFilter;
        QFilter endFilter;
        QFilter startFilter;
        QFilter orgIdFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        DynamicObjectCollection orgList = QueryServiceHelper.query((String)"tcvat_ybhz_zlb_jgfpb", (String)"suborg", (QFilter[])new QFilter[]{orgIdFilter, startFilter = new QFilter("startdate", "=", (Object)DateUtils.stringToDate(startData)), endFilter = new QFilter("enddate", "=", (Object)DateUtils.stringToDate(endData)), declarationFilter = new QFilter("declaration", "=", (Object)"3")}, (String)"seqx");
        if (EmptyCheckUtils.isNotEmpty(orgList)) {
            for (i = 0; i < orgList.size(); ++i) {
                if (null == orgList.get(i) || ((DynamicObject)orgList.get(i)).get("suborg") == null) continue;
                QFilter orgFilter = new QFilter("org", "=", ((DynamicObject)orgList.get(i)).get("suborg"));
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"unifiedsocialcode, taxpayer", (QFilter[])new QFilter[]{orgFilter});
                param.put("unifiedsocialcode" + i, dynamicObject.getString("unifiedsocialcode"));
                param.put("taxpayer" + i, dynamicObject.getString("taxpayer"));
            }
        }
        for (i = orgList.size(); i < 10; ++i) {
            param.put("unifiedsocialcode" + i, "");
            param.put("taxpayer" + i, "");
        }
    }

    private void setNsrsbh(String orgId, Map<String, String> param) {
        QFilter orgIdFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"unifiedsocialcode", (QFilter[])new QFilter[]{orgIdFilter});
        if (dynamicObject != null) {
            param.put("nsrsbh", dynamicObject.getString("unifiedsocialcode"));
        }
    }
}

