/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.listener.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.declare.handler.IDeclareHandler;
import kd.taxc.bdtaxr.common.declare.listener.IControlListener;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;

public class OrgListener
implements IControlListener {
    private static final String ORG_SEL = "org";

    public boolean checkOrg(IFormView view, IPageCache pageCache, IDataModel model, Long orgId, String appId, String categoryType) {
        return OrgCheckUtil.check(view, String.valueOf(orgId), appId, categoryType);
    }

    @Override
    public boolean checkControlValue(IFormView view, IPageCache pageCache, IDataModel model) {
        if (pageCache.get("orgid") == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"OrgListener_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs args, IDeclareHandler handler, IFormView view, IPageCache pageCache, IDataModel model) {
        if (ORG_SEL.equals(args.getProperty().getName())) {
            Object newValue = args.getChangeSet()[0].getNewValue();
            DynamicObject newOrg = (DynamicObject)newValue;
            if (null == newOrg) {
                pageCache.remove("orgid");
                return;
            }
            String orgid = newOrg.getString("id");
            String appId = view.getFormShowParameter().getAppId();
            TaxAppEnum licenseTaxEnum = TaxAppEnum.getEnumInstanceByAppid(appId);
            boolean check = this.checkOrg(view, pageCache, model, Long.valueOf(orgid), appId, licenseTaxEnum != null ? licenseTaxEnum.getCategoryCode() : null);
            if (check) {
                model.setValue(ORG_SEL, (Object)pageCache.get("orgid"));
                return;
            }
            if (!orgid.equals(pageCache.get("orgid"))) {
                pageCache.put("orgChangedSuccess", "true");
            }
            pageCache.put("orgid", orgid);
            this.afterPropertyChanged(args, handler, view, pageCache, model);
        }
    }
}

