/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.declare.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.BooleanEnum;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.declare.handler.NsrDeclareHandler;
import kd.taxc.bdtaxr.common.declare.handler.NsrDeclareServiceFactory;
import kd.taxc.bdtaxr.common.declare.helper.TemplateFormulaServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DeclareService {
    private static Log LOGGER = LogFactory.getLog(DeclareService.class);
    public static final int ONLY_RISK = 1;
    public static final int ALL_RISK = 2;

    public Long getTemplateId(DeclareRequestModel declareModel) {
        String zerodeclare = declareModel.getBusinessMap().get("zerodeclare");
        if ("1".equals(zerodeclare)) {
            return (Long)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"TemplateService", (String)"getZeroDeclareTemplateId", (Object[])new Object[]{declareModel.getTemplateType(), String.valueOf(declareModel.getOrgId()), DateUtils.stringToDate(declareModel.getSkssqq(), "yyyy-MM-dd"), DateUtils.stringToDate(declareModel.getSkssqz(), "yyyy-MM-dd")});
        }
        return (Long)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"TemplateService", (String)"getTemplateId", (Object[])new Object[]{declareModel.getTemplateType(), String.valueOf(declareModel.getOrgId()), DateUtils.stringToDate(declareModel.getSkssqq(), "yyyy-MM-dd"), DateUtils.stringToDate(declareModel.getSkssqz(), "yyyy-MM-dd")});
    }

    public Map<String, String> createYbnsr(DeclareRequestModel declareModel, boolean isCreate) {
        NsrDeclareHandler handler = NsrDeclareServiceFactory.create(declareModel.getTemplateId());
        Map<String, String> map = handler.createDeclareMain(String.valueOf(declareModel.getId()), declareModel.getBillNo(), declareModel.getTemplateType(), String.valueOf(declareModel.getOrgId()), declareModel.getSkssqq(), declareModel.getSkssqz(), isCreate, declareModel.getExtendParams(), declareModel.getTemplateId());
        return map;
    }

    public boolean checkTable(Map<String, String> metadataMap, String s) {
        if (null != metadataMap) {
            for (String tableName : metadataMap.keySet()) {
                if (!s.startsWith(tableName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDelKey(List<DynamicRowModel> list, String key) {
        for (DynamicRowModel rowModel : list) {
            String dynRowNo = rowModel.getDynRowNo();
            List<Map<String, String>> rowList = rowModel.getRowList();
            if (!key.startsWith(dynRowNo) || !CollectionUtils.isEmpty(rowList) && rowList.size() != 0) continue;
            return true;
        }
        return false;
    }

    public boolean saveRiskItem(String sbbId, List<Map<String, String>> checkResultList, List<Map<String, String>> riskResultList, int saveType) {
        LOGGER.info("\u4fdd\u5b58\u98ce\u9669\u4e8b\u9879\u7684sbbid\uff1a{}", (Object)sbbId);
        if (StringUtils.isNotEmpty((CharSequence)sbbId) && !"0".equals(sbbId)) {
            Long sbbid = Long.valueOf(sbbId);
            DynamicObjectCollection collection = new DynamicObjectCollection();
            if (EmptyCheckUtils.isNotEmpty(checkResultList) || EmptyCheckUtils.isNotEmpty(riskResultList)) {
                DynamicObject dynamicObject;
                if (saveType == 2 && EmptyCheckUtils.isNotEmpty(checkResultList)) {
                    for (Map<String, String> map : checkResultList) {
                        dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdtaxr_declare_risk"));
                        dynamicObject.set("sbbid", (Object)sbbid);
                        dynamicObject.set("itemtype", (Object)"1");
                        dynamicObject.set("itemname", (Object)map.get("title"));
                        dynamicObject.set("riskdesc", (Object)map.get("content"));
                        collection.add((Object)dynamicObject);
                    }
                }
                if (EmptyCheckUtils.isNotEmpty(riskResultList)) {
                    for (Map<String, String> map : riskResultList) {
                        dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bdtaxr_declare_risk"));
                        dynamicObject.set("sbbid", (Object)sbbid);
                        dynamicObject.set("itemtype", (Object)"2");
                        dynamicObject.set("riskresolveid", (Object)map.get("id"));
                        dynamicObject.set("itemname", (Object)map.get("tctrcriskname"));
                        dynamicObject.set("riskdesc", (Object)map.get("tctrcriskdesc"));
                        collection.add((Object)dynamicObject);
                    }
                }
            }
            try (TXHandle h = TX.required();){
                try {
                    LOGGER.info("\u66f4\u65b0\u98ce\u9669\u5f02\u5e38\u72b6\u6001\u7684sbbid\uff1a{}", (Object)sbbId);
                    QFilter qfilter = new QFilter("id", "=", (Object)sbbid);
                    DynamicObject nsrxx = BusinessDataServiceHelper.loadSingle((String)"tcvat_nsrxx", (String)DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING, (QFilter[])new QFilter[]{qfilter});
                    if (null != nsrxx) {
                        String riskcontent;
                        boolean exists;
                        String curruntRisksContent;
                        String riskstatus;
                        QFilter qFilter = new QFilter("sbbid", "=", (Object)sbbid);
                        if (saveType == 1) {
                            qFilter.and("itemtype", "=", (Object)"2");
                        }
                        DeleteServiceHelper.delete((String)"bdtaxr_declare_risk", (QFilter[])qFilter.toArray());
                        if (collection.size() > 0) {
                            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])collection.toArray((Object[])new DynamicObject[collection.size()])));
                        }
                        boolean isUpdate = false;
                        String curruntRiskstatus = checkResultList == null || checkResultList.size() == 0 ? "0" : "1";
                        if (!curruntRiskstatus.equals(riskstatus = nsrxx.getString("riskstatus"))) {
                            nsrxx.set("riskstatus", (Object)curruntRiskstatus);
                            isUpdate = true;
                        }
                        if (!(curruntRisksContent = (exists = QueryServiceHelper.exists((String)"bdtaxr_declare_risk", (QFilter[])new QFilter("sbbid", "=", (Object)sbbid).toArray())) ? "abnormal" : "normal").equals(riskcontent = nsrxx.getString("riskcontent"))) {
                            nsrxx.set("riskcontent", (Object)curruntRisksContent);
                            isUpdate = true;
                        }
                        if (isUpdate) {
                            SaveServiceHelper.update((DynamicObject)nsrxx);
                        }
                    }
                }
                catch (Throwable t) {
                    h.markRollback();
                    LOGGER.error("\u4fdd\u5b58\u98ce\u9669\u4e8b\u9879\u5355\u5f02\u5e38\u7684sbbid\uff1a" + sbbId, t);
                    boolean bl = false;
                    if (h != null) {
                        if (var8_8 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                var8_8.addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                    return bl;
                }
            }
        }
        return true;
    }

    public void deleteRiskItem(Set<Object> sbbIds) {
        if (EmptyCheckUtils.isNotEmpty(sbbIds)) {
            QFilter qFilter = new QFilter("sbbid", "in", sbbIds);
            DeleteServiceHelper.delete((String)"bdtaxr_declare_risk", (QFilter[])qFilter.toArray());
        }
    }

    public DeclareRequestModel getRequestModel(String orgId, String type, String skssqq, String skssqz, long templateId) {
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setOrgId(Long.parseLong(orgId));
        requestModel.setTemplateType(type);
        requestModel.setSkssqq(skssqq);
        requestModel.setSkssqz(skssqz);
        requestModel.setTemplateId(templateId);
        Map<String, String> metaDataListByTmpId = TemplateFormulaServiceHelper.getMetaDataListByTmpId(templateId);
        requestModel.setMetaDataMap(metaDataListByTmpId);
        return requestModel;
    }

    public DeclareRequestModel getRequestModelMulti(String orgId, String type, String skssqq, String skssqz, long templateId) {
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setOrgId(Long.parseLong(orgId));
        requestModel.setTemplateType(type);
        requestModel.setSkssqq(skssqq);
        requestModel.setSkssqz(skssqz);
        requestModel.setTemplateId(templateId);
        return requestModel;
    }

    public List<Map<String, String>> queryTctrcResult(String org, String templateType, String skssqq, String skssqz) {
        boolean isnothaslicense = LicenseCheckServiceHelper.check(org, null, "tctrc");
        List<Map<String, String>> tctrcResultMapList = new ArrayList<Map<String, String>>();
        if (!isnothaslicense) {
            tctrcResultMapList = this.queryTctrcResultMapList(org, templateType, skssqq, skssqz);
        }
        return tctrcResultMapList;
    }

    private List<Map<String, String>> queryTctrcResultMapList(String org, String templateType, String skssqq, String skssqz) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>(10);
        String templateTypeId = this.queryTemplateTypeIdByNumber(templateType);
        QFilter qFilter = new QFilter("risk.sbbtype.fbasedataid", "=", (Object)templateTypeId);
        QFilter qFilter6 = new QFilter("risk.issbshow", "=", (Object)BooleanEnum.YES.getCode());
        QFilter qFilter1 = new QFilter("startdate", ">=", (Object)DateUtils.getFirstDateOfMonth(DateUtils.stringToDate(skssqq)));
        QFilter qFilter2 = new QFilter("enddate", "<=", (Object)DateUtils.getLastDateOfMonth(DateUtils.stringToDate(skssqz)));
        QFilter qFilter3 = new QFilter("rlevel.id", "in", Arrays.asList(1, 2, 3));
        QFilter qFilter4 = new QFilter("status", "in", Arrays.asList("0", "2"));
        qFilter4.or(new QFilter("status", "=", (Object)"1").and(new QFilter("dealresult", "=", (Object)"3")));
        QFilter qFilter5 = new QFilter("runorg.id", "=", (Object)Long.parseLong(org));
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tctrc_handle_list", (String)"id,risk.name,risk.number,riskdesc", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, qFilter3, qFilter4, qFilter5, qFilter6});
        if (EmptyCheckUtils.isEmpty(dynamicObjects)) {
            return resultList;
        }
        return Arrays.stream(dynamicObjects).map(DeclareService::createTctrcMap).collect(Collectors.toList());
    }

    private String queryTemplateTypeIdByNumber(String templateType) {
        QFilter qFilter = new QFilter("number", "=", (Object)templateType);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"tpo_template_type", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (EmptyCheckUtils.isEmpty(dynamicObjects)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u7f16\u7801%s\u67e5\u8be2tctb_template_type\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (String)"TaxDeclarePlugin_25", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), templateType));
        }
        if (dynamicObjects.length != 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6839\u636e\u7f16\u7801%s\u67e5\u8be2tctb_template_type\u67e5\u8be2\u5230\u591a\u6761\u8bb0\u5f55", (String)"TaxDeclarePlugin_26", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), templateType));
        }
        return dynamicObjects[0].getString("id");
    }

    private static Map<String, String> createTctrcMap(DynamicObject dynamicObject) {
        HashMap<String, String> tctrcMap = new HashMap<String, String>(16);
        tctrcMap.put("id", dynamicObject.getString("id"));
        tctrcMap.put("tctrcriskname", String.format(ResManager.loadKDString((String)"%s\u5f02\u5e38", (String)"TaxDeclarePlugin_27", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), dynamicObject.getString("risk.name")));
        tctrcMap.put("tctrcriskdesc", dynamicObject.getString("riskdesc"));
        return tctrcMap;
    }
}

