/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.draft.engine.handler;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.draft.engine.context.DraftEngineContext;
import kd.taxc.bdtaxr.common.draft.engine.handler.DraftEngineHandler;
import kd.taxc.bdtaxr.common.draft.engine.service.DraftEngine;
import kd.taxc.bdtaxr.common.draft.engine.service.DraftEngineContextConfig;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;

public abstract class AbstractDraftEngineHandler
implements DraftEngineHandler,
DraftEngineContextConfig {
    public static final Log LOGGER = LogFactory.getLog(AbstractDraftEngineHandler.class);
    List<DraftEngine> draftEngines;

    @Override
    public void run(EngineModel engineModel) {
        RequestContext mainRc = RequestContext.get();
        long start = System.currentTimeMillis();
        LOGGER.info("{0}|strat run engines|{1}", (Object)mainRc.getTraceId(), (Object)SerializationUtils.toJsonString((Object)engineModel));
        this.init();
        this.sort();
        try {
            this.work(engineModel, mainRc);
        }
        catch (Exception e) {
            LOGGER.error("{0}|engines run fail|{1}", (Object)mainRc.getTraceId(), (Object)e);
        }
        this.persist(mainRc);
        long end = System.currentTimeMillis();
        LOGGER.info("{0}|engines run success|cost:{1}", (Object)mainRc.getTraceId(), (Object)(end - start));
    }

    @Override
    public void deleteAllDraft(EngineModel engineModel) {
        RequestContext mainRc = RequestContext.get();
        long start = System.currentTimeMillis();
        LOGGER.info("{0}|strat deleteAllDraft engines|{1}", (Object)mainRc.getTraceId(), (Object)SerializationUtils.toJsonString((Object)engineModel));
        this.init();
        this.preWorkBeforeDel(engineModel);
        this.doDel(this.getDraftEngineContext().getDelDataMap());
        long end = System.currentTimeMillis();
        LOGGER.info("{0}|engines deleteAllDraft success|cost:{1}", (Object)mainRc.getTraceId(), (Object)(end - start));
    }

    private void persist(RequestContext mainRc) {
        try (TXHandle h = TX.requiresNew();){
            DraftEngineContext draftEngineContext = this.getDraftEngineContext();
            if (draftEngineContext == null) {
                return;
            }
            try {
                this.doPersist(draftEngineContext);
            }
            catch (Exception t) {
                h.markRollback();
                LOGGER.error("{0}|engines persist fail|{1}", (Object)mainRc.getTraceId(), (Object)t);
                throw t;
            }
        }
    }

    public abstract void work(EngineModel var1, RequestContext var2) throws Exception;

    private void preWorkBeforeDel(EngineModel model) {
        this.draftEngines.forEach(e -> e.preWorkBeforeDelDraft(model));
    }

    public abstract void init();

    public abstract void sort();

    @Override
    public DraftEngineContext getDraftEngineContext() {
        if (CollectionUtils.isEmpty(this.draftEngines)) {
            return null;
        }
        return this.draftEngines.get(0).getDraftEngineContext();
    }

    private void doPersist(DraftEngineContext draftEngineContext) {
        this.doDel(draftEngineContext.getDelDataMap());
        this.doSaveAccount(draftEngineContext.getAccountDataMap());
        this.doSaveSummary(draftEngineContext.getSummaryDataMap());
    }

    private void doSaveSummary(Map<String, List<DynamicObject>> summaryDataMap) {
        if (CollectionUtils.isEmpty(summaryDataMap)) {
            return;
        }
        summaryDataMap.values().forEach(list -> SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0])));
    }

    private void doSaveAccount(Map<String, List<DynamicObject>> accountDataMap) {
        if (CollectionUtils.isEmpty(accountDataMap)) {
            return;
        }
        accountDataMap.values().forEach(list -> SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0])));
    }

    private void doDel(Map<String, Map<String, QFilter[]>> delDataMap) {
        if (CollectionUtils.isEmpty(delDataMap)) {
            return;
        }
        delDataMap.values().forEach(map -> map.forEach(DeleteServiceHelper::delete));
    }

    public List<DraftEngine> getDraftEngines() {
        return this.draftEngines;
    }

    public void setDraftEngines(List<DraftEngine> draftEngines) {
        this.draftEngines = draftEngines;
    }
}

