/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.enums;

import kd.taxc.bdtaxr.common.enums.EnumUtils;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;

public enum CalendarTaxType {
    ZZS("zzs", "1", new MultiLangEnumBridge("\u589e\u503c\u7a0e", "CalendarTaxType_0", "taxc-bdtaxr-common"), "/RFP+MBMR+I6"),
    QYSDS("qysds", "2", new MultiLangEnumBridge("\u4f01\u4e1a\u6240\u5f97\u7a0e", "CalendarTaxType_1", "taxc-bdtaxr-common"), "/Z0U6BXKR4Y+"),
    YHS("yhs", "3", new MultiLangEnumBridge("\u5370\u82b1\u7a0e", "CalendarTaxType_2", "taxc-bdtaxr-common"), "0O65K4HJ9WA2"),
    FCS("fcs", "4", new MultiLangEnumBridge("\u623f\u4ea7\u7a0e", "CalendarTaxType_3", "taxc-bdtaxr-common"), null),
    FJSF("fjsf", "5", new MultiLangEnumBridge("\u9644\u52a0\u7a0e\u8d39", "CalendarTaxType_4", "taxc-bdtaxr-common"), null),
    CSWHJSS("cswhjss", "5", new MultiLangEnumBridge("\u57ce\u5e02\u7ef4\u62a4\u5efa\u8bbe\u7a0e", "CalendarTaxType_5", "taxc-bdtaxr-common"), null),
    JYFFJ("jyffj", "5", new MultiLangEnumBridge("\u6559\u80b2\u8d39\u9644\u52a0", "CalendarTaxType_6", "taxc-bdtaxr-common"), null),
    DFJYFJ("dfjyfj", "5", new MultiLangEnumBridge("\u5730\u65b9\u6559\u80b2\u9644\u52a0", "CalendarTaxType_7", "taxc-bdtaxr-common"), null),
    CZTDSYS("cztdsys", "6", new MultiLangEnumBridge("\u57ce\u9547\u571f\u5730\u4f7f\u7528\u7a0e", "CalendarTaxType_8", "taxc-bdtaxr-common"), null),
    HBS("hbs", "7", new MultiLangEnumBridge("\u73af\u5883\u4fdd\u62a4\u7a0e", "CalendarTaxType_9", "taxc-bdtaxr-common"), null),
    XFS("xfs", "8", new MultiLangEnumBridge("\u6d88\u8d39\u7a0e", "CalendarTaxType_10", "taxc-bdtaxr-common"), "0WN4LZ29HLGY"),
    ZYS("zys", "9", new MultiLangEnumBridge("\u8d44\u6e90\u7a0e", "CalendarTaxType_11", "taxc-bdtaxr-common"), null),
    SZYS("szys", "9", new MultiLangEnumBridge("\u6c34\u8d44\u6e90\u7a0e", "CalendarTaxType_12", "taxc-bdtaxr-common"), "tcret"),
    CCS("ccs", "", new MultiLangEnumBridge("\u8f66\u8239\u7a0e", "CalendarTaxType_13", "taxc-bdtaxr-common"), null),
    QS("qs", "", new MultiLangEnumBridge("\u5951\u7a0e", "CalendarTaxType_14", "taxc-bdtaxr-common"), null),
    CLGZS("tvpt", "", new MultiLangEnumBridge("\u8f66\u8f86\u8d2d\u7f6e\u7a0e", "CalendarTaxType_15", "taxc-bdtaxr-common"), null),
    GDZYS("gdzys", "", new MultiLangEnumBridge("\u8015\u5730\u5360\u7528\u7a0e", "CalendarTaxType_16", "taxc-bdtaxr-common"), null),
    TDZZS("tdzzs", "", new MultiLangEnumBridge("\u571f\u5730\u589e\u503c\u7a0e", "CalendarTaxType_17", "taxc-bdtaxr-common"), null),
    YYS("yys", "1", new MultiLangEnumBridge("\u70df\u53f6\u7a0e", "CalendarTaxType_18", "taxc-bdtaxr-common"), null),
    CCXWS("ccxws", "", new MultiLangEnumBridge("\u8d22\u4ea7\u548c\u884c\u4e3a\u7a0e", "CalendarTaxType_19", "taxc-bdtaxr-common"), "0O65K4HJ9WA2"),
    QTSF("qtsf", "", new MultiLangEnumBridge("\u5176\u4ed6\u7a0e\u8d39", "CalendarTaxType_20", "taxc-bdtaxr-common"), "11E2+SDXXKJA"),
    TOTF_CJRJYBZJ("totf_cjrjybzj", "", new MultiLangEnumBridge("\u5176\u4ed6\u7a0e\u8d39", "CalendarTaxType_20", "taxc-bdtaxr-common"), "11E2+SDXXKJA"),
    SDSJT("sdsjt", "", new MultiLangEnumBridge("\u6240\u5f97\u7a0e\u8ba1\u63d0", "CalendarTaxType_21", "taxc-bdtaxr-common"), "2F5P9DV76BOR"),
    SDSJT_JT("sdsjt_jt", "", new MultiLangEnumBridge("\u6240\u5f97\u7a0e\u8ba1\u63d0", "CalendarTaxType_21", "taxc-bdtaxr-common"), "2F5P9DV76BOR"),
    SDSJT_BD("sdsjt_bd", "", new MultiLangEnumBridge("\u6240\u5f97\u7a0e\u8ba1\u63d0", "CalendarTaxType_21", "taxc-bdtaxr-common"), "2F5P9DV76BOR"),
    OVERSEAS_VAT("Overseas_VAT", "", new MultiLangEnumBridge("\u5168\u7403\u7a0e\u52a1\u7533\u62a5", "CalendarTaxType_22", "taxc-bdtaxr-common"), "19KIWPPM7UT="),
    OVERSEAS_CIT("Overseas_CIT", "", new MultiLangEnumBridge("\u5168\u7403\u7a0e\u52a1\u7533\u62a5", "CalendarTaxType_22", "taxc-bdtaxr-common"), "19KIWPPM7UT="),
    USA_CIT("USA_CIT", "", new MultiLangEnumBridge("\u5168\u7403\u7a0e\u52a1\u7533\u62a5", "CalendarTaxType_22", "taxc-bdtaxr-common"), "19KIWPPM7UT="),
    OVERSEAS_VAT_RTA("Overseas_VAT_RTA", "", new MultiLangEnumBridge("\u5168\u7403\u7a0e\u52a1\u7533\u62a5", "CalendarTaxType_22", "taxc-bdtaxr-common"), "19KIWPPM7UT="),
    OVERSEAS_CIT_RTA("Overseas_CIT_RTA", "", new MultiLangEnumBridge("\u5168\u7403\u7a0e\u52a1\u7533\u62a5", "CalendarTaxType_22", "taxc-bdtaxr-common"), "19KIWPPM7UT="),
    USA_CIT_RTA("USA_CIT_RTA", "", new MultiLangEnumBridge("\u5168\u7403\u7a0e\u52a1\u7533\u62a5", "CalendarTaxType_22", "taxc-bdtaxr-common"), "19KIWPPM7UT="),
    RDESD_YHMX("rdesd_yhmx", "", new MultiLangEnumBridge("\u7814\u53d1\u52a0\u8ba1\u4e0e\u9ad8\u65b0\u8ba4\u5b9a", "CalendarTaxType_23", "taxc-bdtaxr-common"), "2F5FKOFUC2JQ"),
    RDESD_GXQYYHMX("rdesd_gxqyyhmx", "", new MultiLangEnumBridge("\u7814\u53d1\u52a0\u8ba1\u4e0e\u9ad8\u65b0\u8ba4\u5b9a", "CalendarTaxType_23", "taxc-bdtaxr-common"), "2F5FKOFUC2JQ"),
    RDESD_HNTE_FZZHZ("hnte_fzzhz", "", new MultiLangEnumBridge("\u7814\u53d1\u52a0\u8ba1\u4e0e\u9ad8\u65b0\u8ba4\u5b9a", "CalendarTaxType_23", "taxc-bdtaxr-common"), "2F5FKOFUC2JQ"),
    JTYSBBD_BD("jtysbbd_bd", "", new MultiLangEnumBridge("\u6240\u5f97\u7a0e\u8ba1\u63d0", "CalendarTaxType_21", "taxc-bdtaxr-common"), "2F5P9DV76BOR"),
    SJTYSBBD_JT("jtysbbd_jt", "", new MultiLangEnumBridge("\u6240\u5f97\u7a0e\u8ba1\u63d0", "CalendarTaxType_21", "taxc-bdtaxr-common"), "2F5P9DV76BOR"),
    TCVAT_TAXREFUND("tcvat_taxrefund", "", new MultiLangEnumBridge("\u9000\uff08\u62b5\uff09\u7a0e\u7533\u8bf7\u8868", "CalendarTaxType_24", "taxc-bdtaxr-common"), "2F5P9DV76BOR"),
    JZJT_TSJSDG("jzjt_tsjsdg", "", new MultiLangEnumBridge("\u9000\u7a0e\u8ba1\u7b97\u5e95\u7a3f", "CalendarTaxType_25", "taxc-bdtaxr-common"), "/RFP+MBMR+I6"),
    JZJT_TSSQB("jzjt_tssqb", "", new MultiLangEnumBridge("\u9000\u7a0e\u7533\u8bf7\u8868", "CalendarTaxType_26", "taxc-bdtaxr-common"), "/RFP+MBMR+I6"),
    DKDJ("dkdj", "", new MultiLangEnumBridge("\u975e\u8d38\u4ed8\u6c47\u7a0e\u52a1\u7ba1\u7406", "CalendarTaxType_27", "taxc-bdtaxr-common"), "2BOW55M9U7TH"),
    KJQYSDS("kjqysds", "", new MultiLangEnumBridge("\u975e\u8d38\u4ed8\u6c47\u7a0e\u52a1\u7ba1\u7406", "CalendarTaxType_27", "taxc-bdtaxr-common"), "2BOW55M9U7TH"),
    VAT_RTA("VAT_RTA", "", new MultiLangEnumBridge("\u9000\u7a0e\u7533\u8bf7\u8868", "CalendarTaxType_28", "taxc-bdtaxr-common"), "/RFP+MBMR+I6"),
    CIT_RTA("CITRTA", "", new MultiLangEnumBridge("\u4f01\u4e1a\u6240\u5f97\u7a0e\u6bd4\u5bf9\u5e95\u7a3f", "CalendarTaxType_29", "taxc-bdtaxr-common"), "/Z0U6BXKR4Y+"),
    GLJYSB("gljysb", "", new MultiLangEnumBridge("\u5173\u8054\u7533\u62a5\u8868", "CalendarTaxType_30", "taxc-bdtaxr-common"), "1NT97NG7251K"),
    GLJYDG("gljydg", "", new MultiLangEnumBridge("\u5173\u8054\u7533\u62a5\u5e95\u7a3f", "CalendarTaxType_31", "taxc-bdtaxr-common"), "1NT97NG7251K"),
    ETRSCSUM("etrscsum", "", null, "tcetr");

    private String type;
    private String value;
    private MultiLangEnumBridge bridge;
    private String operatecode;

    private CalendarTaxType(String type, String value, MultiLangEnumBridge bridge, String operatecode) {
        this.type = type;
        this.value = value;
        this.bridge = bridge;
        this.operatecode = operatecode;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public MultiLangEnumBridge getBridge() {
        return this.bridge;
    }

    public String getOperatecode() {
        return this.operatecode;
    }

    public static CalendarTaxType getValueByType(String type) {
        return EnumUtils.getEnumByPredicate(e -> e.getType().equalsIgnoreCase(type), CalendarTaxType::values);
    }

    public static CalendarTaxType getByName(String taxtypename) {
        return EnumUtils.getEnumByPredicate(e -> e.getBridge().getDescription().equalsIgnoreCase(taxtypename), CalendarTaxType::values);
    }

    public static boolean isSmallTax(String taxtype) {
        return CalendarTaxType.CCS.type.equals(taxtype) || CalendarTaxType.QS.type.equals(taxtype) || CalendarTaxType.CLGZS.type.equals(taxtype) || CalendarTaxType.GDZYS.type.equals(taxtype) || CalendarTaxType.TDZZS.type.equals(taxtype);
    }
}

