/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.enums;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;

public enum TaxableListEnum {
    ZZS(BaseTaxCategory.ZZS, "tcvat", "zzs", "zzs"),
    QYSDSNB(BaseTaxCategory.QYSDS, "tccit", "qysdsnb", "qysdsnb"),
    QYSDSJB(BaseTaxCategory.QYSDS, "tccit", "qysdsjb", "qysdsjb"),
    YHS(BaseTaxCategory.YHS, "tcret", "ccxws", ""),
    FCS(BaseTaxCategory.FCS, "tcret", "ccxws", ""),
    CZTDSYS(BaseTaxCategory.CZTDSYS, "tcret", "ccxws", ""),
    QS(BaseTaxCategory.QS, "tcret", "ccxws", ""),
    TDZZS(BaseTaxCategory.TDZZS, "tcret", "ccxws", ""),
    CCS(BaseTaxCategory.CCS, "tcret", "ccxws", ""),
    HBS(BaseTaxCategory.HBS, "tcret", "ccxws", ""),
    GHCBJ(BaseTaxCategory.QTSR, "totf", "qtsf_tysbb", ""),
    DWFHF(BaseTaxCategory.SLHSZXSR, "totf", "qtsf_tysbb", ""),
    LJCLF(BaseTaxCategory.JSXZSYXSFSR, "totf", "qtsf_fsstysbb", ""),
    SLJSJJFSS(BaseTaxCategory.SLHSZXSR, "totf", "qtsf_fsstysbb", ""),
    WHSYJSF(BaseTaxCategory.WHSYJSF, "totf", "whsyjsf", ""),
    CWBB_ND(BaseTaxCategory.CWBB, "tcvvt", "cwbbnd", ""),
    CWBB_FND(BaseTaxCategory.CWBB, "tcvvt", "cwbbfnd", ""),
    XFSJFJ(BaseTaxCategory.XFS, "tcct", "xfsjfj", ""),
    HW_QYSDS(0L, "gtcp", "hwqysds", "hwqysds"),
    HW_ZZS(0L, "gtcp", "hwzzs", "hwzzs");

    private Long baseTaxId;
    private String sbbCategory;
    private String dgCategory;
    private String appId;

    private TaxableListEnum(Long baseTaxId, String appId, String sbbCategory, String dgCategory) {
        this.baseTaxId = baseTaxId;
        this.sbbCategory = sbbCategory;
        this.dgCategory = dgCategory;
        this.appId = appId;
    }

    public Long getBaseTaxId() {
        return this.baseTaxId;
    }

    public String getSbbCategory() {
        return this.sbbCategory;
    }

    public String getDgCategory() {
        return this.dgCategory;
    }

    public String getAppId() {
        return this.appId;
    }

    public static List<TaxableListEnum> valueOfSbbCode(String sbbCategory) {
        return Arrays.stream(TaxableListEnum.values()).filter(a -> a.getSbbCategory().equals(sbbCategory)).collect(Collectors.toList());
    }

    public static List<TaxableListEnum> valueOfDgCode(String dgCategory) {
        return Arrays.stream(TaxableListEnum.values()).filter(a -> a.getDgCategory().equals(dgCategory)).collect(Collectors.toList());
    }

    @Deprecated
    public static TaxableListEnum valueOfTaxid(Long baseTaxId) {
        for (TaxableListEnum value : TaxableListEnum.values()) {
            if (!value.getBaseTaxId().equals(baseTaxId)) continue;
            return value;
        }
        return null;
    }

    public static List<TaxableListEnum> valuesOfTaxid(Long baseTaxId) {
        ArrayList<TaxableListEnum> taxableListEnums = new ArrayList<TaxableListEnum>();
        for (TaxableListEnum value : TaxableListEnum.values()) {
            if (!value.getBaseTaxId().equals(baseTaxId)) continue;
            taxableListEnums.add(value);
        }
        return taxableListEnums;
    }
}

