/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.formula.biz;

import java.util.Map;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.formula.service.CacheFormulaService;

public abstract class InitParams {
    private static Log logger = LogFactory.getLog(InitParams.class);
    private static final String cacheKey = "taxccachekey";

    public Map<String, String> setSelfParam(IPageCache cache, String type, String orgId, String startData, String endData) {
        logger.info("type:" + type + "; orgId:" + orgId + "; startData:" + startData + ";endData:" + endData);
        if (this.isExit(cache, type, orgId, startData, endData)) {
            this.deleteCache(cache);
        }
        return this.setBizParam(cache, type, orgId, startData, endData);
    }

    public boolean isExit(IPageCache cache, String type, String orgId, String startData, String endData) {
        if (null == cache) {
            return false;
        }
        String key = orgId + "_" + startData + "_" + endData + "_" + type;
        String str = cache.get(cacheKey);
        cache.put(cacheKey, key);
        return null != str && !key.equals(str);
    }

    public boolean deleteCache(IPageCache cache) {
        if (null != cache) {
            CacheUtils.getInstance().deleteCache(cache);
            CacheFormulaService.deleteCache(cache);
            this.deleteSelfCache(cache);
        }
        return true;
    }

    public abstract void deleteSelfCache(IPageCache var1);

    public abstract Map<String, String> setBizParam(IPageCache var1, String var2, String var3, String var4, String var5);
}

