/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.formula.biz.impl;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.formula.biz.InitParams;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tccit.common.DeclareCompanyTypeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class TccitSInitParams
extends InitParams {
    public static final String QYSDSYB = "qysdsyb";
    public static final String QYSDSJB = "qysdsjb";
    private static final String REGISTYEAR = "registyear";
    private static final String ADVANCE_PAY_MODE = "advancepaymode";
    private static final String BUSINESS_TYPE = "businesstype";
    private static final String REGISTMONTH = "registmonth";
    private static final String DECLARE_COMPANY_TYPE = "companytype";
    private static final String PREYEARSBBID = "preyearsbbid";
    private static final String PREPERIODSBBID = "preperiodsbbid";
    private static final String LASTYEAR_STARTDATE = "lastYearStartDate";
    private static final String LASTYEAR_ENDDATE = "lastYearEndDate";
    private static final String[] deleteKey = new String[]{"registyear", "registmonth", "advancepaymode", "businesstype", "companytype", "preyearsbbid"};

    @Override
    public void deleteSelfCache(IPageCache cache) {
        for (String key : deleteKey) {
            cache.remove(key);
        }
    }

    @Override
    public Map<String, String> setBizParam(IPageCache cache, String type, String orgId, String startData, String endData) {
        HashMap<String, String> param = new HashMap<String, String>();
        HashMap<String, Object> extendParams = new HashMap<String, Object>();
        extendParams.put("declarestatus", "declared");
        String preStartData = DateUtils.format(DateUtils.getFirstDateOfYear(DateUtils.addYear(DateUtils.stringToDate(startData), -1)));
        String preEndData = DateUtils.format(DateUtils.getLastDateOfYear(DateUtils.addYear(DateUtils.stringToDate(endData), -1)));
        DynamicObject preYear = YbnsrService.queryYbnsr(orgId, "qysdsnb", preStartData, preEndData, 0, extendParams);
        DynamicObject dynamicObject = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId)).getData();
        Date registertime = null;
        if (dynamicObject != null) {
            registertime = dynamicObject.getDate("registertime");
        }
        param.put(REGISTYEAR, registertime != null ? String.valueOf(DateUtils.getYearOfDate(registertime)) : "");
        param.put(REGISTMONTH, registertime != null ? String.valueOf(DateUtils.getMonthOfDate(registertime)) : "");
        param.put(ADVANCE_PAY_MODE, this.getAdvancePayMode(type, orgId, startData, endData));
        param.put(BUSINESS_TYPE, DeclareCompanyTypeUtils.getBusinesstype(orgId, startData, endData));
        param.put(DECLARE_COMPANY_TYPE, DeclareCompanyTypeUtils.getDeclareCompanyType(orgId, endData));
        param.put(PREYEARSBBID, preYear != null ? preYear.getString("id") : "");
        param.put(PREPERIODSBBID, this.getPrePeriodSbbid(orgId, startData, endData));
        param.put(LASTYEAR_STARTDATE, preStartData);
        param.put(LASTYEAR_ENDDATE, preEndData);
        return param;
    }

    private String getAdvancePayMode(String type, String orgId, String startDate, String endDate) {
        String sbbid = "";
        if (QYSDSYB.equals(type)) {
            sbbid = YbnsrService.queryYbnsrPre(orgId, QYSDSYB, startDate, endDate, -1);
        } else if (QYSDSJB.equals(type)) {
            sbbid = YbnsrService.queryYbnsrPre(orgId, QYSDSJB, startDate, endDate, -3);
        }
        QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)sbbid);
        QFilter rowFilter = new QFilter("ewblxh", "=", (Object)"1");
        DynamicObject dynamiczb = QueryServiceHelper.queryOne((String)"tccit_qysds_zb", (String)ADVANCE_PAY_MODE, (QFilter[])new QFilter[]{rowFilter, sbbidFilter});
        return dynamiczb != null ? dynamiczb.getString(ADVANCE_PAY_MODE) : "1";
    }

    private String getPrePeriodSbbid(String orgId, String startDate, String endDate) {
        if (Objects.equals(startDate, DateUtils.format(DateUtils.getFirstDateOfYear(DateUtils.stringToDate(startDate))))) {
            return "";
        }
        List<Date> dateList = DateUtils.getPreDate(DateUtils.stringToDate(startDate), DateUtils.stringToDate(endDate));
        QFilter dateFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate(DateUtils.format(dateList.get(0)))).and(new QFilter("skssqz", "=", (Object)DateUtils.stringToDate(DateUtils.format(dateList.get(1)))));
        QFilter typeFilter = new QFilter("type", "=", (Object)QYSDSJB);
        QFilter paystatusFilter = new QFilter("paystatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"paid", "nopay"}));
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgId));
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id", (QFilter[])new QFilter[]{dateFilter, orgFilter, typeFilter, paystatusFilter});
        if (CollectionUtils.isEmpty((Collection)objects)) {
            return "";
        }
        return ((DynamicObject)objects.get(0)).getString("id");
    }
}

