/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.formula.biz.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.initparam.DefaultInitParams;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import org.apache.commons.lang3.StringUtils;

public class TotfWhsyjsfInitParams
extends DefaultInitParams {
    private static final String SBBID = "sbbid";
    private static final String LAST_SBBID = "lastsbbid";
    private static final String ORGID = "orgid";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String YEAR = "year";
    private static final String MONTH = "month";
    private static final String BILLNO = "billno";
    private static final String RATE = "rate";
    private static final String TAXOFFICE = "taxoffice";
    private static final String ENTITY_NSRXX = "tcvat_nsrxx";

    @Override
    public Map<String, String> buildBizParam(DeclareRequestModel requestModel) {
        Map<String, String> param = super.buildBizParam(requestModel);
        Map<String, String> bizParam = this.setBizParam(requestModel.getBusinessMap(), String.valueOf(requestModel.getId()), requestModel.getTemplateType(), String.valueOf(requestModel.getOrgId()), requestModel.getSkssqq(), requestModel.getSkssqz());
        param.putAll(bizParam);
        return param;
    }

    public Map<String, String> setBizParam(Map<String, String> bizParams, String id, String type, String orgId, String startDate, String endDate) {
        HashMap<String, String> param = new HashMap<String, String>(32);
        param.put(SBBID, id);
        param.put(LAST_SBBID, this.getLastSbbid(type, orgId, startDate));
        param.put(ORGID, orgId);
        param.put(STARTDATE, startDate);
        param.put(ENDDATE, endDate);
        param.put(YEAR, String.valueOf(DateUtils.getYearOfDate(DateUtils.stringToDate(startDate))));
        param.put(MONTH, String.valueOf(DateUtils.getMonthOfDate(DateUtils.stringToDate(startDate))));
        param.put(BILLNO, bizParams.get(BILLNO));
        param.put(RATE, this.getRate(orgId, DateUtils.stringToDate(startDate), DateUtils.stringToDate(endDate)));
        param.put(TAXOFFICE, bizParams.get(TAXOFFICE));
        return param;
    }

    private String getLastSbbid(String type, String orgId, String date) {
        Date preMonth = DateUtils.addMonth(DateUtils.stringToDate(date), -1);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        String taxlimit = this.getTaxlimit(orgId, preMonth);
        Date startdate = null;
        Date enddate = null;
        switch (taxlimit) {
            case "month": {
                startdate = DateUtils.getFirstDateOfMonth(preMonth);
                enddate = DateUtils.getLastDateOfMonth(preMonth);
                break;
            }
            case "season": {
                startdate = DateUtils.getFirstDateOfSeason(preMonth);
                enddate = DateUtils.getLastDateOfSeason(preMonth);
                break;
            }
            case "halfyear": {
                startdate = DateUtils.getFirstDateOfHalfYear(preMonth);
                enddate = DateUtils.getLastDateOfHalfYear(preMonth);
                break;
            }
            case "year": {
                startdate = DateUtils.getFirstDateOfYear(preMonth);
                enddate = DateUtils.getLastDateOfYear(preMonth);
                break;
            }
            default: {
                startdate = DateUtils.stringToDate("1900-01-31");
                enddate = DateUtils.stringToDate("1900-01-01");
            }
        }
        qFilters.add(new QFilter("skssqq", "=", (Object)startdate).and(new QFilter("skssqz", "=", (Object)DateUtils.getDayFirst(enddate))));
        qFilters.add(new QFilter("type", "=", (Object)type));
        qFilters.add(new QFilter("org", "=", (Object)(orgId == null ? Long.valueOf(0L) : Long.valueOf(orgId))));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)ENTITY_NSRXX, (String)"id", (QFilter[])qFilters.toArray(new QFilter[qFilters.size()]));
        if (null != dynamicObject && StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("id"))) {
            return dynamicObject.getString("id");
        }
        return "0";
    }

    private DynamicObject getCard(String orgid, Date start, Date end) {
        Optional<DynamicObject> first;
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(Collections.singletonList(Long.parseLong(orgid)));
        if (EmptyCheckUtils.isNotEmpty(result.getData()) && (first = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("qtsfentity").stream().filter(d -> "0096".equals(d.getString("collectrate.number"))).filter(e -> this.isEffectiveDate(start, end, e.getDate("effectivestart"), e.getDate("effectiveend"))).findFirst()).isPresent()) {
            return first.get();
        }
        return null;
    }

    private String getTaxlimit(String orgid, Date date) {
        DynamicObject card = this.getCard(orgid, date, null);
        if (card != null) {
            return card.getString("taxperiod");
        }
        return "";
    }

    private String getRate(String orgid, Date start, Date end) {
        DynamicObject card = this.getCard(orgid, start, end);
        if (card != null) {
            BigDecimal bigDecimal = BigDecimalUtil.setScale(card.getBigDecimal("amountrate"), 6);
            return String.valueOf(bigDecimal);
        }
        return BigDecimal.ZERO.setScale(6, RoundingMode.HALF_UP).toPlainString();
    }

    private boolean isEffectiveDate(Date date1, Date date2, Date start, Date end) {
        Date enddate;
        Date startdate = new Date(start.getTime());
        Date date = enddate = end != null ? new Date(end.getTime()) : null;
        if (null == date2) {
            return startdate.equals(date1) ? true : DateUtils.isEffectiveDate(date1, startdate, enddate);
        }
        return !(!startdate.equals(date1) && !DateUtils.isEffectiveDate(date1, startdate, enddate) || !date2.equals(enddate) && !DateUtils.isEffectiveDate(date2, startdate, enddate));
    }
}

