/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.formula.context;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.formula.context.Content;
import kd.taxc.bdtaxr.common.formula.value.GetValueService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.parse.ParseUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public abstract class AbstractContent
implements Content {
    protected Map<String, String> param;
    protected Map<String, String> data;
    protected Map<String, FormulaVo> formulas;
    private GetValueService getValueService;
    private Map<String, String> sqlValues = new HashMap<String, String>();
    private Map<String, String> constValues = new HashMap<String, String>();
    private Map<String, String> paramValues = new HashMap<String, String>();
    protected Map<String, String> variableKey;
    protected Map<String, EntityField> allEntityFieldByType;

    public AbstractContent() {
        this.getValueService = new GetValueService(this);
    }

    public String parse(FormulaVo formulaVo) {
        if (StringUtils.isEmpty((String)formulaVo.getFormula())) {
            return this.putDefautData(formulaVo.getFormula());
        }
        String ret = formulaVo.getFormula();
        List<String> list = ParseUtils.parseformula(formulaVo.getFormula());
        for (String formula : list) {
            Map<String, String> map = ParseUtils.parseFormulaZKH(formula);
            String value = this.getValue(map, formulaVo);
            if ("2".equals(formulaVo.getFormulaType()) && StringUtil.isBlank((CharSequence)value)) {
                value = "0";
            }
            ret = ret.replace(formula, value);
        }
        return ret;
    }

    @Override
    public abstract String calculate(FormulaVo var1);

    public String getValue(Map<String, String> map, FormulaVo formulaVo) {
        return this.getValueService.getValue(ParseUtils.getType(map), ParseUtils.getValue(map));
    }

    @Override
    public Map<String, String> getParam() {
        return this.param;
    }

    @Override
    public Map<String, String> getData() {
        return this.data;
    }

    @Override
    public Map<String, FormulaVo> getFormulas() {
        return this.formulas;
    }

    @Override
    public Map<String, String> getSqlValues() {
        return this.sqlValues;
    }

    @Override
    public Map<String, String> getConstValues() {
        return this.constValues;
    }

    @Override
    public Map<String, String> getParamValues() {
        return this.paramValues;
    }

    public void setParamValues(Map<String, String> paramValues) {
        this.paramValues = paramValues;
    }

    @Override
    public Map<String, String> getVariableKey() {
        return this.variableKey;
    }

    @Override
    public Map<String, EntityField> getAllEntityFieldByType() {
        return this.allEntityFieldByType;
    }

    @Override
    public String putDefautData(Object formula) {
        this.data.put((String)formula, "0");
        return "0";
    }
}

