/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.formula.db.formula;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.taxdeclare.template.TemplateUtilsOld;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class QueryFormulaService {
    private static Log logger = LogFactory.getLog(QueryFormulaService.class);
    public static final String fields = "formulakey,table,row,column,formula,title,content,celltype,formulatype,formulaname,name,describe";
    public static final String entry = "tpo_formula_temp_edit";
    private static final String dbKey = "taxc";

    public static Map<String, FormulaVo> queryDBFormula(String type, String startData, String endData) {
        return QueryFormulaService.queryDBFormulaByType(type, "1", startData, endData);
    }

    public static Map<String, FormulaVo> queryCalDBFormulaByTemplateTypeId(String templateId) {
        ArrayList<QFilter> listFilters = new ArrayList<QFilter>();
        listFilters.add(new QFilter("formulatype", "=", (Object)"1").or("formulatype", "=", (Object)"4"));
        listFilters.add(new QFilter("templateid", "=", (Object)templateId));
        return QueryFormulaService.getFormulaVoMap(listFilters);
    }

    public static List<FormulaVo> queryDBFormulaType(String type, String startData, String endData, String templateid) {
        return QueryFormulaService.queryDBFormulaListByType(type, "2", startData, endData, templateid);
    }

    public static List<FormulaVo> queryDBCellConfig(String type, String startData, String endData, String templateid) {
        return QueryFormulaService.queryDBFormulaListByType(type, "3", startData, endData, templateid);
    }

    public static Map<String, FormulaVo> queryDBFormulaByTypeId(String templateId, String formualType) {
        ArrayList<QFilter> listFilters = new ArrayList<QFilter>();
        listFilters.add(new QFilter("formulatype", "=", (Object)formualType));
        listFilters.add(new QFilter("templateid", "=", (Object)templateId));
        return QueryFormulaService.getFormulaVoMap(listFilters);
    }

    private static Map<String, FormulaVo> queryDBFormulaByType(String type, String formualType, String startData, String endData) {
        QFilter q = new QFilter("taxtype", "=", (Object)type);
        QFilter q1 = new QFilter("formulatype", "=", (Object)formualType);
        QFilter t = new QFilter("formulatype", "=", (Object)"4");
        ArrayList<QFilter> listFilters = new ArrayList<QFilter>();
        listFilters.add(q);
        listFilters.add(q1.or(t));
        DynamicObject dynamicObject = TemplateUtilsOld.getTemplateObject(type, DateUtils.stringToDate(startData, "yyyy-MM-dd"), DateUtils.stringToDate(startData, "yyyy-MM-dd"));
        if (null != dynamicObject) {
            QFilter q2 = new QFilter("templateid", "=", (Object)dynamicObject.getString("id"));
            listFilters.add(q2);
        }
        return QueryFormulaService.getFormulaVoMap(listFilters);
    }

    public static Map<String, FormulaVo> getFormulaVoMap(List<QFilter> listFilters) {
        HashMap<String, FormulaVo> map = new HashMap<String, FormulaVo>();
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entry, (String)fields, (QFilter[])listFilters.toArray(new QFilter[listFilters.size()]));
        for (DynamicObject object : doc) {
            FormulaVo formulaVo = QueryFormulaService.buildFormulaVo(object);
            map.put(formulaVo.getFormulaKey(), formulaVo);
        }
        return map;
    }

    private static List<FormulaVo> queryDBFormulaListByType(String type, String formualType, String startData, String endData, String templateid) {
        DynamicObject dynamicObject;
        ArrayList<FormulaVo> list = new ArrayList<FormulaVo>();
        ArrayList<QFilter> listFilters = new ArrayList<QFilter>();
        if (StringUtil.isNotEmpty((CharSequence)type)) {
            QFilter q = new QFilter("taxtype", "=", (Object)type);
            listFilters.add(q);
        }
        if (StringUtil.isNotEmpty((CharSequence)formualType)) {
            QFilter q1 = new QFilter("formulatype", "=", (Object)formualType);
            listFilters.add(q1);
        }
        if (StringUtil.isNotEmpty((CharSequence)templateid)) {
            QFilter q2 = new QFilter("templateid", "=", (Object)templateid);
            listFilters.add(q2);
        } else if (StringUtil.isNotEmpty((CharSequence)type) && StringUtil.isNotEmpty((CharSequence)startData) && StringUtil.isNotEmpty((CharSequence)endData) && null != (dynamicObject = TemplateUtilsOld.getTemplateObject(type, DateUtils.stringToDate(startData, "yyyy-MM-dd"), DateUtils.stringToDate(startData, "yyyy-MM-dd")))) {
            QFilter q2 = new QFilter("templateid", "=", (Object)dynamicObject.getString("id"));
            listFilters.add(q2);
        }
        if (listFilters.size() > 0) {
            DynamicObjectCollection doc = QueryServiceHelper.query((String)entry, (String)fields, (QFilter[])listFilters.toArray(new QFilter[listFilters.size()]));
            for (DynamicObject object : doc) {
                list.add(QueryFormulaService.buildFormulaVo(object));
            }
        }
        return list;
    }

    public static List<Map<String, Object>> executeQuery(String sql) {
        try (TXHandle handle = TX.notSupported((String)"kd.taxc.common.formula.db.formula.QueryFormulaService#executeQuery");){
            List list;
            List list2 = list = (List)DB.query((DBRoute)DBRoute.of((String)dbKey), (String)sql, (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

                public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(rs.getRow());
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int columnCount = rsmd.getColumnCount();
                    while (rs.next()) {
                        HashMap<String, Object> hm = new HashMap<String, Object>(columnCount);
                        for (int i = 0; i < columnCount; ++i) {
                            String columnName = rsmd.getColumnName(i + 1);
                            Object columnValue = rs.getObject(i + 1);
                            hm.put(columnName.toUpperCase(), columnValue);
                        }
                        list.add(hm);
                    }
                    return list;
                }
            });
            return list2;
        }
    }

    public static String query(String sql) {
        try {
            Map.Entry<String, Object> entry;
            Map<String, Object> map;
            Iterator<Map.Entry<String, Object>> iterator;
            List<Map<String, Object>> list = QueryFormulaService.executeQuery(sql);
            if (null != list && list.size() > 0 && (iterator = (map = list.get(0)).entrySet().iterator()).hasNext() && null != (entry = iterator.next()).getValue()) {
                if (entry.getValue() instanceof BigDecimal) {
                    return DataFormatUtils.decimalFormat((BigDecimal)entry.getValue());
                }
                if (entry.getValue() instanceof Double) {
                    return DataFormatUtils.decimalFormat(BigDecimal.valueOf((Double)entry.getValue()));
                }
                return entry.getValue().toString();
            }
        }
        catch (Exception e) {
            logger.error("----query sql----------:" + sql);
            logger.error("-----query executeQuery---------", (Throwable)e);
        }
        return "0";
    }

    public static List<Map<String, Object>> queryUnion(String sql) {
        try {
            List<Map<String, Object>> list = QueryFormulaService.executeQuery(sql);
            ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
            if (null != list && list.size() > 0) {
                for (Map<String, Object> map : list) {
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        HashMap<String, Object> m = new HashMap<String, Object>();
                        if (map.size() == 1 && "K".equals(entry.getKey())) {
                            m.put((String)map.get("K"), "0");
                            data.add(m);
                            continue;
                        }
                        if ("K".equals(entry.getKey())) continue;
                        m.put((String)map.get("K"), entry.getValue());
                        data.add(m);
                    }
                }
            }
            return data;
        }
        catch (Exception e) {
            logger.error("----queryUnion sql----------:" + sql);
            logger.error("-----queryUnion executeQuery---------", (Throwable)e);
            logger.info("sql\u6267\u884c\u6709\u8bef---------------------");
            return null;
        }
    }

    public static boolean deleteFormulaByKeyAndType(String formulaType, String formulaKey, String templateId) {
        QFilter qFilter = new QFilter("formulakey", "=", (Object)formulaKey);
        QFilter qFilte2 = new QFilter("formulatype", "=", (Object)formulaType);
        QFilter qFilte3 = new QFilter("templateid", "=", (Object)templateId);
        QFilter[] qFilters = new QFilter[]{qFilter, qFilte2, qFilte3};
        DeleteServiceHelper.delete((String)entry, (QFilter[])qFilters);
        return true;
    }

    public static List<FormulaVo> queryDBFormulaByFormulaKey(String formulaType, String formulaKey, String templateId) {
        ArrayList<FormulaVo> list = new ArrayList<FormulaVo>();
        QFilter q = new QFilter("formulakey", "=", (Object)formulaKey);
        QFilter q1 = new QFilter("formulatype", "=", (Object)formulaType);
        QFilter t = new QFilter("formulatype", "=", (Object)"4");
        QFilter q2 = new QFilter("templateid", "=", (Object)templateId);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entry, (String)fields, (QFilter[])new QFilter[]{q, q1.or(t), q2});
        for (DynamicObject object : doc) {
            list.add(QueryFormulaService.buildFormulaVo(object));
        }
        return list;
    }

    private static FormulaVo buildFormulaVo(DynamicObject dynObj) {
        FormulaVo formulaVo = new FormulaVo();
        String key = dynObj.getString("formulakey");
        String formula = dynObj.getString("formula");
        formulaVo.setFormula(formula);
        formulaVo.setFormulaKey(key);
        formulaVo.setFormulaType(dynObj.getString("formulatype"));
        formulaVo.setCellType(dynObj.getString("celltype"));
        String formulaname = dynObj.getString("formulaname");
        formulaVo.setFormulaName(StringUtil.isNotEmpty((CharSequence)formulaname) ? formulaname.replace("\t", "") : formulaname);
        formulaVo.setContent(dynObj.getString("content"));
        String title = dynObj.getString("title");
        formulaVo.setTitle(title);
        formulaVo.setName(dynObj.getString("name"));
        formulaVo.setTable(dynObj.getString("table"));
        formulaVo.setRow(dynObj.getString("row"));
        formulaVo.setColumn(dynObj.getString("column"));
        formulaVo.setDescribe(dynObj.getString("describe"));
        return formulaVo;
    }
}

