/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.formula.parse;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.formula.db.formula.QueryFormulaService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.parse.ParseUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class ParseFormulaService {
    private Map<String, FormulaVo> formulas = new HashMap<String, FormulaVo>();
    private Map<String, String> sformulas = new HashMap<String, String>();
    private Map<String, String> cformulas = new HashMap<String, String>();
    private Map<String, Map<String, String>> qformulas = new HashMap<String, Map<String, String>>();
    private String templateId;

    public ParseFormulaService(String templateId) {
        this.templateId = templateId;
    }

    public void parse() {
        if (StringUtil.isNotEmpty((CharSequence)this.templateId)) {
            this.formulas = QueryFormulaService.queryCalDBFormulaByTemplateTypeId(this.templateId);
            for (Map.Entry<String, FormulaVo> formula : this.formulas.entrySet()) {
                this.parse(formula.getValue());
            }
        }
    }

    public void parse(FormulaVo formulaVo) {
        if (!StringUtils.isEmpty((String)formulaVo.getFormula())) {
            List<String> list = ParseUtils.parseformula(formulaVo.getFormula());
            for (String formula : list) {
                Map<String, String> map = ParseUtils.parseFormulaZKH(formula);
                this.classFormula(formulaVo.getFormulaKey(), ParseUtils.getType(map), ParseUtils.getValue(map));
            }
        }
    }

    private void classFormula(String key, String type, String value) {
        switch (type) {
            case "S": {
                String md5 = StringUtil.getMd5(value);
                this.sformulas.put(md5, value);
                break;
            }
            case "C": {
                this.cformulas.put(value, value);
                break;
            }
            case "Q": {
                Map<String, String> temp = this.qformulas.get(value);
                if (null == temp) {
                    temp = new HashMap<String, String>();
                    this.qformulas.put(value, temp);
                }
                temp.put(key, key);
                break;
            }
        }
    }

    public Map<String, FormulaVo> getFormulas() {
        return this.formulas;
    }

    public Map<String, String> getSformulas() {
        return this.sformulas;
    }

    public Map<String, String> getCformulas() {
        return this.cformulas;
    }

    public Map<String, Map<String, String>> getQformulas() {
        return this.qformulas;
    }
}

