/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.ExrateConvertDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class ExrateConvertHelper {
    private static final Log logger = LogFactory.getLog(ExrateConvertHelper.class);
    public static final String EXRATE_FIELD_NAME = "exrate";
    private static final String EXRATE_TABLE_FORMID = "bd_exratetable";
    private static final String EXRATE_FORMID = "bd_exrate_tree";
    private static final String EXCVAL = "excval";
    private static final String INDIRECTEXRATE = "indirectexrate";
    private static final String SELECT_FIELDS = "exctable, cur, orgcur, precision, excval, indirectexrate, effectdate";
    private static final String EXRATELOGIC_ENDAVG = "endavg";
    private static final String EXRATELOGIC_END = "end";
    private static final String EXRATELOGIC_START = "start";

    public static BigDecimal calcExrate(String exrateJson, Date start, Date end) {
        ExrateConvertDto exrateConvertDto;
        BigDecimal result = BigDecimal.ZERO;
        if (StringUtil.isNotBlank((CharSequence)exrateJson) && (exrateConvertDto = ExrateConvertHelper.getExrateConvertDto(exrateJson)) != null) {
            String exratelogic = exrateConvertDto.getExratelogic();
            String exratetype = exrateConvertDto.getExratetype();
            String targetcoin = exrateConvertDto.getTargetcoin();
            String originalcoin = exrateConvertDto.getOriginalcoin();
            String exratetable = exrateConvertDto.getExratetable();
            if (exrateConvertDto.getConvertrate().booleanValue() && StringUtil.isNotEmpty((CharSequence)exratetable) && StringUtil.isNotEmpty((CharSequence)originalcoin) && StringUtil.isNotEmpty((CharSequence)targetcoin) && StringUtil.isNotEmpty((CharSequence)exratetype) && StringUtil.isNotEmpty((CharSequence)exratelogic)) {
                Date startDate = DateUtils.getFirstDateOfMonth(start);
                Date endDate = DateUtils.getLastDateOfMonth(end);
                QFilter effectdate = new QFilter("effectdate", ">=", (Object)startDate).and("effectdate", "<=", (Object)endDate);
                QFilter qFilter = new QFilter("exctable", "=", (Object)Long.parseLong(exratetable)).and("orgcur", "=", (Object)Long.parseLong(originalcoin)).and("cur", "=", (Object)Long.parseLong(targetcoin)).and(effectdate);
                qFilter.and("enable", "=", (Object)"1");
                DynamicObjectCollection records = QueryServiceHelper.query((String)EXRATE_FORMID, (String)SELECT_FIELDS, (QFilter[])qFilter.toArray(), (String)"effectdate asc");
                if (records.size() > 0) {
                    String exrateProp = exratetype.equalsIgnoreCase("direct") ? EXCVAL : INDIRECTEXRATE;
                    switch (exratelogic) {
                        case "start": {
                            DynamicObject dynamicObject = (DynamicObject)records.get(0);
                            result = dynamicObject.getBigDecimal(exrateProp).setScale(6, 4);
                            break;
                        }
                        case "end": {
                            DynamicObject dynamicObject1 = (DynamicObject)records.get(records.size() - 1);
                            result = dynamicObject1.getBigDecimal(exrateProp).setScale(6, 4);
                            break;
                        }
                        case "endavg": {
                            int num = 0;
                            BigDecimal sum = BigDecimal.ZERO;
                            Map<String, List<DynamicObject>> group = records.stream().collect(Collectors.groupingBy(a -> DateUtils.format(a.getDate("effectdate"), "yyyy-MM")));
                            for (Map.Entry<String, List<DynamicObject>> entry : group.entrySet()) {
                                List<DynamicObject> list = entry.getValue();
                                if (list.size() <= 0) continue;
                                Collections.sort(list, Comparator.comparing(c -> c.getDate("effectdate")));
                                DynamicObject record = list.get(list.size() - 1);
                                ++num;
                                sum = sum.add(record.getBigDecimal(exrateProp));
                            }
                            if (num <= 0) break;
                            result = sum.divide(new BigDecimal(num), 6, 4);
                        }
                    }
                }
            }
        }
        return result;
    }

    private static ExrateConvertDto getExrateConvertDto(String exrateJson) {
        try {
            return (ExrateConvertDto)SerializationUtils.fromJsonString((String)exrateJson, ExrateConvertDto.class);
        }
        catch (Exception e) {
            logger.error("getExrateConvertDto error :{}", (Object)exrateJson);
            return null;
        }
    }
}

