/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.helper.TaxcParamsConfigHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TzDialogValidHelper {
    private static final Log LOGGER = LogFactory.getLog(TzDialogValidHelper.class);
    private static final String CARDENTITY_KEY = "CARDENTITY_KEY";
    private static final String TZSM_KEY = "TZSM_KEY";
    private static final String CARD_TOTALAMOUNT_KEY = "CARD_TOTALAMOUNT_KEY";
    private static final String CARD_ORIGINAMOUNT_KEY = "CARD_ORIGINAMOUNT_KEY";
    private static final HashMap<String, Map<String, String>> DIALOG_FIELD_KEY_MAP = new HashMap(){
        {
            HashMap<String, String> hashMap1 = new HashMap<String, String>();
            hashMap1.put(TzDialogValidHelper.CARDENTITY_KEY, "entryentitycard");
            hashMap1.put(TzDialogValidHelper.TZSM_KEY, "cardtzsm");
            hashMap1.put(TzDialogValidHelper.CARD_TOTALAMOUNT_KEY, "cardtotalamount");
            hashMap1.put(TzDialogValidHelper.CARD_ORIGINAMOUNT_KEY, "cardoriginamount");
            this.put("tcvat_accdetail_list", hashMap1);
        }
    };

    public static boolean validTzsmMustInput(AbstractFormPlugin plugin) {
        Map<String, String> map = DIALOG_FIELD_KEY_MAP.get(plugin.getView().getEntityId());
        String cardEntityKey = map.get(CARDENTITY_KEY);
        String tzsmKey = map.get(TZSM_KEY);
        String cardtotalamountKey = map.get(CARD_TOTALAMOUNT_KEY);
        String cardoriginamountKey = map.get(CARD_ORIGINAMOUNT_KEY);
        if (map != null && StringUtil.isNotEmpty((CharSequence)cardEntityKey) && StringUtil.isNotEmpty((CharSequence)tzsmKey) && StringUtil.isNotEmpty((CharSequence)cardtotalamountKey) && StringUtil.isNotEmpty((CharSequence)cardoriginamountKey)) {
            return TzDialogValidHelper.validTzsmMustInput(plugin, cardEntityKey, tzsmKey, cardtotalamountKey, cardoriginamountKey);
        }
        return true;
    }

    public static boolean validTzsmMustInput(AbstractFormPlugin plugin, String cardEntityKey, String tzsmKey, String cardtotalamountKey, String cardoriginamountKey) {
        boolean success = true;
        String tzsmbl = TaxcParamsConfigHelper.queryParamsConfig("tzsmbl");
        if ("true".equals(tzsmbl)) {
            CardEntry cardEntry = (CardEntry)plugin.getControl(cardEntityKey);
            DynamicObjectCollection entryEntity = plugin.getView().getModel().getEntryEntity(cardEntityKey);
            for (DynamicObject row : entryEntity) {
                int index = row.getInt("seq") - 1;
                BigDecimal cardtotalamount = row.getBigDecimal(cardtotalamountKey);
                BigDecimal cardoriginamount = row.getBigDecimal(cardoriginamountKey);
                String tzsm = row.getString(tzsmKey);
                String fc = "black";
                if (!Objects.equals(cardtotalamount, cardoriginamount) && StringUtil.isEmpty((CharSequence)tzsm)) {
                    success = false;
                    fc = "red";
                }
                HashMap<String, String> propertiesMap = new HashMap<String, String>(8);
                HashMap<String, HashMap<String, String>> properties = new HashMap<String, HashMap<String, String>>(8);
                propertiesMap.put("fc", fc);
                properties.put(tzsmKey, propertiesMap);
                cardEntry.setCustomProperties(cardEntityKey, index, properties);
            }
            if (!success) {
                plugin.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u8bf4\u660e\u4e3a\u5fc5\u586b\u9879\uff0c\u8bf7\u5f55\u5165\u503c\u3002", (String)"TzDialogValidHelper_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
        }
        return success;
    }
}

