/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.impt;

import com.google.common.collect.Lists;
import java.util.List;
import kd.taxc.bdtaxr.common.impt.TcvatEntryEntityVatRateEnum;

public enum TcvatRuleEntryEntityEnum {
    TCVAT_RULE_INCOME("tcvat_rule_income", TcvatRuleEntryEntityEnum.getTcvatRuleIncomeEntryList()),
    TCVAT_RULE_DEDUCTION("tcvat_rule_deduction", TcvatRuleEntryEntityEnum.getTcvatRuleDeductionEntryList()),
    TCVAT_RULE_DEDUCT("tcvat_rule_deduct", TcvatRuleEntryEntityEnum.getTcvatRuleDeductEntryList()),
    TCVAT_RULE_JZJTSE("tcvat_rule_jzjt_jxse", TcvatRuleEntryEntityEnum.getTcvatRuleJZJTSEEntryList()),
    TCVAT_RULE_APPORTION("tcvat_rule_apportion", TcvatRuleEntryEntityEnum.getTcvatRuleApportionEntryList()),
    TCVAT_RULE_REFUND("tcvat_rule_refund", TcvatRuleEntryEntityEnum.getTcvatRuleRefundEntryList()),
    TCVAT_RULE_INCOMEPROJECT("tcvat_rule_incomeproject", null),
    TCVAT_RULE_MDTS("tcvat_rule_mdts", TcvatRuleEntryEntityEnum.getTcvatRuleMdtsEntryList()),
    DEFAULT;

    private String ruleType;
    private List<TcvatEntryEntityVatRateEnum> entryList;

    public static boolean containsKey(String ruleType) {
        for (TcvatRuleEntryEntityEnum value : TcvatRuleEntryEntityEnum.values()) {
            if (!ruleType.equals(value.ruleType)) continue;
            return true;
        }
        return false;
    }

    public static List<TcvatEntryEntityVatRateEnum> get(String ruleType) {
        for (TcvatRuleEntryEntityEnum value : TcvatRuleEntryEntityEnum.values()) {
            if (!ruleType.equals(value.ruleType)) continue;
            return value.entryList;
        }
        return Lists.newArrayList();
    }

    public static TcvatRuleEntryEntityEnum match(String ruleType) {
        for (TcvatRuleEntryEntityEnum value : TcvatRuleEntryEntityEnum.values()) {
            if (!ruleType.equals(value.ruleType)) continue;
            return value;
        }
        return DEFAULT;
    }

    public static boolean isNeedCheckVatRateNot0(String ruleType) {
        return TcvatRuleEntryEntityEnum.TCVAT_RULE_INCOME.ruleType.equals(ruleType) || TcvatRuleEntryEntityEnum.TCVAT_RULE_DEDUCT.ruleType.equals(ruleType) || TcvatRuleEntryEntityEnum.TCVAT_RULE_JZJTSE.ruleType.equals(ruleType) || TcvatRuleEntryEntityEnum.TCVAT_RULE_REFUND.ruleType.equals(ruleType) || TcvatRuleEntryEntityEnum.TCVAT_RULE_MDTS.ruleType.equals(ruleType);
    }

    public String getRuleType() {
        return this.ruleType;
    }

    public void setRuleType(String ruleType) {
        this.ruleType = ruleType;
    }

    public List<TcvatEntryEntityVatRateEnum> getEntryList() {
        return this.entryList;
    }

    public void setEntryList(List<TcvatEntryEntityVatRateEnum> entryList) {
        this.entryList = entryList;
    }

    private TcvatRuleEntryEntityEnum(String ruleType, List<TcvatEntryEntityVatRateEnum> entryList) {
        this.ruleType = ruleType;
        this.entryList = entryList;
    }

    private TcvatRuleEntryEntityEnum() {
    }

    static List<TcvatEntryEntityVatRateEnum> getTcvatRuleIncomeEntryList() {
        return Lists.newArrayList((Object[])new TcvatEntryEntityVatRateEnum[]{TcvatEntryEntityVatRateEnum.TCVAT_RULE_INCOME_ENTRYENTITY11, TcvatEntryEntityVatRateEnum.TCVAT_RULE_INCOME_ENTRYENTITY, TcvatEntryEntityVatRateEnum.TCVAT_RULE_INCOME_ENTRYENTITY3});
    }

    static List<TcvatEntryEntityVatRateEnum> getTcvatRuleDeductEntryList() {
        return Lists.newArrayList((Object[])new TcvatEntryEntityVatRateEnum[]{TcvatEntryEntityVatRateEnum.TCVAT_RULE_DEDUCT_ENTRYENTITY, TcvatEntryEntityVatRateEnum.TCVAT_RULE_DEDUCT_ENTRYENTITY1});
    }

    static List<TcvatEntryEntityVatRateEnum> getTcvatRuleJZJTSEEntryList() {
        return Lists.newArrayList((Object[])new TcvatEntryEntityVatRateEnum[]{TcvatEntryEntityVatRateEnum.TCVAT_RULE_JZJTSE_ENTRYENTITY, TcvatEntryEntityVatRateEnum.TCVAT_RULE_JZJTSE_ENTRYENTITY1});
    }

    static List<TcvatEntryEntityVatRateEnum> getTcvatRuleDeductionEntryList() {
        return Lists.newArrayList((Object[])new TcvatEntryEntityVatRateEnum[]{TcvatEntryEntityVatRateEnum.DEFAULT});
    }

    static List<TcvatEntryEntityVatRateEnum> getTcvatRuleApportionEntryList() {
        return Lists.newArrayList((Object[])new TcvatEntryEntityVatRateEnum[]{TcvatEntryEntityVatRateEnum.TCVAT_RULE_APPORTION_ENTRYENTITY1, TcvatEntryEntityVatRateEnum.TCVAT_RULE_APPORTION_ENTRYENTITY12, TcvatEntryEntityVatRateEnum.TCVAT_RULE_APPORTION_ENTRYENTITY11});
    }

    static List<TcvatEntryEntityVatRateEnum> getTcvatRuleRefundEntryList() {
        return Lists.newArrayList((Object[])new TcvatEntryEntityVatRateEnum[]{TcvatEntryEntityVatRateEnum.TCVAT_RULE_REFUND_ENTRYENTITY1, TcvatEntryEntityVatRateEnum.TCVAT_RULE_REFUND_ENTRYENTITY2});
    }

    static List<TcvatEntryEntityVatRateEnum> getTcvatRuleMdtsEntryList() {
        return Lists.newArrayList((Object[])new TcvatEntryEntityVatRateEnum[]{TcvatEntryEntityVatRateEnum.TCVAT_RULE_MDTS_ENTRYENTITY});
    }
}

