/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.license;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.taxc.bdtaxr.common.util.crypto.MD5;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class LicenseGroupUtil {
    private static final Log LOGGER = LogFactory.getLog(LicenseGroupUtil.class);
    public static final int license_1 = 50;
    private static final String P_WORD = "";
    private static boolean TAXCB = true;
    private static boolean TAXCP = true;
    private static boolean TAXCM = true;
    private static Date date = DateUtils.stringToDate("2021-12-31");

    public static TreeNode getLicenseNum(TreeNode treeNode) {
        String groupId = treeNode.getId();
        if (null == groupId) {
            return null;
        }
        DynamicObjectCollection group = QueryServiceHelper.query((String)"tctb_license_group", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Integer.parseInt(groupId))});
        DynamicObjectCollection assignedCount = QueryServiceHelper.query((String)"tctb_license_from", (String)"id,unifiedsocialcode", (QFilter[])new QFilter[]{new QFilter("group", "=", (Object)Integer.parseInt(groupId)), new QFilter("licensestatus", "=", (Object)"B")});
        int totalCount = LicenseGroupUtil.getTotalNumber(groupId + P_WORD);
        if ("4.0".equals(LicenseGroupUtil.getVersion())) {
            if (group.size() > 0 && "38".equals(groupId)) {
                treeNode.setText(((DynamicObject)group.get(0)).getString("name") + "(" + assignedCount.size() + "/" + totalCount + ")");
            } else {
                String text = treeNode.getText();
                treeNode.setText(text);
            }
        } else if (group.size() > 0) {
            treeNode.setText(((DynamicObject)group.get(0)).getString("name") + "(" + assignedCount.size() + "/" + totalCount + ")");
        } else {
            treeNode.setText(treeNode.getText() + "(" + assignedCount.size() + "/" + totalCount + ")");
        }
        return treeNode;
    }

    public static String password(DynamicObject dos, String group) {
        String temp = group + P_WORD + dos.getString("orgid") + P_WORD + dos.getString("unifiedsocialcode") + P_WORD + dos.getString("licensestatus") + P_WORD;
        String md5 = MD5.md5(temp);
        return md5;
    }

    public static boolean getTAXB() {
        return TAXCB;
    }

    public static boolean getTaxcp() {
        return TAXCP;
    }

    public static boolean getTaxcm() {
        return TAXCM;
    }

    private static boolean isTime() {
        return new Date().getTime() > date.getTime();
    }

    public static String changeGruopid(String groupId) {
        if ("35".equals(groupId)) {
            return "87";
        }
        if ("37".equals(groupId)) {
            return "88";
        }
        if ("38".equals(groupId)) {
            return "406";
        }
        if ("39".equals(groupId)) {
            return "407";
        }
        return groupId;
    }

    public static int getTotalNumber(String groupId) {
        int sum = LicenseServiceHelper.getTotalNumber((Object)LicenseGroupUtil.changeGruopid(groupId + P_WORD));
        if ("1.0".equals(LicenseServiceHelper.getProductVersion()) && sum == 0) {
            sum = 50;
        }
        return sum;
    }

    public static boolean checkTxftPerformGroup() {
        return LicenseServiceHelper.checkPerformGroup((String)"TXFT").getHasLicense();
    }

    public static LicenseCheckResult checkTxftPerformGroup(String code) {
        if ("4.0".equals(LicenseGroupUtil.getVersion())) {
            LicenseCheckResult s = LicenseServiceHelper.checkPerformGroup((String)"TAXB");
            if (s.getHasLicense().booleanValue()) {
                LOGGER.info("taxc-ProductVersion-code:" + code);
                String appid = BizAppServiceHelp.getAppIdByAppNumber((String)code.toUpperCase());
                LOGGER.info("taxc-ProductVersion-code1:" + appid);
                if (null == appid || P_WORD.equals(appid)) {
                    appid = BizAppServiceHelp.getAppIdByAppNumber((String)code);
                }
                LOGGER.info("taxc-ProductVersion-code2:" + appid);
                return LicenseServiceHelper.checkLicenseModules((String)appid);
            }
            return s;
        }
        LicenseCheckResult s = new LicenseCheckResult();
        s.setHasLicense(Boolean.valueOf(true));
        return s;
    }

    public static String getVersion() {
        String ver = LicenseServiceHelper.getProductVersion();
        LOGGER.info("taxc-ProductVersion-:" + ver);
        if (ver.equals("4.0")) {
            return ver;
        }
        return "3.0";
    }

    public static Map<String, String> getGmLicense() {
        String ver = LicenseServiceHelper.getProductVersion();
        HashMap<String, String> map = new HashMap<String, String>();
        if (ver.equals("4.0")) {
            HashMap<String, String> groupName = new HashMap<String, String>();
            HashMap<String, String> bizlist = new HashMap<String, String>();
            Set set = LicenseServiceHelper.getLicenseModules();
            HashMap<String, String> setmap = new HashMap<String, String>();
            LOGGER.info("taxc-ProductVersion-set:" + set);
            if (null != set) {
                LOGGER.info("taxc-ProductVersion-set:" + set.size());
                for (Object s : set) {
                    setmap.put(((String)s).toLowerCase(), ((String)s).toLowerCase());
                    LOGGER.info("taxc-LicenseGroupUtil-s:" + ((String)s).toLowerCase());
                }
            }
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"tctb_license_group", (String)"id,number", null);
            for (Object d : doc) {
                LOGGER.info("taxc-LicenseGroupUtil-groupName:" + d.getString("number").toLowerCase() + ";" + d.getString("id").toLowerCase());
                groupName.put(d.getString("number").toLowerCase(), d.getString("id").toLowerCase());
            }
            if (groupName.size() > 0) {
                DynamicObjectCollection bizap = BizAppServiceHelp.getAllBizApps();
                for (DynamicObject biz : bizap) {
                    LOGGER.info("taxc-LicenseGroupUtil-number:" + biz.getString("number").toLowerCase() + ";" + biz.getString("id").toLowerCase());
                    if (null == groupName.get(biz.getString("number").toLowerCase())) continue;
                    bizlist.put(biz.getString("id").toLowerCase(), biz.getString("number").toLowerCase());
                }
            }
            for (Map.Entry s : bizlist.entrySet()) {
                String value;
                LOGGER.info("taxc-LicenseGroupUtil:" + (String)s.getKey() + ";" + (String)s.getValue());
                if (null == setmap.get(s.getKey()) || null == (value = (String)groupName.get(s.getValue()))) continue;
                LOGGER.info("taxc-LicenseGroupUtil:" + value);
                map.put(value, value);
            }
        }
        return map;
    }
}

